/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import java.io.File;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockMenu
extends ChestMenu {
    BlockMenuPreset preset;
    Location l;
    public int changes = 0;
    private ItemManipulationEvent event;

    private static String serializeLocation(Location l) {
        return String.valueOf(l.getWorld().getName()) + ";" + l.getBlockX() + ";" + l.getBlockY() + ";" + l.getBlockZ();
    }

    public BlockMenu(BlockMenuPreset preset, Location l) {
        super(preset.getTitle());
        this.preset = preset;
        this.l = l;
        this.changes = 1;
        preset.clone(this);
        this.getContents();
    }

    public BlockMenu(BlockMenuPreset preset, Location l, Config cfg) {
        super(preset.getTitle());
        this.preset = preset;
        this.l = l;
        int i = 0;
        while (i < 54) {
            if (cfg.contains(String.valueOf(i))) {
                this.addItem(i, cfg.getItem(String.valueOf(i)));
            }
            ++i;
        }
        preset.clone(this);
        if (preset.getSize() > -1 && !preset.getPresetSlots().contains(preset.getSize() - 1) && cfg.contains(String.valueOf(preset.getSize() - 1))) {
            this.addItem(preset.getSize() - 1, cfg.getItem(String.valueOf(preset.getSize() - 1)));
        }
        this.getContents();
    }

    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public void save(Location l) {
        if (this.changes == 0) {
            return;
        }
        this.getContents();
        File file = new File("data-storage/Slimefun/stored-inventories/" + BlockMenu.serializeLocation(l) + ".sfi");
        Config cfg = new Config(file);
        cfg.setValue("preset", (Object)this.preset.getID());
        for (int slot : this.preset.getInventorySlots()) {
            cfg.setValue(String.valueOf(slot), (Object)this.getItemInSlot(slot));
        }
        cfg.save();
        this.changes = 0;
    }

    public void move(Block b) {
        this.delete(this.l);
        this.l = b.getLocation();
        this.preset.newInstance(this, b);
        this.save(b.getLocation());
    }

    public Block getBlock() {
        return this.l.getBlock();
    }

    public Location getLocation() {
        return this.l;
    }

    public void delete(Location l) {
        new File("data-storage/Slimefun/stored-inventories/" + BlockMenu.serializeLocation(l) + ".sfi").delete();
    }

    public BlockMenuPreset getPreset() {
        return this.preset;
    }

    public boolean canOpen(Block b, Player p) {
        return this.preset.canOpen(b, p);
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.replaceExistingItem(slot, item, true);
    }

    public void replaceExistingItem(int slot, ItemStack item, boolean event) {
        ItemStack previous = this.getItemInSlot(slot);
        if (event && this.event != null) {
            item = this.event.onEvent(slot, previous, item);
        }
        super.replaceExistingItem(slot, item);
        ++this.changes;
    }

    public ChestMenu addMenuOpeningHandler(ChestMenu.MenuOpeningHandler handler) {
        if (handler instanceof SaveHandler) {
            return super.addMenuOpeningHandler((ChestMenu.MenuOpeningHandler)new SaveHandler(this, ((SaveHandler)handler).handler));
        }
        return super.addMenuOpeningHandler((ChestMenu.MenuOpeningHandler)new SaveHandler(this, handler));
    }

    public void close() {
        for (HumanEntity human : this.toInventory().getViewers()) {
            human.closeInventory();
        }
    }

    public class SaveHandler
    implements ChestMenu.MenuOpeningHandler {
        BlockMenu menu;
        ChestMenu.MenuOpeningHandler handler;

        public SaveHandler(BlockMenu menu, ChestMenu.MenuOpeningHandler handler) {
            this.handler = handler;
            this.menu = menu;
        }

        public void onOpen(Player p) {
            this.handler.onOpen(p);
            ++this.menu.changes;
        }
    }
}

