/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.Slimefun.GPS.GPSNetwork;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.VanillaItem;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.GuideHandler;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Slimefun {
    public static Map<Integer, List<GuideHandler>> guide_handlers = new HashMap<Integer, List<GuideHandler>>();
    public static List<GuideHandler> guide_handlers2 = new ArrayList<GuideHandler>();
    private static GPSNetwork gps = new GPSNetwork();
    public static boolean emeraldenchants = false;
    public static List<Category> current_categories = new ArrayList<Category>();

    public static void registerGuideHandler(GuideHandler handler) {
        List<GuideHandler> handlers = new ArrayList<GuideHandler>();
        if (guide_handlers.containsKey(handler.getTier())) {
            handlers = guide_handlers.get(handler.getTier());
        }
        handlers.add(handler);
        guide_handlers.put(handler.getTier(), handlers);
        guide_handlers2.add(handler);
    }

    public static GPSNetwork getGPSNetwork() {
        return gps;
    }

    public static Object getItemValue(String id, String key) {
        return Slimefun.getItemConfig().getValue(String.valueOf(id) + "." + key);
    }

    public static void setItemVariable(String id, String key, Object value) {
        Slimefun.getItemConfig().setDefaultValue(String.valueOf(id) + "." + key, value);
    }

    public static Config getItemConfig() {
        return SlimefunStartup.getItemCfg();
    }

    public static void registerResearch(Research research, ItemStack ... items) {
        ItemStack[] itemStackArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            research.addItems(SlimefunItem.getByItem(item));
            ++n2;
        }
        research.register();
    }

    public static boolean hasUnlocked(Player p, ItemStack item, boolean message) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        SlimefunItem.State state = SlimefunItem.getState(item);
        if (sfItem == null) {
            if (state != SlimefunItem.State.ENABLED) {
                if (message && state != SlimefunItem.State.VANILLA) {
                    Messages.local.sendTranslation((CommandSender)p, "messages.disabled-item", true, new Variable[0]);
                }
                return false;
            }
            return true;
        }
        if (Slimefun.isEnabled(p, item, message) && Slimefun.hasPermission(p, sfItem, message)) {
            if (sfItem.getResearch() == null) {
                return true;
            }
            if (sfItem.getResearch().hasUnlocked(p)) {
                return true;
            }
            if (message && !(sfItem instanceof VanillaItem)) {
                Messages.local.sendTranslation((CommandSender)p, "messages.not-researched", true, new Variable[0]);
            }
            return false;
        }
        return false;
    }

    public static boolean hasUnlocked(Player p, SlimefunItem sfItem, boolean message) {
        if (Slimefun.isEnabled(p, sfItem, message) && Slimefun.hasPermission(p, sfItem, message)) {
            if (sfItem.getResearch() == null) {
                return true;
            }
            if (sfItem.getResearch().hasUnlocked(p)) {
                return true;
            }
            if (message && !(sfItem instanceof VanillaItem)) {
                Messages.local.sendTranslation((CommandSender)p, "messages.not-researched", true, new Variable[0]);
            }
            return false;
        }
        return false;
    }

    public static boolean hasPermission(Player p, SlimefunItem item, boolean message) {
        if (item == null) {
            return true;
        }
        if (SlimefunStartup.getItemCfg().getString(String.valueOf(item.getName()) + ".required-permission").equalsIgnoreCase("")) {
            return true;
        }
        if (p.hasPermission(SlimefunStartup.getItemCfg().getString(String.valueOf(item.getName()) + ".required-permission"))) {
            return true;
        }
        if (message) {
            Messages.local.sendTranslation((CommandSender)p, "messages.no-permission", true, new Variable[0]);
        }
        return false;
    }

    public static boolean isEnabled(Player p, ItemStack item, boolean message) {
        String world = p.getWorld().getName();
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem == null) {
            return !SlimefunItem.isDisabled(item);
        }
        if (SlimefunStartup.getWhitelist().contains(String.valueOf(world) + ".enabled")) {
            if (SlimefunStartup.getWhitelist().getBoolean(String.valueOf(world) + ".enabled")) {
                if (!SlimefunStartup.getWhitelist().contains(String.valueOf(world) + ".enabled-items." + sfItem.getName())) {
                    SlimefunStartup.getWhitelist().setDefaultValue(String.valueOf(world) + ".enabled-items." + sfItem.getName(), (Object)true);
                }
                if (SlimefunStartup.getWhitelist().getBoolean(String.valueOf(world) + ".enabled-items." + sfItem.getName())) {
                    return true;
                }
                if (message) {
                    Messages.local.sendTranslation((CommandSender)p, "messages.disabled-in-world", true, new Variable[0]);
                }
                return false;
            }
            if (message) {
                Messages.local.sendTranslation((CommandSender)p, "messages.disabled-in-world", true, new Variable[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean isEnabled(Player p, SlimefunItem sfItem, boolean message) {
        String world = p.getWorld().getName();
        if (SlimefunStartup.getWhitelist().contains(String.valueOf(world) + ".enabled")) {
            if (SlimefunStartup.getWhitelist().getBoolean(String.valueOf(world) + ".enabled")) {
                if (!SlimefunStartup.getWhitelist().contains(String.valueOf(world) + ".enabled-items." + sfItem.getName())) {
                    SlimefunStartup.getWhitelist().setDefaultValue(String.valueOf(world) + ".enabled-items." + sfItem.getName(), (Object)true);
                }
                if (SlimefunStartup.getWhitelist().getBoolean(String.valueOf(world) + ".enabled-items." + sfItem.getName())) {
                    return true;
                }
                if (message) {
                    Messages.local.sendTranslation((CommandSender)p, "messages.disabled-in-world", true, new Variable[0]);
                }
                return false;
            }
            if (message) {
                Messages.local.sendTranslation((CommandSender)p, "messages.disabled-in-world", true, new Variable[0]);
            }
            return false;
        }
        return true;
    }

    public static List<String> listIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (SlimefunItem item : SlimefunItem.list()) {
            ids.add(item.getName());
        }
        return ids;
    }

    public static List<ItemStack> listCategories() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Category c : Category.list()) {
            items.add(c.getItem());
        }
        return items;
    }

    @Deprecated
    public static void addDescription(String id, String ... description) {
        Slimefun.getItemConfig().setDefaultValue(String.valueOf(id) + ".description", Arrays.asList(description));
    }

    public static void addHint(String id, String ... hint) {
        Slimefun.getItemConfig().setDefaultValue(String.valueOf(id) + ".hint", Arrays.asList(hint));
    }

    public static void addYoutubeVideo(String id, String link) {
        Slimefun.getItemConfig().setDefaultValue(String.valueOf(id) + ".youtube", (Object)link);
    }

    public static void addWikiPage(String id, String link) {
        Slimefun.getItemConfig().setDefaultValue(String.valueOf(id) + ".wiki", (Object)link);
    }

    public static void addOfficialWikiPage(String id, String page) {
        Slimefun.addWikiPage(id, "https://github.com/TheBusyBiscuit/Slimefun4/wiki/" + page);
    }

    public static boolean isEmeraldEnchantsInstalled() {
        return emeraldenchants;
    }

    public static List<GuideHandler> getGuideHandlers(int tier) {
        return guide_handlers.containsKey(tier) ? guide_handlers.get(tier) : new ArrayList<GuideHandler>();
    }
}

