/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItemSerializer;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.RecipeSorter;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public abstract class AutomatedCraftingChamber
extends SlimefunItem {
    private static final int[] border;
    private static final int[] border_in;
    private static final int[] border_out;
    public static Map<String, ItemStack> recipes;

    static {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 7;
        nArray[6] = 8;
        nArray[7] = 13;
        nArray[8] = 14;
        nArray[9] = 15;
        nArray[10] = 16;
        nArray[11] = 17;
        nArray[12] = 50;
        nArray[13] = 51;
        nArray[14] = 52;
        nArray[15] = 53;
        border = nArray;
        border_in = new int[]{9, 10, 11, 12, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
        border_out = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
        recipes = new HashMap<String, ItemStack>();
    }

    public AutomatedCraftingChamber(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, "&6Automated Crafting Chamber"){

            @Override
            public void init() {
                AutomatedCraftingChamber.this.constructMenu(this);
            }

            @Override
            public void newInstance(final BlockMenu menu, final Block b) {
                if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getBlockInfo(b, "enabled") == null || BlockStorage.getBlockInfo(b, "enabled").equals("false")) {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItem(new MaterialData(Material.SULPHUR), "&7Enabled: &4\u2718", new String[]{"", "&e> Click to enable this Machine"}));
                    menu.addMenuClickHandler(6, new ChestMenu.MenuClickHandler(){

                        public boolean onClick(Player p, int arg1, ItemStack arg2, ClickAction arg3) {
                            BlockStorage.addBlockInfo(b, "enabled", "true");
                            this.newInstance(menu, b);
                            return false;
                        }
                    });
                } else {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItem(new MaterialData(Material.REDSTONE), "&7Enabled: &2\u2714", new String[]{"", "&e> Click to disable this Machine"}));
                    menu.addMenuClickHandler(6, new ChestMenu.MenuClickHandler(){

                        public boolean onClick(Player p, int arg1, ItemStack arg2, ClickAction arg3) {
                            BlockStorage.addBlockInfo(b, "enabled", "false");
                            this.newInstance(menu, b);
                            return false;
                        }
                    });
                }
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(BlockMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow.equals((Object)ItemTransportFlow.WITHDRAW)) {
                    return AutomatedCraftingChamber.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                int[] nArray = AutomatedCraftingChamber.this.getInputSlots();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int slot = nArray[n2];
                    if (menu.getItemInSlot(slot) != null) {
                        slots.add(slot);
                    }
                    ++n2;
                }
                Collections.sort(slots, new RecipeSorter(menu));
                return ArrayUtils.toPrimitive((Integer[])slots.toArray(new Integer[slots.size()]));
            }
        };
        AutomatedCraftingChamber.registerBlockHandler(name, new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "enabled", "false");
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    int slot;
                    int[] nArray = AutomatedCraftingChamber.this.getInputSlots();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        slot = nArray[n2];
                        if (inv.getItemInSlot(slot) != null) {
                            b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        }
                        ++n2;
                    }
                    nArray = AutomatedCraftingChamber.this.getOutputSlots();
                    n = nArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        slot = nArray[n2];
                        if (inv.getItemInSlot(slot) != null) {
                            b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        }
                        ++n2;
                    }
                }
                return true;
            }
        });
    }

    protected void constructMenu(BlockMenuPreset preset) {
        int i;
        int[] nArray = border;
        int n = border.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            preset.addItem(i, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 7), " ", new String[0]), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
            ++n2;
        }
        nArray = border_in;
        n = border_in.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            preset.addItem(i, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 11), " ", new String[0]), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
            ++n2;
        }
        nArray = border_out;
        n = border_out.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            preset.addItem(i, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 1), " ", new String[0]), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
            ++n2;
        }
        nArray = this.getOutputSlots();
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
            ++n2;
        }
        preset.addItem(2, (ItemStack)new CustomItem(new MaterialData(Material.WORKBENCH), "&eRecipe", new String[]{"", "&bPut in the Recipe you want to craft", "&4Enhanced Crafting Table Recipes ONLY"}), new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
    }

    public abstract int getEnergyConsumption();

    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    }

    public int[] getOutputSlots() {
        return new int[]{33, 34};
    }

    private Inventory inject(Block b) {
        int size = BlockStorage.getInventory(b).toInventory().getSize();
        Inventory inv = Bukkit.createInventory(null, (int)size);
        int i = 0;
        while (i < size) {
            inv.setItem(i, (ItemStack)new CustomItem(Material.COMMAND, " &4ALL YOUR PLACEHOLDERS ARE BELONG TO US", 0));
            ++i;
        }
        int[] nArray = this.getOutputSlots();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int slot = nArray[n2];
            inv.setItem(slot, BlockStorage.getInventory(b).getItemInSlot(slot));
            ++n2;
        }
        return inv;
    }

    protected boolean fits(Block b, ItemStack[] items) {
        return this.inject(b).addItem(items).isEmpty();
    }

    protected void pushItems(Block b, ItemStack[] items) {
        Inventory inv = this.inject(b);
        inv.addItem(items);
        int[] nArray = this.getOutputSlots();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int slot = nArray[n2];
            BlockStorage.getInventory(b).replaceExistingItem(slot, inv.getItem(slot));
            ++n2;
        }
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                AutomatedCraftingChamber.this.tick(b);
            }

            @Override
            public void uniqueTick() {
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        });
        super.register(slimefun);
    }

    protected void tick(Block b) {
        ItemStack output;
        if (BlockStorage.getBlockInfo(b, "enabled").equals("false")) {
            return;
        }
        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
            return;
        }
        BlockMenu menu = BlockStorage.getInventory(b);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int j = 0;
        while (j < 9) {
            ItemStack item;
            if (i > 0) {
                builder.append(" </slot> ");
            }
            if ((item = menu.getItemInSlot(this.getInputSlots()[j])) != null && item.getAmount() == 1) {
                return;
            }
            builder.append(CustomItemSerializer.serialize((ItemStack)item, (CustomItemSerializer.ItemFlag[])new CustomItemSerializer.ItemFlag[]{CustomItemSerializer.ItemFlag.DATA, CustomItemSerializer.ItemFlag.ITEMMETA_DISPLAY_NAME, CustomItemSerializer.ItemFlag.ITEMMETA_LORE, CustomItemSerializer.ItemFlag.MATERIAL}));
            ++i;
            ++j;
        }
        String input = builder.toString();
        if (recipes.containsKey(input) && this.fits(b, new ItemStack[]{output = recipes.get(input)})) {
            this.pushItems(b, new ItemStack[]{output});
            ChargableBlock.addCharge(b, -this.getEnergyConsumption());
            int j2 = 0;
            while (j2 < 9) {
                if (menu.getItemInSlot(this.getInputSlots()[j2]) != null) {
                    menu.replaceExistingItem(this.getInputSlots()[j2], InvUtils.decreaseItem((ItemStack)menu.getItemInSlot(this.getInputSlots()[j2]), (int)1));
                }
                ++j2;
            }
        }
    }
}

