/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.FireworkShow;
import me.mrCookieSlime.Slimefun.Events.ResearchUnlockEvent;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Research {
    public static boolean enabled;
    public static List<Research> list;
    public static List<UUID> researching;
    public static boolean creative_research;
    private int id;
    private String name;
    private List<SlimefunItem> items;
    private int cost;

    static {
        list = new ArrayList<Research>();
        researching = new ArrayList<UUID>();
        creative_research = true;
    }

    public Research(int id, String name, int cost) {
        this.id = id;
        this.name = name;
        this.cost = cost;
        this.items = new ArrayList<SlimefunItem>();
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public int getLevel() {
        return this.cost;
    }

    @Deprecated
    public void setLevel(int level) {
        this.cost = level;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void addItems(SlimefunItem ... items) {
        SlimefunItem[] slimefunItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SlimefunItem item = slimefunItemArray[n2];
            if (item != null) {
                item.bindToResearch(this);
            }
            ++n2;
        }
    }

    public List<SlimefunItem> getEffectedItems() {
        return this.items;
    }

    public boolean hasUnlocked(Player p) {
        return this.hasUnlocked(p.getUniqueId());
    }

    public boolean hasUnlocked(UUID uuid) {
        if (!enabled) {
            return true;
        }
        if (!SlimefunStartup.getResearchCfg().getBoolean(String.valueOf(this.id) + ".enabled")) {
            return true;
        }
        return new Config(new File("data-storage/Slimefun/Players/" + uuid.toString() + ".yml")).contains("researches." + this.id);
    }

    public boolean canUnlock(Player p) {
        if (!enabled) {
            return true;
        }
        if (!SlimefunStartup.getResearchCfg().getBoolean(String.valueOf(this.id) + ".enabled")) {
            return true;
        }
        return p.getGameMode() == GameMode.CREATIVE && creative_research || p.getLevel() >= this.cost;
    }

    public void lock(Player p) {
        Config cfg = new Config(new File("data-storage/Slimefun/Players/" + p.getUniqueId() + ".yml"));
        cfg.setValue("researches." + this.id, null);
        cfg.save();
        Messages.local.sendTranslation((CommandSender)p, "commands.research.reset-target", true, new Variable[0]);
    }

    public void unlock(final Player p, boolean instant) {
        if (!this.hasUnlocked(p)) {
            ResearchUnlockEvent event = new ResearchUnlockEvent(p, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                final int research = this.id;
                if (instant) {
                    Config cfg = new Config(new File("data-storage/Slimefun/Players/" + p.getUniqueId() + ".yml"));
                    cfg.setValue("researches." + research, (Object)true);
                    cfg.save();
                    Messages.local.sendTranslation((CommandSender)p, "messages.unlocked", true, new Variable[]{new Variable("%research%", this.getName())});
                    if (SlimefunStartup.getCfg().getBoolean("options.research-give-fireworks")) {
                        FireworkShow.launchRandom((Player)p, (int)1);
                    }
                } else if (!researching.contains(p.getUniqueId())) {
                    researching.add(p.getUniqueId());
                    Messages.local.sendTranslation((CommandSender)p, "messages.research.start", true, new Variable[]{new Variable("%research%", this.getName())});
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                        @Override
                        public void run() {
                            p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                            Messages.local.sendTranslation((CommandSender)p, "messages.research.progress", true, new Variable[]{new Variable("%research%", Research.this.getName()), new Variable("%progress%", "23%")});
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                                @Override
                                public void run() {
                                    p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                                    Messages.local.sendTranslation((CommandSender)p, "messages.research.progress", true, new Variable[]{new Variable("%research%", Research.this.getName()), new Variable("%progress%", "44%")});
                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                                        @Override
                                        public void run() {
                                            p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                                            Messages.local.sendTranslation((CommandSender)p, "messages.research.progress", true, new Variable[]{new Variable("%research%", Research.this.getName()), new Variable("%progress%", "57%")});
                                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                                                @Override
                                                public void run() {
                                                    p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                                                    Messages.local.sendTranslation((CommandSender)p, "messages.research.progress", true, new Variable[]{new Variable("%research%", Research.this.getName()), new Variable("%progress%", "92%")});
                                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            Config cfg = new Config(new File("data-storage/Slimefun/Players/" + p.getUniqueId() + ".yml"));
                                                            cfg.setValue("researches." + research, (Object)true);
                                                            cfg.save();
                                                            Messages.local.sendTranslation((CommandSender)p, "messages.unlocked", true, new Variable[]{new Variable("%research%", Research.this.getName())});
                                                            if (SlimefunStartup.getCfg().getBoolean("options.research-unlock-fireworks")) {
                                                                FireworkShow.launchRandom((Player)p, (int)1);
                                                            }
                                                            researching.remove(p.getUniqueId());
                                                        }
                                                    }, 20L);
                                                }
                                            }, 20L);
                                        }
                                    }, 20L);
                                }
                            }, 20L);
                        }
                    }, 20L);
                }
            }
        }
    }

    public void register() {
        SlimefunStartup.getResearchCfg().setDefaultValue("enable-researching", (Object)true);
        if (SlimefunStartup.getResearchCfg().contains(String.valueOf(this.getID()) + ".enabled") && !SlimefunStartup.getResearchCfg().getBoolean(String.valueOf(this.getID()) + ".enabled")) {
            Iterator<SlimefunItem> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                SlimefunItem item = iterator.next();
                if (item != null) {
                    item.bindToResearch(null);
                }
                iterator.remove();
            }
            return;
        }
        SlimefunStartup.getResearchCfg().setDefaultValue(String.valueOf(this.getID()) + ".name", (Object)this.getName());
        SlimefunStartup.getResearchCfg().setDefaultValue(String.valueOf(this.getID()) + ".cost", (Object)this.getCost());
        SlimefunStartup.getResearchCfg().setDefaultValue(String.valueOf(this.getID()) + ".enabled", (Object)true);
        this.name = SlimefunStartup.getResearchCfg().getString(String.valueOf(this.getID()) + ".name");
        this.cost = SlimefunStartup.getResearchCfg().getInt(String.valueOf(this.getID()) + ".cost");
        list.add(this);
        if (SlimefunStartup.getCfg().getBoolean("options.print-out-loading")) {
            System.out.println("[Slimefun] Loaded Research \"" + this.getName() + "\"");
        }
    }

    public static List<Research> list() {
        return list;
    }

    public static boolean isResearching(Player p) {
        return researching.contains(p.getUniqueId());
    }

    public static void sendStats(CommandSender sender, Player p) {
        ArrayList<Research> researched = new ArrayList<Research>();
        int levels = 0;
        for (Research r : Research.list()) {
            if (!r.hasUnlocked(p)) continue;
            researched.add(r);
            levels += r.getLevel();
        }
        String progress = String.valueOf((float)Math.round((float)researched.size() * 100.0f / (float)Research.list().size() * 100.0f) / 100.0f);
        progress = Float.parseFloat(progress) < 16.0f ? "&4" + progress + " &r% " : (Float.parseFloat(progress) < 32.0f ? "&c" + progress + " &r% " : (Float.parseFloat(progress) < 48.0f ? "&6" + progress + " &r% " : (Float.parseFloat(progress) < 64.0f ? "&e" + progress + " &r% " : (Float.parseFloat(progress) < 80.0f ? "&2" + progress + " &r% " : "&a" + progress + " &r% "))));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Statistics for Player: &b" + p.getName())));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Title: &b" + Research.getTitle(p, researched))));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Research Progress: " + progress + "&e(" + researched.size() + " / " + Research.list().size() + ")")));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Total XP Levels spent: &b" + levels)));
    }

    public static String getTitle(Player p, List<Research> researched) {
        int index = Math.round(Float.valueOf(String.valueOf((float)Math.round((float)researched.size() * 100.0f / (float)Research.list().size() * 100.0f) / 100.0f)).floatValue() / 100.0f) * SlimefunStartup.getCfg().getStringList("research-ranks").size();
        if (index > 0) {
            --index;
        }
        return (String)SlimefunStartup.getCfg().getStringList("research-ranks").get(index);
    }

    public static Research getByID(int id) {
        for (Research research : list) {
            if (research.getID() != id) continue;
            return research;
        }
        return null;
    }

    public static List<Research> getResearches(UUID uuid) {
        ArrayList<Research> researched = new ArrayList<Research>();
        for (Research r : Research.list()) {
            if (!r.hasUnlocked(uuid)) continue;
            researched.add(r);
        }
        return researched;
    }

    public static List<Research> getResearches(String uuid) {
        return Research.getResearches(UUID.fromString(uuid));
    }
}

