/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Hashing;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ItemHash {
    public static MessageDigest digest;
    public static int LENGTH;
    public static Map<String, SlimefunItem> map;

    static {
        map = new HashMap<String, SlimefunItem>();
        try {
            digest = MessageDigest.getInstance("SHA");
            LENGTH = ItemHash.hash("The Busy Biscuit").length();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("FATAL Security ERROR - Slimefun was disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)SlimefunStartup.instance);
            e.printStackTrace();
        }
    }

    public static String hash(String input) {
        digest.update(input.getBytes());
        byte[] hash = digest.digest();
        return new BigInteger(1, hash).toString(16);
    }

    public static String toString(SlimefunItem item) {
        StringBuilder builder = new StringBuilder(LENGTH * 2);
        char[] cArray = item.hash.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            builder.append('\ufffd');
            builder.append(c);
            ++n2;
        }
        return builder.toString();
    }

    public static SlimefunItem fromString(String input) {
        if (input == null || input.length() != LENGTH * 2) {
            return null;
        }
        String hex = input.replaceAll("\ufffd", "");
        if (hex.length() != LENGTH || !map.containsKey(hex)) {
            return null;
        }
        return map.get(hex);
    }

    public static void register(SlimefunItem item) {
        String hash = ItemHash.hash(item.getName());
        if (map.containsKey(hash) && !item.getName().equals(ItemHash.map.get((Object)hash).hash)) {
            System.out.println("FATAL Security ERROR - Slimefun was disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)SlimefunStartup.instance);
            throw new IllegalStateException("Hash Collision: " + hash);
        }
        item.hash = hash;
        map.put(hash, item);
    }
}

