/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.WarpPadManager;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.StructureManager;
import org.kingdoms.manager.gui.OutpostGUIManager;
import org.kingdoms.utils.LoreOrganizer;

public class WarppadGUIManager
extends Manager
implements Listener {
    protected WarppadGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onWarpPadClickButton(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getWhoClicked());
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (e.getInventory().getName() == null) {
            return;
        }
        if (e.getInventory().getName().equals(ChatColor.AQUA + "Warp Pad")) {
            e.setCancelled(true);
            List lores = e.getCurrentItem().getItemMeta().getLore();
            String displayName = e.getCurrentItem().getItemMeta().getDisplayName();
            if (lores != null && displayName != null) {
                if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Title))) {
                    OutpostGUIManager.renameLand(kp, StructureManager.selected.get(kp));
                    return;
                }
                Location loc = WarppadGUIManager.stringToLocation(displayName);
                if (loc != null) {
                    kp.getPlayer().teleport(loc.add(0.3, 0.0, 0.3));
                    kp.getPlayer().closeInventory();
                }
            }
        }
    }

    public void openMenu(KingdomPlayer kp) {
        Land land = StructureManager.selected.get(kp);
        Kingdom kingdom = kp.getKingdom();
        Inventory outpostinv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.AQUA + "Warp Pad"));
        for (Land loopland : WarpPadManager.getOutposts(kp.getKingdom())) {
            if (loopland == null || loopland.getStructure() == null || loopland.getStructure().getLoc() == null) continue;
            ItemStack i3 = new ItemStack(Material.ENDER_PORTAL_FRAME);
            ItemMeta i3m = i3.getItemMeta();
            i3m.setDisplayName(ChatColor.AQUA + "[" + ChatColor.YELLOW + WarppadGUIManager.locationToString(loopland.getStructure().getLoc().toLocation().add(0.0, 1.0, 0.0)) + ChatColor.AQUA + "]");
            ArrayList<String> i3l = new ArrayList<String>();
            String type = null;
            if (loopland.getStructure().getType() == StructureType.OUTPOST) {
                type = ChatColor.AQUA + "[" + ChatColor.YELLOW + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost) + ChatColor.AQUA + "]";
            } else if (loopland.getStructure().getType() == StructureType.WARPPAD) {
                type = ChatColor.AQUA + "[" + ChatColor.YELLOW + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad) + ChatColor.AQUA + "]";
            } else if (loopland.getStructure().getType() == StructureType.NEXUS) {
                type = ChatColor.AQUA + "[" + ChatColor.YELLOW + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Nexus) + ChatColor.AQUA + "]";
            }
            if (loopland.getStructure().getType() != StructureType.NEXUS) {
                i3l.add(ChatColor.AQUA + "[" + ChatColor.YELLOW + loopland.getName() + ChatColor.AQUA + "]");
            }
            i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_WarpPad_Click_To_Tp));
            i3l.add(ChatColor.YELLOW + type);
            Kingdoms.getManagers();
            if (loopland.equals(GameManagement.getLandManager().getOrLoadLand(kp.getLoc()))) {
                i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_WarpPad_You_Are_Here));
            }
            i3m.setLore(LoreOrganizer.organize(i3l));
            i3.setItemMeta(i3m);
            outpostinv.addItem(new ItemStack[]{i3});
        }
        ItemStack i6 = new ItemStack(Material.PAPER);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        i6l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Desc).replaceAll("%name%", land.getName()));
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        outpostinv.addItem(new ItemStack[]{i6});
        kp.getPlayer().openInventory(outpostinv);
    }

    public static Location stringToLocation(String key) {
        String keyToSplit = ChatColor.stripColor((String)key).replaceAll("\\[", "").replaceAll("\\]", "");
        String[] split = keyToSplit.split(" , ");
        if (split.length == 4) {
            Location loc = new Location(Bukkit.getWorld((String)split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]), 0.0f, 0.0f);
            return loc;
        }
        return null;
    }

    public static String locationToString(Location loc) {
        if (loc == null) {
            return "none";
        }
        return String.valueOf(loc.getWorld().getName()) + " , " + (int)loc.getX() + " , " + (int)loc.getY() + " , " + (int)loc.getZ();
    }

    @Override
    public void onDisable() {
    }
}

