/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.KChestSign;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.manager.gui.ScrollerInventory;

public class PrivateChestGUIManager
extends Manager
implements Listener {
    private static final String TITLE = ChatColor.AQUA + "Manage the users of this chest";

    protected PrivateChestGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onClickButton(InventoryClickEvent e) {
        String playerName;
        OfflinePlayer offp;
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getTitle() == null) {
            return;
        }
        if (!e.getClickedInventory().getTitle().equals(TITLE)) {
            return;
        }
        e.setCancelled(true);
        if (!GUIManagement.allowedActions.contains(e.getAction())) {
            return;
        }
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem.getItemMeta() == null) {
            return;
        }
        if (clickedItem.getItemMeta().getDisplayName() == null) {
            return;
        }
        if (clickedItem.getItemMeta().getLore() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getWhoClicked());
        if (kp.getModifyingSign() == null) {
            return;
        }
        KChestSign sign = kp.getModifyingSign();
        if (clickedItem.getItemMeta().getLore().contains(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_privateSignGUI_PrivateSign)) && (offp = Bukkit.getOfflinePlayer((String)(playerName = clickedItem.getItemMeta().getDisplayName()))) != null) {
            if (clickedItem.getData().getData() == DyeColor.RED.getWoolData()) {
                if (!sign.getOwners().contains(offp.getUniqueId())) {
                    sign.getOwners().add(offp.getUniqueId());
                }
            } else {
                sign.getOwners().remove(offp.getUniqueId());
            }
        }
        this.openMenu(kp);
    }

    public void openMenu(KingdomPlayer kp) {
        if (kp.getModifyingSign() == null) {
            return;
        }
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        ArrayList<ItemStack> members = new ArrayList<ItemStack>();
        for (UUID uuid : kingdom.getMembersList()) {
            OfflineKingdomPlayer okp;
            if (uuid.equals(kp.getUuid()) || (okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(uuid)) == null) continue;
            members.add(this.getByStatus(kp.getModifyingSign(), okp));
        }
        new ScrollerInventory(members, TITLE, kp.getPlayer());
    }

    private ItemStack getByStatus(KChestSign sign, OfflineKingdomPlayer okp) {
        if (sign.getOwners().contains(okp.getUuid())) {
            return this.makeButton(Material.WOOL, DyeColor.GREEN.getWoolData(), okp.getName(), LanguageSupport.Languages.Guis_privateSignGUI_PrivateSign, LanguageSupport.Languages.Guis_privateSignGUI_canOpenChest);
        }
        return this.makeButton(Material.WOOL, DyeColor.RED.getWoolData(), okp.getName(), LanguageSupport.Languages.Guis_privateSignGUI_PrivateSign, LanguageSupport.Languages.Guis_privateSignGUI_cannotOpenChest);
    }

    private ItemStack makeButton(Material mat, byte id, String title, LanguageSupport.Languages btnType, LanguageSupport.Languages ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)id);
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        LanguageSupport.Languages[] languagesArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageSupport.Languages lang = languagesArray[n2];
            l.add(Kingdoms.getLang().parseFirstString(lang));
            ++n2;
        }
        l.add(Kingdoms.getLang().parseFirstString(btnType));
        IM.setLore(l);
        IS.setItemMeta(IM);
        return IS;
    }

    @Override
    public void onDisable() {
    }
}

