/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.PermissionsInfo;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.LoreOrganizer;

public class PermissionsGUIManager
extends Manager
implements Listener {
    protected PermissionsGUIManager(Plugin plugin) {
        super(plugin);
    }

    public ItemStack getPermissionMaterial(Rank rank) {
        ItemStack wool = new ItemStack(Material.WOOL, 1, (short)DyeColor.GRAY.getWoolData());
        if (rank == Rank.ALL) {
            wool = new ItemStack(Material.WOOL, 1, (short)DyeColor.GREEN.getWoolData());
            this.addLore(wool, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_RankAll));
            this.addLore(wool, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Click_To_Change));
            return wool;
        }
        if (rank == Rank.MODS) {
            wool = new ItemStack(Material.WOOL, 1, (short)DyeColor.BLUE.getWoolData());
            this.addLore(wool, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_RankMod));
            this.addLore(wool, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Click_To_Change));
            return wool;
        }
        if (rank == Rank.KING) {
            wool = new ItemStack(Material.WOOL, 1, (short)DyeColor.RED.getWoolData());
            this.addLore(wool, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_RankKing));
            this.addLore(wool, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Click_To_Change));
            return wool;
        }
        return wool;
    }

    @EventHandler
    public void onPermissionsClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getInventory().getName() == null) {
            return;
        }
        if (!event.getInventory().getName().equals(ChatColor.AQUA + "Permissions Manager")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!event.getCurrentItem().getItemMeta().getLore().contains(ChatColor.LIGHT_PURPLE + "Permission")) {
            return;
        }
        ItemStack wool = event.getCurrentItem();
        String displayName = wool.getItemMeta().getDisplayName();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getWhoClicked());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        Rank changeTo = Rank.ALL;
        if (wool.getData().getData() == DyeColor.GREEN.getWoolData()) {
            changeTo = Rank.MODS;
        } else if (wool.getData().getData() == DyeColor.BLUE.getWoolData()) {
            changeTo = Rank.KING;
        } else if (wool.getData().getData() == DyeColor.RED.getWoolData()) {
            changeTo = Rank.ALL;
        } else if (wool.getData().getData() == DyeColor.GRAY.getWoolData()) {
            changeTo = Rank.ALL;
        }
        PermissionsInfo perm = kingdom.getPermissionsInfo();
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Nexus))) {
            perm.setNexus(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Claim))) {
            perm.setClaim(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Unclaim))) {
            perm.setUnclaim(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Invade))) {
            perm.setInvade(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_AllyFunc))) {
            perm.setAlly(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Turret))) {
            perm.setTurret(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Sethome))) {
            perm.setSethome(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Nexuschest))) {
            perm.setChest(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Protectedchestbypass))) {
            perm.setOpenallchest(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Invite))) {
            perm.setInvite(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Broadcast))) {
            perm.setBroad(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Donate))) {
            perm.setRPConvert(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Structures))) {
            perm.setStructures(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Nexusbuild))) {
            perm.setBuildInNexus(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_UseKHome))) {
            perm.setUseKHome(changeTo);
            this.openMenu(kp);
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_OverrideRegulator))) {
            perm.setOverrideRegulator(changeTo);
            this.openMenu(kp);
        }
    }

    public void openMenu(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        Kingdoms.logDebug((String)"has kingdom");
        if (!kp.getRank().isHigherOrEqualTo(Rank.KING)) {
            kp.sendMessage(ChatColor.RED + "Only kingdom kings can edit permissions");
            return;
        }
        Kingdoms.logDebug((String)"only kings pass");
        Inventory champions = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + "Permissions Manager"));
        PermissionsInfo perm = kingdom.getPermissionsInfo();
        ItemStack i1 = this.getPermissionMaterial(perm.getNexus());
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Nexus));
        List i1l = i1m.getLore();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Nexus));
        i1l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        ItemStack i2 = this.getPermissionMaterial(perm.getClaim());
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Claim));
        List i2l = i2m.getLore();
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Claim));
        i2l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        ItemStack i3 = this.getPermissionMaterial(perm.getUnclaim());
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Unclaim));
        List i3l = i3m.getLore();
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Unclaim));
        i3l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        ItemStack i4 = this.getPermissionMaterial(perm.getInvade());
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Invade));
        List i4l = i4m.getLore();
        i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Invade));
        i4l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        ItemStack i5 = this.getPermissionMaterial(perm.getAlly());
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_AllyFunc));
        List i5l = i5m.getLore();
        i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_AllyFunc));
        i5l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        ItemStack i6 = this.getPermissionMaterial(perm.getTurret());
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Turret));
        List i6l = i6m.getLore();
        i6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Turrets));
        i6l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        ItemStack i7 = this.getPermissionMaterial(perm.getSethome());
        ItemMeta i7m = i7.getItemMeta();
        i7m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Sethome));
        List i7l = i7m.getLore();
        i7l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Sethome));
        i7l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i7m.setLore(LoreOrganizer.organize(i7l));
        i7.setItemMeta(i7m);
        ItemStack i8 = this.getPermissionMaterial(perm.getChest());
        ItemMeta i8m = i8.getItemMeta();
        i8m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Nexuschest));
        List i8l = i8m.getLore();
        i8l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Nexuschest));
        i8l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i8m.setLore(LoreOrganizer.organize(i8l));
        i8.setItemMeta(i8m);
        ItemStack i9 = this.getPermissionMaterial(perm.getOpenallchest());
        ItemMeta i9m = i9.getItemMeta();
        i9m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Protectedchestbypass));
        List i9l = i9m.getLore();
        i9l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Protectedchestbypass));
        i9l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i9m.setLore(LoreOrganizer.organize(i9l));
        i9.setItemMeta(i9m);
        ItemStack i10 = this.getPermissionMaterial(perm.getInvite());
        ItemMeta i10m = i10.getItemMeta();
        i10m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Invite));
        List i10l = i10m.getLore();
        i10l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Invite));
        i10l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i10m.setLore(LoreOrganizer.organize(i10l));
        i10.setItemMeta(i10m);
        ItemStack i11 = this.getPermissionMaterial(perm.getBroad());
        ItemMeta i11m = i11.getItemMeta();
        i11m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Broadcast));
        List i11l = i11m.getLore();
        i11l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Broadcast));
        i11l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i11m.setLore(LoreOrganizer.organize(i11l));
        i11.setItemMeta(i11m);
        ItemStack i12 = this.getPermissionMaterial(perm.getRPConvert());
        ItemMeta i12m = i12.getItemMeta();
        i12m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Donate));
        List i12l = i12m.getLore();
        i12l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Donate));
        i12l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i12m.setLore(LoreOrganizer.organize(i12l));
        i12.setItemMeta(i12m);
        ItemStack i13 = this.getPermissionMaterial(perm.getStructures());
        ItemMeta i13m = i13.getItemMeta();
        i13m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Structures));
        List i13l = i13m.getLore();
        i13l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Structures));
        i13l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i13m.setLore(LoreOrganizer.organize(i13l));
        i13.setItemMeta(i13m);
        ItemStack i14 = this.getPermissionMaterial(perm.getBuildInNexus());
        ItemMeta i14m = i14.getItemMeta();
        i14m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_Nexusbuild));
        List i14l = i14m.getLore();
        i14l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_Nexusbuild));
        i14l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i14m.setLore(LoreOrganizer.organize(i14l));
        i14.setItemMeta(i14m);
        ItemStack i15 = this.getPermissionMaterial(perm.getUseKHome());
        ItemMeta i15m = i15.getItemMeta();
        i15m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_UseKHome));
        List i15l = i15m.getLore();
        i15l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_UseKHome));
        i15l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i15m.setLore(LoreOrganizer.organize(i15l));
        i15.setItemMeta(i15m);
        ItemStack i16 = this.getPermissionMaterial(perm.getOverrideRegulator());
        ItemMeta i16m = i16.getItemMeta();
        i16m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Title_OverrideRegulator));
        List i16l = i16m.getLore();
        i16l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Permissions_Desc_OverrideRegulator));
        i16l.add(ChatColor.LIGHT_PURPLE + "Permission");
        i16m.setLore(LoreOrganizer.organize(i16l));
        i16.setItemMeta(i16m);
        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta backbtnmeta = backbtn.getItemMeta();
        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
        backbtn.setItemMeta(backbtnmeta);
        champions.setItem(26, backbtn);
        champions.addItem(new ItemStack[]{i1});
        champions.addItem(new ItemStack[]{i2});
        champions.addItem(new ItemStack[]{i3});
        champions.addItem(new ItemStack[]{i4});
        champions.addItem(new ItemStack[]{i5});
        champions.addItem(new ItemStack[]{i6});
        champions.addItem(new ItemStack[]{i7});
        champions.addItem(new ItemStack[]{i8});
        champions.addItem(new ItemStack[]{i9});
        champions.addItem(new ItemStack[]{i10});
        champions.addItem(new ItemStack[]{i11});
        champions.addItem(new ItemStack[]{i12});
        champions.addItem(new ItemStack[]{i13});
        champions.addItem(new ItemStack[]{i14});
        champions.addItem(new ItemStack[]{i15});
        champions.addItem(new ItemStack[]{i16});
        kp.getPlayer().openInventory(champions);
    }

    private void addLore(ItemStack i, String add) {
        ItemMeta meta = i.getItemMeta();
        List<String> lore = new ArrayList<String>();
        if (meta.hasLore()) {
            lore = meta.getLore();
        }
        lore.add(add);
        meta.setLore(lore);
        i.setItemMeta(meta);
    }

    @Override
    public void onDisable() {
    }
}

