/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.StructureManager;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.utils.LoreOrganizer;

public class OutpostGUIManager
extends Manager
implements Listener {
    public static ArrayList<UUID> isRenaming = new ArrayList();

    protected OutpostGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onOutpostClickButton(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getWhoClicked());
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (e.getInventory().getName() == null) {
            return;
        }
        if (!e.getInventory().getName().equals(ChatColor.AQUA + kp.getKingdom().getKingdomName() + "'s Outpost")) {
            return;
        }
        e.setCancelled(true);
        List lores = e.getCurrentItem().getItemMeta().getLore();
        String displayName = e.getCurrentItem().getItemMeta().getDisplayName();
        if (lores.contains(ChatColor.LIGHT_PURPLE + "Outpost Function")) {
            if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_OpenNexus_Title))) {
                GUIManagement.getNexusGUIManager().openNexusGui(kp);
                return;
            }
            if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Buy1XpPotion_Title))) {
                int cost = Kingdoms.config.outpost_xpbottle_cost;
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(ChatColor.RED + "Not enought RP.");
                    kp.sendMessage(ChatColor.GOLD + "Required: " + cost);
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kp.getPlayer().getInventory().addItem(new ItemStack[]{new ItemStack(Material.EXP_BOTTLE)});
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Buy64XpPotion_Title))) {
                int cost = Kingdoms.config.outpost_xpbottle_cost * 64;
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(ChatColor.RED + "Not enought RP.");
                    kp.sendMessage(ChatColor.GOLD + "Required: " + cost);
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kp.getPlayer().getInventory().addItem(new ItemStack[]{new ItemStack(Material.EXP_BOTTLE, 64)});
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Title))) {
                OutpostGUIManager.renameLand(kp, StructureManager.selected.get(kp));
                return;
            }
            this.openMenu(kp);
        }
    }

    public static void renameLand(KingdomPlayer kp, Land land) {
        kp.getPlayer().closeInventory();
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Message));
        if (!isRenaming.contains(kp.getUuid())) {
            isRenaming.add(kp.getUuid());
        }
    }

    @EventHandler
    public void onChatNewName(AsyncPlayerChatEvent event) {
        if (isRenaming.contains(event.getPlayer().getUniqueId())) {
            isRenaming.remove(event.getPlayer().getUniqueId());
            Kingdoms.getManagers();
            Land target = StructureManager.selected.get(GameManagement.getPlayerManager().getSession(event.getPlayer()));
            target.setName(event.getMessage());
            event.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Successful));
            event.setCancelled(true);
        }
    }

    public void openMenu(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        Land land = StructureManager.selected.get(kp);
        Inventory outpostinv = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + kingdom.getKingdomName() + "'s Outpost"));
        ItemStack i3 = new ItemStack(Material.EXP_BOTTLE);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Buy1XpPotion_Title));
        ArrayList<String> i3l = new ArrayList<String>();
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Buy1XpPotion_Desc).replaceAll("%cost%", "" + Kingdoms.config.outpost_xpbottle_cost));
        i3l.add(ChatColor.LIGHT_PURPLE + "Outpost Function");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        ItemStack i5 = new ItemStack(Material.EXP_BOTTLE);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Buy64XpPotion_Title));
        ArrayList<String> i5l = new ArrayList<String>();
        i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Buy64XpPotion_Desc).replaceAll("%cost%", "" + Kingdoms.config.outpost_xpbottle_cost * 64));
        i5l.add(ChatColor.LIGHT_PURPLE + "Outpost Function");
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        ItemStack i6 = new ItemStack(Material.PAPER);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        i6l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Rename_Land_Desc).replaceAll("%name%", land.getName()));
        i6l.add(ChatColor.LIGHT_PURPLE + "Outpost Function");
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        ItemStack i4 = new ItemStack(Material.BEACON);
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_OpenNexus_Title));
        if (kingdom.getNexus_loc() == null) {
            i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Outpost_Nexus_Unavailable));
        }
        ArrayList<String> i4l = new ArrayList<String>();
        i4l.add(ChatColor.LIGHT_PURPLE + "Outpost Function");
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Title));
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Desc));
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Count).replaceAll("%amount%", "" + kingdom.getResourcepoints()));
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        outpostinv.setItem(17, r);
        outpostinv.addItem(new ItemStack[]{i3});
        outpostinv.addItem(new ItemStack[]{i5});
        outpostinv.addItem(new ItemStack[]{i6});
        outpostinv.addItem(new ItemStack[]{i4});
        kp.getPlayer().openInventory(outpostinv);
    }

    @Override
    public void onDisable() {
    }
}

