/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.MisupgradeInfo;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.LoreOrganizer;

public class MisUpGUIManager
extends Manager
implements Listener {
    protected MisUpGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onMisUpgradeClick(InventoryClickEvent event) {
        if (event.getInventory().getName() == null) {
            return;
        }
        if (!event.getInventory().getName().equals(ChatColor.AQUA + "Extra Upgrades")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getWhoClicked());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            Kingdoms.logInfo((String)"kingdom was null!");
            return;
        }
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        List lores = event.getCurrentItem().getItemMeta().getLore();
        if (lores.contains(ChatColor.LIGHT_PURPLE + "Mis Upgrade")) {
            if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_AntiCreeper_Title))) {
                int cost = Kingdoms.config.misc_upgrades_anticreeper_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMisupgradeInfo().isAnticreeper()) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getMisupgradeInfo().setAnticreeper(true);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_AntiTrample_Title))) {
                int cost = Kingdoms.config.misc_upgrades_antitrample_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMisupgradeInfo().isAntitrample()) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getMisupgradeInfo().setAntitrample(true);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_NexusGuard_Title))) {
                int cost = Kingdoms.config.misc_upgrades_nexusguard_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMisupgradeInfo().isNexusguard()) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getMisupgradeInfo().setNexusguard(true);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Glory_Title))) {
                int cost = Kingdoms.config.misc_upgrades_glory_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMisupgradeInfo().isGlory()) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getMisupgradeInfo().setGlory(true);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_BombShards_Title))) {
                int cost = Kingdoms.config.misc_upgrades_bombshards_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMisupgradeInfo().isBombshards()) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getMisupgradeInfo().setBombshards(true);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_PsionicCore_Title))) {
                int cost = Kingdoms.config.misc_upgrades_psioniccore_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getMisupgradeInfo().isPsioniccore()) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getMisupgradeInfo().setPsioniccore(true);
            }
            this.openMenu(kp);
        }
    }

    public void openMenu(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        Kingdoms.logDebug((String)"has kingdom");
        String cost = "0";
        MisupgradeInfo info = kingdom.getMisupgradeInfo();
        Inventory champions = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + "Extra Upgrades"));
        ItemStack i1 = new ItemStack(Material.SULPHUR);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_AntiCreeper_Title));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_AntiCreeper_Desc));
        if (info.isAnticreeper()) {
            i1l.add(ChatColor.DARK_PURPLE + "Enabled!");
        } else {
            cost = "" + Kingdoms.config.misc_upgrades_anticreeper_cost;
            i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        }
        i1l.add(ChatColor.LIGHT_PURPLE + "Mis Upgrade");
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        if (!Kingdoms.config.misc_upgrades_anticreeper_enabled) {
            i1 = new ItemStack(Material.AIR);
            if (info.isAnticreeper()) {
                info.setAnticreeper(false);
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.misc_upgrades_anticreeper_cost);
            }
        }
        ItemStack i2 = new ItemStack(Material.SEEDS);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_AntiTrample_Title));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_AntiTrample_Desc));
        if (info.isAntitrample()) {
            i2l.add(ChatColor.DARK_PURPLE + "Enabled!");
        } else {
            cost = "" + Kingdoms.config.misc_upgrades_antitrample_cost;
            i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        }
        i2l.add(ChatColor.LIGHT_PURPLE + "Mis Upgrade");
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        if (!Kingdoms.config.misc_upgrades_antitrample_enabled) {
            i2 = new ItemStack(Material.AIR);
            if (info.isAntitrample()) {
                info.setAntitrample(false);
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.misc_upgrades_antitrample_cost);
            }
        }
        ItemStack i3 = new ItemStack(Material.IRON_AXE);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_NexusGuard_Title));
        ArrayList<String> i3l = new ArrayList<String>();
        i3l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_NexusGuard_Desc));
        if (info.isNexusguard()) {
            i3l.add(ChatColor.DARK_PURPLE + "Enabled!");
        } else {
            cost = "" + Kingdoms.config.misc_upgrades_nexusguard_cost;
            i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        }
        i3l.add(ChatColor.LIGHT_PURPLE + "Mis Upgrade");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        if (!Kingdoms.config.misc_upgrades_nexusguard_enabled) {
            i3 = new ItemStack(Material.AIR);
            if (info.isNexusguard()) {
                info.setNexusguard(false);
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.misc_upgrades_nexusguard_cost);
            }
        }
        ItemStack i4 = new ItemStack(Material.NETHER_STAR);
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Glory_Title));
        ArrayList<String> i4l = new ArrayList<String>();
        i4l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Glory_Desc));
        if (info.isGlory()) {
            i4l.add(ChatColor.DARK_PURPLE + "Enabled!");
        } else {
            cost = "" + Kingdoms.config.misc_upgrades_glory_cost;
            i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        }
        i4l.add(ChatColor.LIGHT_PURPLE + "Mis Upgrade");
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        if (!Kingdoms.config.misc_upgrades_glory_enabled) {
            i4 = new ItemStack(Material.AIR);
            if (info.isGlory()) {
                info.setGlory(false);
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.misc_upgrades_glory_cost);
            }
        }
        ItemStack i5 = new ItemStack(Material.TNT);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_BombShards_Title));
        ArrayList<String> i5l = new ArrayList<String>();
        i5l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_BombShards_Desc));
        if (info.isBombshards()) {
            i5l.add(ChatColor.DARK_PURPLE + "Enabled!");
        } else {
            cost = "" + Kingdoms.config.misc_upgrades_bombshards_cost;
            i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        }
        i5l.add(ChatColor.LIGHT_PURPLE + "Mis Upgrade");
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        if (!Kingdoms.config.misc_upgrades_bombshards_enabled) {
            i5 = new ItemStack(Material.AIR);
            if (info.isBombshards()) {
                info.setBombshards(false);
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.misc_upgrades_bombshards_cost);
            }
        }
        ItemStack i6 = new ItemStack(Material.EYE_OF_ENDER);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_PsionicCore_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        i6l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_PsionicCore_Desc));
        if (info.isPsioniccore()) {
            i6l.add(ChatColor.DARK_PURPLE + "Enabled!");
        } else {
            cost = "" + Kingdoms.config.misc_upgrades_psioniccore_cost;
            i6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        }
        i6l.add(ChatColor.LIGHT_PURPLE + "Mis Upgrade");
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        if (!Kingdoms.config.misc_upgrades_psioniccore_enabled) {
            i6 = new ItemStack(Material.AIR);
            if (info.isPsioniccore()) {
                info.setPsioniccore(false);
                kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.misc_upgrades_psioniccore_cost);
            }
        }
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Title));
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Desc));
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Count).replaceAll("%amount%", "" + kingdom.getResourcepoints()));
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta backbtnmeta = backbtn.getItemMeta();
        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
        backbtn.setItemMeta(backbtnmeta);
        champions.setItem(0, i1);
        champions.setItem(1, i2);
        champions.setItem(2, i3);
        champions.setItem(3, i4);
        champions.setItem(4, i5);
        champions.setItem(5, i6);
        champions.setItem(17, r);
        champions.setItem(26, backbtn);
        kp.getPlayer().openInventory(champions);
    }

    @Override
    public void onDisable() {
    }
}

