/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.AsciiCompass;

public class MapManager
extends Manager
implements Listener {
    protected MapManager(Plugin plugin) {
        super(plugin);
    }

    public void displayMap(final Player p) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                String com1 = "";
                String com2 = "";
                String com3 = "";
                String[] row = new String[]{"", "", "", "", "", "", "", ""};
                ArrayList<String> compass = AsciiCompass.getAsciiCompass(AsciiCompass.getCardinalDirection(p), ChatColor.YELLOW, "" + ChatColor.AQUA);
                com1 = compass.get(0);
                com2 = compass.get(1);
                com3 = compass.get(2);
                String cck = ChatColor.AQUA + "Unoccupied";
                HashMap detected = new HashMap();
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
                SimpleChunkLocation chunk = new SimpleChunkLocation(p.getLocation().getChunk());
                Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
                if (land.getOwner() != null) {
                    Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
                    cck = kingdom == null ? (land.getOwner().equals("WarZone") ? ChatColor.DARK_RED + land.getOwner() : ChatColor.GOLD + land.getOwner()) : (land.getOwner().equals(kp.getKingdomName()) ? ChatColor.GREEN + kingdom.getKingdomName() : (kingdom.isAllianceWith(kp.getKingdom()) ? ChatColor.LIGHT_PURPLE + kingdom.getKingdomName() : (kingdom.isEnemyWith(kp.getKingdom()) ? ChatColor.RED + kingdom.getKingdomName() : ChatColor.GRAY + kingdom.getKingdomName())));
                }
                int orix = chunk.getX();
                int oriz = chunk.getZ();
                int xc = 0;
                while (xc < 8) {
                    int x = xc - 4;
                    int zc = 0;
                    while (zc <= 24) {
                        int z = zc - 12;
                        chunk.setX(orix + x);
                        chunk.setZ(oriz + z);
                        String chunkcolor = MapManager.this.mapIdentifyChunk(chunk, kp);
                        if (x == 0 && z == 0) {
                            chunkcolor = ChatColor.WHITE + "\u25a3";
                        }
                        int n = xc;
                        row[n] = String.valueOf(row[n]) + chunkcolor;
                        if (xc == 0 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + ChatColor.LIGHT_PURPLE + "   ===========Key============";
                        }
                        if (xc == 1 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + ChatColor.LIGHT_PURPLE + "   \u25a3 = " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_You) + "                 \u25a1 = " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_NexusChunk);
                        }
                        if (xc == 2 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + ChatColor.LIGHT_PURPLE + "   \u25a5 = " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Powercell) + " \u25a4 = " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Outpost);
                        }
                        if (xc == 3 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + "   " + ChatColor.WHITE + com1;
                        }
                        if (xc == 4 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + "   " + ChatColor.WHITE + com2 + ChatColor.AQUA + "      [" + cck + ChatColor.AQUA + "]";
                        }
                        if (xc == 5 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + "   " + ChatColor.WHITE + com3;
                        }
                        if (xc == 6 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + "   " + ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Your_Kingdom) + "   " + ChatColor.WHITE + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_You);
                        }
                        if (xc == 7 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + "   " + ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Enemies) + "   " + ChatColor.AQUA + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unoccupied);
                        }
                        if (xc == 8 && zc == 24) {
                            row[xc] = String.valueOf(row[xc]) + "   " + ChatColor.LIGHT_PURPLE + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Allies) + "   " + ChatColor.GRAY + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unidentified);
                        }
                        ++zc;
                    }
                    p.sendMessage(row[xc]);
                    ++xc;
                }
                p.sendMessage(ChatColor.AQUA + "=======================================");
            }
        });
    }

    private String mapIdentifyChunk(SimpleChunkLocation chunk, KingdomPlayer kp) {
        String cck = ChatColor.AQUA + "\u25a9";
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land == null) {
            return cck;
        }
        if (land.getOwner() == null) {
            return cck;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            if (land.getOwner() == null) {
                return cck;
            }
            if (land.getOwner().equals("WarZone")) {
                return ChatColor.DARK_RED + "\u25a9";
            }
            if (land.getOwner().equals("SafeZone")) {
                return ChatColor.GOLD + "\u25a9";
            }
            return cck;
        }
        if (kp.getKingdom() == null) {
            cck = ChatColor.GRAY + "\u25a9";
        } else if (kp.getKingdom().equals(kingdom)) {
            cck = ChatColor.GREEN + "\u25a9";
            if (land.getStructure() != null) {
                if (land.getStructure().getType() == StructureType.NEXUS) {
                    cck = ChatColor.GREEN + "\u25a1";
                } else if (land.getStructure().getType() == StructureType.OUTPOST) {
                    cck = ChatColor.GREEN + "\u25a4";
                } else if (land.getStructure().getType() == StructureType.POWERCELL) {
                    cck = ChatColor.GREEN + "\u25a5";
                }
            }
        } else {
            cck = kp.getKingdom().isAllianceWith(kingdom) ? ChatColor.LIGHT_PURPLE + "\u25a9" : (kp.getKingdom().isEnemyWith(kingdom) ? ChatColor.RED + "\u25a9" : ChatColor.GRAY + "\u25a9");
        }
        return cck;
    }

    @Override
    public void onDisable() {
    }
}

