/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.gui.ScrollerInventory;

public class LogManagerGui
extends Manager {
    private final String TITLE = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Log_Title);

    protected LogManagerGui(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onInvMove(InventoryClickEvent event) {
        if (event.getInventory().getName() != null && event.getInventory().getName().equals(this.TITLE)) {
            event.setCancelled(true);
        }
    }

    public void openMenu(KingdomPlayer kp) {
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        ArrayList<ItemStack> invasions = new ArrayList<ItemStack>();
        ArrayList invasionsFinal = new ArrayList();
        Set<Map.Entry<String, String>> entries = kingdom.getInvasionLog().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String date = entry.getKey();
            String s = entry.getValue();
            invasions.add(this.getButtonForLog(date, s, kingdom));
        }
        new ScrollerInventory(invasions, this.TITLE, kp.getPlayer());
    }

    private ItemStack getButtonForLog(String date, String s, Kingdom kingdom) {
        String[] split = s.split(",");
        DyeColor color = DyeColor.LIME;
        String victory = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Log_Victory);
        if (split[2].equals("false")) {
            victory = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Log_Defeat);
            color = DyeColor.RED;
        }
        ChatColor defender = ChatColor.GREEN;
        ChatColor invader = ChatColor.RED;
        if (!split[0].equals(kingdom.getKingdomName())) {
            defender = ChatColor.RED;
            invader = ChatColor.GREEN;
        }
        String stringDate = date;
        ItemStack item = this.makeButton(Material.WOOL, color, String.valueOf(victory) + " " + ChatColor.AQUA + "[" + ChatColor.YELLOW + stringDate + ChatColor.AQUA + "]", defender + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Log_Defending) + split[0], invader + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Log_Invader) + split[1], String.valueOf(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Log_Land)) + split[3] + "," + split[4] + "," + split[5]);
        return item;
    }

    private ItemStack makeButton(Material mat, DyeColor color, String title, String ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)color.getWoolData());
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String lores = stringArray[n2];
            l.add(lores);
            ++n2;
        }
        IM.setLore(l);
        IS.setItemMeta(IM);
        return IS;
    }

    @Override
    public void onDisable() {
    }
}

