/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Extractor;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.StructureManager;
import org.kingdoms.utils.LoreOrganizer;

public class ExtractorGUIManager
extends Manager
implements Listener {
    protected ExtractorGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onExtractorClickButton(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getWhoClicked());
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (e.getInventory().getName() == null) {
            return;
        }
        if (e.getInventory().getName().equals(ChatColor.AQUA + "Extractor")) {
            e.setCancelled(true);
            List lores = e.getCurrentItem().getItemMeta().getLore();
            String displayName = e.getCurrentItem().getItemMeta().getDisplayName();
            if (displayName == null) {
                return;
            }
            e.setCancelled(true);
            if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Extractor_Collect).replaceAll("%amount%", "" + Kingdoms.config.minerewardamt))) {
                Extractor extractor = StructureManager.extractors.get(kp.getUuid());
                extractor.collect();
                this.openExtractorMenu(extractor, kp);
                return;
            }
            Extractor extractor = StructureManager.extractors.get(kp.getUuid());
            this.openExtractorMenu(extractor, kp);
        }
    }

    public void openExtractorMenu(Extractor extractor, KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        Inventory extactorinv = Bukkit.createInventory(null, (int)9, (String)(ChatColor.AQUA + "Extractor"));
        ItemStack i3 = new ItemStack(Material.WHEAT);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Extractor_Collect).replaceAll("%amount%", "" + Kingdoms.config.minerewardamt));
        i3.setItemMeta(i3m);
        ItemStack i5 = new ItemStack(Material.WATCH);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Extractor_TimeToNextCollection).replaceAll("%time%", "" + extractor.getTimeLeft()));
        i5.setItemMeta(i5m);
        ItemStack i6 = new ItemStack(Material.PAPER);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Extractor_Refresh_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        i6l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Extractor_Refresh_Desc));
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        if (extractor.isReady()) {
            extactorinv.addItem(new ItemStack[]{i3});
        } else {
            extactorinv.addItem(new ItemStack[]{i5});
        }
        extactorinv.addItem(new ItemStack[]{i6});
        kp.getPlayer().openInventory(extactorinv);
    }

    @Override
    public void onDisable() {
    }
}

