/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.conquest.ConquestLand;
import org.kingdoms.constants.conquest.ConquestMap;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.manager.gui.ScrollerInventory;
import org.kingdoms.utils.LoreOrganizer;

public class ConquestGUIManager
extends Manager
implements Listener {
    protected ConquestGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onConquestButtonClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (event.getInventory().getName() == null) {
            return;
        }
        if (!event.getInventory().getName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Conquests_Title))) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (!event.getCurrentItem().getItemMeta().getLore().contains(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_ButtonLore))) {
            return;
        }
        Kingdoms.getGuiManagement();
        GUIManagement.getConquestMapGUIManager().openMenu(kp, ConquestManager.maps.get(ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName().toLowerCase())));
    }

    public void openMenu(final KingdomPlayer kp) {
        final Kingdom kingdom = kp.getKingdom();
        final ArrayList usedMaps = new ArrayList();
        final ArrayList canJoinMaps = new ArrayList();
        final ArrayList finishedMaps = new ArrayList();
        final ArrayList conquests = new ArrayList();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Kingdoms.logDebug((String)"run");
                for (ConquestMap map : ConquestManager.maps.values()) {
                    boolean fullConquered = true;
                    for (ConquestLand land : map.lands) {
                        if (land.isCapital() && land.getOwner() == null && !canJoinMaps.contains(map)) {
                            canJoinMaps.add(map);
                        }
                        if (land.getOwner() == null) {
                            fullConquered = false;
                            continue;
                        }
                        if (land.getOwner().equals(kingdom.getKingdomName())) {
                            usedMaps.add(map);
                            continue;
                        }
                        fullConquered = false;
                    }
                    if (fullConquered) {
                        finishedMaps.add(map);
                    }
                    if (usedMaps.contains(map) || finishedMaps.contains(map) || canJoinMaps.contains(map)) continue;
                    boolean isEnemyFullOwned = true;
                    String oldowner = "";
                    for (ConquestLand land : map.lands) {
                        if (land.getOwner() == null) {
                            isEnemyFullOwned = false;
                            break;
                        }
                        if (oldowner.equals("")) {
                            oldowner = land.getOwner();
                        }
                        if (oldowner.equals(land.getOwner())) continue;
                        isEnemyFullOwned = false;
                        break;
                    }
                    if (!isEnemyFullOwned) continue;
                    canJoinMaps.add(map);
                }
                Bukkit.getScheduler().runTask((Plugin)ConquestGUIManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Kingdoms.logDebug((String)"sync");
                        for (ConquestMap map : ConquestManager.maps.values()) {
                            String incomeText;
                            ChatColor color;
                            int income;
                            if (finishedMaps.contains(map)) {
                                income = 0;
                                color = ChatColor.RED;
                                for (ConquestLand land : map.lands) {
                                    if (land.isCapital()) {
                                        income += Kingdoms.config.conquestCapitalReward - land.getUpKeepAmount();
                                        continue;
                                    }
                                    income += Kingdoms.config.conquestLandReward - land.getUpKeepAmount();
                                }
                                if (income > 0) {
                                    color = ChatColor.GREEN;
                                }
                                incomeText = color + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_Map_Income_Yield).replaceAll("%amount%", "" + income);
                                conquests.add(ConquestGUIManager.this.makeButton(Material.WOOL, DyeColor.GREEN, ChatColor.GREEN + ConquestGUIManager.this.capitalize(map.name), LanguageSupport.Languages.Guis_Conquests_ButtonLore, new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_Kingdom_Conquered_Map), incomeText}));
                                continue;
                            }
                            if (usedMaps.contains(map)) {
                                income = 0;
                                color = ChatColor.RED;
                                for (ConquestLand land : map.lands) {
                                    if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) continue;
                                    if (land.isCapital()) {
                                        income += Kingdoms.config.conquestCapitalReward - land.getUpKeepAmount();
                                        continue;
                                    }
                                    income += Kingdoms.config.conquestLandReward - land.getUpKeepAmount();
                                }
                                if (income > 0) {
                                    color = ChatColor.GREEN;
                                }
                                incomeText = color + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_Map_Income_Yield).replaceAll("%amount%", "" + income);
                                conquests.add(ConquestGUIManager.this.makeButton(Material.WOOL, DyeColor.RED, ChatColor.RED + ConquestGUIManager.this.capitalize(map.name), LanguageSupport.Languages.Guis_Conquests_ButtonLore, new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_Kingdom_Is_In_Map), incomeText}));
                                continue;
                            }
                            if (canJoinMaps.contains(map)) {
                                conquests.add(ConquestGUIManager.this.makeButton(Material.WOOL, DyeColor.YELLOW, ChatColor.GREEN + ConquestGUIManager.this.capitalize(map.name), LanguageSupport.Languages.Guis_Conquests_ButtonLore, new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_Kingdom_Can_Join_Map)}));
                                continue;
                            }
                            conquests.add(ConquestGUIManager.this.makeButton(Material.WOOL, DyeColor.GRAY, ChatColor.DARK_GRAY + ConquestGUIManager.this.capitalize(map.name), LanguageSupport.Languages.Guis_Conquests_ButtonLore, new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Conquests_Kingdom_Is_Not_In_Full_Map)}));
                        }
                        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
                        ItemMeta backbtnmeta = backbtn.getItemMeta();
                        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
                        backbtn.setItemMeta(backbtnmeta);
                        new ScrollerInventory(conquests, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Nexus_Conquests_Title), kp.getPlayer());
                    }
                });
            }
        });
    }

    private ItemStack makeButton(Material mat, DyeColor color, String title, LanguageSupport.Languages btnType, String ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)color.getWoolData());
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String lores = stringArray[n2];
            l.add(lores);
            ++n2;
        }
        l.add(Kingdoms.getLang().parseFirstString(btnType));
        IM.setLore(LoreOrganizer.organize(l));
        IS.setItemMeta(IM);
        return IS;
    }

    @Override
    public void onDisable() {
    }

    private String capitalize(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }
}

