/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.ChampionInfo;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.LoreOrganizer;

public class ChampionGUIManager
extends Manager
implements Listener {
    private static Inventory champions = null;

    protected ChampionGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onChampionUpgradeClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (!event.getInventory().getName().equals(ChatColor.AQUA + kingdom.getKingdomName() + "'s Champion")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        List lores = event.getCurrentItem().getItemMeta().getLore();
        if (lores.contains(ChatColor.LIGHT_PURPLE + "Champion Upgrade")) {
            int cost = 0;
            int max = 1;
            if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Weapon_Title))) {
                cost = Kingdoms.config.champion_upgrade_weapon_cost;
                max = Kingdoms.config.champion_upgrade_weapon_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getWeapon() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setWeapon(kingdom.getChampionInfo().getWeapon() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Resistance_Title))) {
                cost = Kingdoms.config.champion_upgrade_resist_cost;
                max = Kingdoms.config.champion_upgrade_resist_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getResist() + 20 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setResist(kingdom.getChampionInfo().getResist() + 20);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Speed_Title))) {
                cost = Kingdoms.config.champion_upgrade_speed_cost;
                max = Kingdoms.config.champion_upgrade_speed_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getSpeed() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setSpeed(kingdom.getChampionInfo().getSpeed() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Determination_Title))) {
                cost = Kingdoms.config.champion_upgrade_determination_cost * 2;
                max = Kingdoms.config.champion_upgrade_determination_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getDetermination() + 2 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setDetermination(kingdom.getChampionInfo().getDetermination() + 2);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DeterminationII_Title))) {
                cost = Kingdoms.config.champion_upgrade_determination_cost * 50;
                max = Kingdoms.config.champion_upgrade_determination_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getDetermination() + 50 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setDetermination(kingdom.getChampionInfo().getDetermination() + 50);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Health_Title))) {
                cost = Kingdoms.config.champion_upgrade_health_cost * 2;
                max = Kingdoms.config.champion_upgrade_health_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getHealth() + 2 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setHealth(kingdom.getChampionInfo().getHealth() + 2);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_HealthII_Title))) {
                cost = Kingdoms.config.champion_upgrade_health_cost * 50;
                max = Kingdoms.config.champion_upgrade_health_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getHealth() + 50 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setHealth(kingdom.getChampionInfo().getHealth() + 50);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Drag_Title))) {
                cost = Kingdoms.config.champion_upgrade_drag_cost;
                max = Kingdoms.config.champion_upgrade_drag_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getDrag() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setDrag(kingdom.getChampionInfo().getDrag() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Mock_Title))) {
                cost = Kingdoms.config.champion_upgrade_mock_cost;
                max = Kingdoms.config.champion_upgrade_mock_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getMock() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setMock(kingdom.getChampionInfo().getMock() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DeathDuel_Title))) {
                cost = Kingdoms.config.champion_upgrade_duel_cost;
                max = Kingdoms.config.champion_upgrade_duel_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getDuel() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setDuel(kingdom.getChampionInfo().getDuel() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Thor_Title))) {
                cost = Kingdoms.config.champion_upgrade_thor_cost;
                max = Kingdoms.config.champion_upgrade_thor_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getThor() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setThor(kingdom.getChampionInfo().getThor() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DamageCap_Title))) {
                cost = Kingdoms.config.champion_upgrade_damagecap_cost;
                max = Kingdoms.config.champion_upgrade_damagecap_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getDamagecap() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setDamagecap(kingdom.getChampionInfo().getDamagecap() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Plow_Title))) {
                cost = Kingdoms.config.champion_upgrade_plow_cost;
                max = Kingdoms.config.champion_upgrade_plow_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getPlow() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setPlow(kingdom.getChampionInfo().getPlow() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Aqua_Title))) {
                cost = Kingdoms.config.champion_upgrade_aqua_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getAqua() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setAqua(kingdom.getChampionInfo().getAqua() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Strength_Title))) {
                cost = Kingdoms.config.champion_upgrade_strength_cost;
                max = Kingdoms.config.champion_upgrade_strength_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getStrength() + 10 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setStrength(kingdom.getChampionInfo().getStrength() + 10);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Armor_Title))) {
                cost = Kingdoms.config.champion_upgrade_armor_cost;
                max = Kingdoms.config.champion_upgrade_armor_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getArmor() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setArmor(kingdom.getChampionInfo().getArmor() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Reinforcements_Title))) {
                cost = Kingdoms.config.champion_upgrade_reinforcements_cost;
                max = Kingdoms.config.champion_upgrade_reinforcements_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getReinforcements() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setReinforcements(kingdom.getChampionInfo().getReinforcements() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Mimic_Title))) {
                cost = Kingdoms.config.champion_upgrade_mimic_cost;
                max = Kingdoms.config.champion_upgrade_mimic_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getMimic() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setMimic(kingdom.getChampionInfo().getMimic() + 1);
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Focus_Title))) {
                cost = Kingdoms.config.champion_upgrade_focus_cost;
                max = Kingdoms.config.champion_upgrade_focus_max;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kingdom.getChampionInfo().getFocus() + 1 > max) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Level_Reached));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getChampionInfo().setFocus(kingdom.getChampionInfo().getFocus() + 1);
            }
            this.openMenu(kp);
        }
    }

    public void openMenu(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        if (champions != null) {
            kp.getPlayer().openInventory(champions);
        }
        champions = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + kingdom.getKingdomName() + "'s Champion"));
        ChampionInfo info = kingdom.getChampionInfo();
        ItemStack i1 = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Weapon_Title));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Weapon_Desc));
        i1l.add(ChatColor.DARK_PURPLE + "Current Champion Weapon Level: " + info.getWeapon());
        String cost = "" + Kingdoms.config.champion_upgrade_weapon_cost;
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i1l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        if (!Kingdoms.config.champion_upgrade_weapon_enabled) {
            i1 = new ItemStack(Material.AIR);
        }
        ItemStack i2 = new ItemStack(Material.DIAMOND_CHESTPLATE);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Health_Title));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Health_Desc));
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_CurrHealth).replaceAll("%hp%", "" + info.getHealth()));
        cost = "" + Kingdoms.config.champion_upgrade_health_cost * 2;
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i2l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        ItemStack i13 = new ItemStack(Material.DIAMOND_CHESTPLATE);
        ItemMeta i13m = i13.getItemMeta();
        i13m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_HealthII_Title));
        ArrayList<String> i13l = new ArrayList<String>();
        i13l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_HealthII_Desc));
        i13l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_CurrHealth).replaceAll("%hp%", "" + info.getHealth()));
        cost = "" + Kingdoms.config.champion_upgrade_health_cost * 50;
        i13l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i13l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i13m.setLore(LoreOrganizer.organize(i13l));
        i13.setItemMeta(i13m);
        ItemStack i3 = new ItemStack(Material.BRICK);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Resistance_Title));
        ArrayList<String> i3l = new ArrayList<String>();
        i3l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Resistance_Desc));
        i3l.add(ChatColor.RED + "Current Resistance: " + info.getResist() + "%");
        cost = "" + Kingdoms.config.champion_upgrade_resist_cost;
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i3l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        if (!Kingdoms.config.champion_upgrade_resist_enabled) {
            i3 = new ItemStack(Material.AIR);
        }
        ItemStack i4 = new ItemStack(Material.QUARTZ);
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Speed_Title));
        ArrayList<String> i4l = new ArrayList<String>();
        i4l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Speed_Desc));
        i4l.add(ChatColor.RED + "Current Champion Speed Level: " + info.getSpeed());
        cost = "" + Kingdoms.config.champion_upgrade_speed_cost;
        i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i4l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        if (!Kingdoms.config.champion_upgrade_speed_enabled) {
            i4 = new ItemStack(Material.AIR);
        }
        ItemStack i5 = new ItemStack(Material.ENDER_PEARL);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Drag_Title));
        ArrayList<String> i5l = new ArrayList<String>();
        i5l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Drag_Desc));
        i5l.add(ChatColor.RED + "Enabled: " + (info.getDrag() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_drag_cost;
        i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i5l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        if (!Kingdoms.config.champion_upgrade_drag_enabled) {
            i5 = new ItemStack(Material.AIR);
        }
        ItemStack i6 = new ItemStack(Material.FEATHER);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Mock_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        i6l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Mock_Desc));
        i6l.add(ChatColor.RED + "Current Mock Range: " + info.getMock() + " blocks");
        cost = "" + Kingdoms.config.champion_upgrade_mock_cost;
        i6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i6l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        if (!Kingdoms.config.champion_upgrade_mock_enabled) {
            i6 = new ItemStack(Material.AIR);
        }
        ItemStack i7 = new ItemStack(Material.GOLD_SWORD);
        ItemMeta i7m = i7.getItemMeta();
        i7m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DeathDuel_Title));
        ArrayList<String> i7l = new ArrayList<String>();
        i7l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DeathDuel_Desc));
        i7l.add(ChatColor.RED + "Enabled: " + (info.getDuel() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_duel_cost;
        i7l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i7l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i7m.setLore(LoreOrganizer.organize(i7l));
        i7.setItemMeta(i7m);
        if (!Kingdoms.config.champion_upgrade_duel_enabled) {
            i7 = new ItemStack(Material.AIR);
        }
        ItemStack i8 = new ItemStack(Material.DIAMOND_AXE);
        ItemMeta i8m = i8.getItemMeta();
        i8m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Thor_Title));
        ArrayList<String> i8l = new ArrayList<String>();
        i8l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Thor_Desc));
        i8l.add(ChatColor.RED + "Damage: " + info.getThor());
        cost = "" + Kingdoms.config.champion_upgrade_thor_cost;
        i8l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i8l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i8m.setLore(LoreOrganizer.organize(i8l));
        i8.setItemMeta(i8m);
        if (!Kingdoms.config.champion_upgrade_thor_enabled) {
            i8 = new ItemStack(Material.AIR);
        }
        ItemStack i9 = new ItemStack(Material.IRON_CHESTPLATE);
        ItemMeta i9m = i9.getItemMeta();
        i9m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DamageCap_Title));
        ArrayList<String> i9l = new ArrayList<String>();
        i9l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DamageCap_Desc));
        i9l.add(ChatColor.RED + "Enabled: " + (info.getDamagecap() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_damagecap_cost;
        i9l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i9l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i9m.setLore(LoreOrganizer.organize(i9l));
        i9.setItemMeta(i9m);
        if (!Kingdoms.config.champion_upgrade_damagecap_enabled) {
            i9 = new ItemStack(Material.AIR);
        }
        ItemStack i10 = new ItemStack(Material.IRON_CHESTPLATE);
        ItemMeta i10m = i10.getItemMeta();
        i10m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Plow_Title));
        ArrayList<String> i10l = new ArrayList<String>();
        i10l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Plow_Desc));
        i10l.add(ChatColor.RED + "Enabled: " + (info.getPlow() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_plow_cost;
        i10l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i10l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i10m.setLore(LoreOrganizer.organize(i10l));
        i10.setItemMeta(i10m);
        if (!Kingdoms.config.champion_upgrade_plow_enabled) {
            i10 = new ItemStack(Material.AIR);
        }
        ItemStack i12 = new ItemStack(Material.FEATHER);
        ItemMeta i12m = i12.getItemMeta();
        i12m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Strength_Title));
        ArrayList<String> i12l = new ArrayList<String>();
        i12l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Strength_Desc));
        i12l.add(ChatColor.RED + "Chance: " + info.getStrength() + "%");
        cost = "" + Kingdoms.config.champion_upgrade_strength_cost;
        i12l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i12l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i12m.setLore(LoreOrganizer.organize(i12l));
        i12.setItemMeta(i12m);
        if (!Kingdoms.config.champion_upgrade_strength_enabled) {
            i12 = new ItemStack(Material.AIR);
        }
        ItemStack i14 = new ItemStack(Material.GOLD_CHESTPLATE);
        ItemMeta i14m = i14.getItemMeta();
        i14m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Armor_Title));
        ArrayList<String> i14l = new ArrayList<String>();
        i14l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Armor_Desc));
        i14l.add(ChatColor.RED + "Level: " + info.getArmor());
        cost = "" + Kingdoms.config.champion_upgrade_armor_cost;
        i14l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i14l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i14m.setLore(LoreOrganizer.organize(i14l));
        i14.setItemMeta(i14m);
        if (!Kingdoms.config.champion_upgrade_armor_enabled) {
            i14 = new ItemStack(Material.AIR);
        }
        ItemStack i15 = new ItemStack(Material.MOB_SPAWNER);
        ItemMeta i15m = i15.getItemMeta();
        i15m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Reinforcements_Title));
        ArrayList<String> i15l = new ArrayList<String>();
        i15l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Reinforcements_Desc));
        i15l.add(ChatColor.RED + "Level: " + info.getReinforcements());
        cost = "" + Kingdoms.config.champion_upgrade_reinforcements_cost;
        i15l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i15l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i15m.setLore(LoreOrganizer.organize(i15l));
        i15.setItemMeta(i15m);
        if (!Kingdoms.config.champion_upgrade_reinforcements_enabled) {
            i15 = new ItemStack(Material.AIR);
        }
        ItemStack i16 = new ItemStack(Material.MAGMA_CREAM);
        ItemMeta i16m = i16.getItemMeta();
        i16m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Mimic_Title));
        ArrayList<String> i16l = new ArrayList<String>();
        i16l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Mimic_Desc));
        i16l.add(ChatColor.RED + "Enabled: " + (info.getMimic() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_mimic_cost;
        i16l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i16l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i16m.setLore(LoreOrganizer.organize(i16l));
        i16.setItemMeta(i16m);
        if (!Kingdoms.config.champion_upgrade_mimic_enabled) {
            i16 = new ItemStack(Material.AIR);
        }
        ItemStack i17 = new ItemStack(Material.EYE_OF_ENDER);
        ItemMeta i17m = i17.getItemMeta();
        i17m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Focus_Title));
        ArrayList<String> i17l = new ArrayList<String>();
        i17l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Focus_Desc));
        i17l.add(ChatColor.RED + "Enabled: " + (info.getFocus() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_focus_cost;
        i17l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i17l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i17m.setLore(LoreOrganizer.organize(i17l));
        i17.setItemMeta(i17m);
        if (!Kingdoms.config.champion_upgrade_focus_enabled) {
            i17 = new ItemStack(Material.AIR);
        }
        ItemStack i18 = new ItemStack(Material.WATER_BUCKET);
        ItemMeta i18m = i18.getItemMeta();
        i18m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Aqua_Title));
        ArrayList<String> i18l = new ArrayList<String>();
        i18l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Aqua_Desc));
        i18l.add(ChatColor.RED + "Enabled: " + (info.getAqua() > 0));
        cost = "" + Kingdoms.config.champion_upgrade_aqua_cost;
        i18l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i18l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i18m.setLore(LoreOrganizer.organize(i18l));
        i18.setItemMeta(i18m);
        ItemStack i20 = new ItemStack(Material.GOLD_CHESTPLATE);
        ItemMeta i20m = i20.getItemMeta();
        i20m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Determination_Title));
        ArrayList<String> i20l = new ArrayList<String>();
        i20l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_Determination_Desc));
        i20l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_CurrDetermination).replaceAll("%determination%", "" + info.getDetermination()));
        cost = "" + Kingdoms.config.champion_upgrade_determination_cost * 2;
        i20l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i20l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i20m.setLore(LoreOrganizer.organize(i20l));
        i20.setItemMeta(i20m);
        if (!Kingdoms.config.champion_upgrade_determination_enabled) {
            i20 = new ItemStack(Material.AIR);
        }
        ItemStack i21 = new ItemStack(Material.GOLD_CHESTPLATE);
        ItemMeta i21m = i21.getItemMeta();
        i21m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DeterminationII_Title));
        ArrayList<String> i21l = new ArrayList<String>();
        i21l.add(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_DeterminationII_Desc));
        i21l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ChampionUpgrades_CurrDetermination).replaceAll("%determination%", "" + info.getDetermination()));
        cost = "" + Kingdoms.config.champion_upgrade_determination_cost * 50;
        i21l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i21l.add(ChatColor.LIGHT_PURPLE + "Champion Upgrade");
        i21m.setLore(LoreOrganizer.organize(i21l));
        i21.setItemMeta(i21m);
        if (!Kingdoms.config.champion_upgrade_determination_enabled) {
            i21 = new ItemStack(Material.AIR);
        }
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Title));
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Desc));
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Count).replaceAll("%amount%", "" + kingdom.getResourcepoints()));
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta backbtnmeta = backbtn.getItemMeta();
        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
        backbtn.setItemMeta(backbtnmeta);
        champions.setItem(0, i1);
        champions.setItem(1, i2);
        champions.setItem(2, i3);
        champions.setItem(3, i4);
        champions.setItem(4, i5);
        champions.setItem(5, i6);
        champions.setItem(6, i7);
        champions.setItem(7, i8);
        champions.setItem(8, i9);
        champions.setItem(9, i10);
        champions.setItem(10, i13);
        champions.setItem(11, i12);
        champions.setItem(12, i14);
        champions.setItem(13, i15);
        champions.setItem(14, i16);
        champions.setItem(15, i17);
        champions.setItem(16, i18);
        champions.setItem(18, i20);
        champions.setItem(19, i21);
        champions.setItem(17, r);
        champions.setItem(26, backbtn);
        kp.getPlayer().openInventory(champions);
    }

    @Override
    public void onDisable() {
    }
}

