/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.generallib.array.utils.Sort;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.events.KingdomDeleteEvent;
import org.kingdoms.events.KingdomResourcePointChangeEvent;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class TopListManager
extends Manager
implements Listener {
    private static final int TOPLIMIT = 10;
    private static Map<String, Integer> topList = new LinkedHashMap<String, Integer>();

    protected TopListManager(Plugin plugin) {
        super(plugin);
        new BukkitRunnable(){

            public void run() {
                LinkedHashMap<String, Integer> list = new LinkedHashMap<String, Integer>();
                list.putAll(GameManagement.getKingdomManager().getAllByResourcePointsFromDB());
                int i = 0;
                for (Map.Entry entry : Sort.reverse(list).entrySet()) {
                    if (i == 10) break;
                    topList.put((String)entry.getKey(), (Integer)entry.getValue());
                    ++i;
                }
            }
        }.runTaskLaterAsynchronously(plugin, 20L);
    }

    @EventHandler
    public void onRPChange(KingdomResourcePointChangeEvent e) {
        OfflineKingdom kingdom = e.getKingdom();
        topList.put(kingdom.getKingdomName(), kingdom.getResourcepoints());
        topList = Sort.reverse(topList, (int)10);
    }

    public Map<String, Integer> getTopList() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.putAll(topList);
        return map;
    }

    @EventHandler
    public void onKingdomsDisband(KingdomDeleteEvent e) {
        topList.remove(e.getKingdom().getKingdomName());
    }

    @Override
    public void onDisable() {
        topList.clear();
    }
}

