/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Extractor;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.Regulator;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Structure;
import org.kingdoms.constants.land.WarpPadManager;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.LandLoadEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.utils.LoreOrganizer;

public class StructureManager
extends Manager
implements Listener {
    public static HashMap<KingdomPlayer, Land> selected = new HashMap();
    public static HashMap<UUID, Extractor> extractors = new HashMap();
    private static Queue<Land> loadQueue = new LinkedList<Land>();

    protected StructureManager(Plugin plugin) {
        super(plugin);
        new Thread(new SyncLoadTask()).start();
    }

    public void breakStructure(Land land) {
        if (land.getStructure() == null) {
            return;
        }
        Block block = land.getStructure().getLoc().toLocation().getBlock();
        World world = block.getWorld();
        block.setType(Material.AIR);
        if (land.getStructure().getType() == StructureType.POWERCELL) {
            world.dropItemNaturally(block.getLocation(), this.getPowerCellDisk());
        } else if (land.getStructure().getType() == StructureType.OUTPOST) {
            world.dropItemNaturally(block.getLocation(), this.getOutpostDisk());
        } else if (land.getStructure().getType() == StructureType.WARPPAD) {
            world.dropItemNaturally(block.getLocation(), this.getWarpPadDisk());
        } else if (land.getStructure().getType() == StructureType.REGULATOR) {
            world.dropItemNaturally(block.getLocation(), this.getRegulatorDisk());
        } else if (land.getStructure().getType() == StructureType.EXTRACTOR) {
            world.dropItemNaturally(block.getLocation(), this.getExtractorDisk());
        } else if (land.getStructure().getType() == StructureType.NEXUS) {
            GameManagement.getNexusManager().breakNexus(land);
        }
        land.setStructure(null);
    }

    public ItemStack getPowerCellDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_3);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Powercell));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Powercell_Desc));
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getWarpPadDisk() {
        ItemStack i1 = new ItemStack(Material.RECORD_3);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad_Desc));
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        return i1;
    }

    public ItemStack getOutpostDisk() {
        ItemStack i2 = new ItemStack(Material.RECORD_3);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost_Desc));
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        return i2;
    }

    public ItemStack getExtractorDisk() {
        ItemStack i2 = new ItemStack(Material.RECORD_3);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Extractor));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Extractor_Desc));
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        return i2;
    }

    public ItemStack getRegulatorDisk() {
        ItemStack i2 = new ItemStack(Material.RECORD_3);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Regulator));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Regulator_Desc));
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        return i2;
    }

    public boolean isInvadeable(KingdomPlayer invader, SimpleChunkLocation chunk) {
        Land landInvading = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (landInvading.getStructure() != null && landInvading.getStructure().getType() == StructureType.POWERCELL) {
            return true;
        }
        int radius = 1;
        String world = chunk.getWorld();
        int originX = chunk.getX();
        int originZ = chunk.getZ();
        int x = -radius;
        while (x <= radius) {
            int z = -radius;
            while (z <= radius) {
                if (x != 0 || z != 0) {
                    SimpleChunkLocation target = new SimpleChunkLocation(world, originX + x, originZ + z);
                    Land landAround = GameManagement.getLandManager().getOrLoadLand(target);
                    if (landAround.getStructure() != null && landAround.getOwner() != null && landInvading.getOwner().equals(landAround.getOwner()) && landAround.getStructure().getType() == StructureType.POWERCELL) {
                        return false;
                    }
                }
                ++z;
            }
            ++x;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onStructureBreak(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getBlock().hasMetadata("outpost") || e.getBlock().hasMetadata("powercell") || e.getBlock().hasMetadata("extractor") || e.getBlock().hasMetadata("warppad") || e.getBlock().hasMetadata("regulator"))) {
            return;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(e.getBlock().getChunk()));
        Kingdoms.getManagers();
        KingdomPlayer player = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (land.getOwner() != null && player.getKingdomName() != null && player.getKingdomName().equalsIgnoreCase(land.getOwner())) {
            Kingdom kingdom = player.getKingdom();
            if (!player.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getStructures())) {
                e.setCancelled(true);
                player.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getStructures().toString()));
                return;
            }
        }
        e.getBlock().setType(Material.AIR);
        if (e.getBlock().hasMetadata("outpost")) {
            e.getBlock().removeMetadata("outpost", (Plugin)this.plugin);
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.getOutpostDisk());
            land.setStructure(null);
            WarpPadManager.removeLand(player.getKingdom(), land);
        } else if (e.getBlock().hasMetadata("powercell")) {
            e.getBlock().removeMetadata("powercell", (Plugin)this.plugin);
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.getPowerCellDisk());
            land.setStructure(null);
        } else if (e.getBlock().hasMetadata("extractor")) {
            e.getBlock().removeMetadata("extractor", (Plugin)this.plugin);
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.getExtractorDisk());
            land.setStructure(null);
        } else if (e.getBlock().hasMetadata("regulator")) {
            e.getBlock().removeMetadata("regulator", (Plugin)this.plugin);
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.getRegulatorDisk());
            land.setStructure(null);
        } else if (e.getBlock().hasMetadata("warppad")) {
            e.getBlock().removeMetadata("warppad", (Plugin)this.plugin);
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), this.getWarpPadDisk());
            land.setStructure(null);
            WarpPadManager.removeLand(player.getKingdom(), land);
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onRightClickOutpost(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (!e.getClickedBlock().hasMetadata("outpost")) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            kp.sendMessage(ChatColor.RED + "The outpost is at [" + chunk.toString() + "] but no kingdom owns the land.");
            kp.sendMessage(ChatColor.RED + "Please report this glitch.");
            return;
        }
        if (!land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Land));
            return;
        }
        selected.put(kp, land);
        GUIManagement.getOutpostGUIManager().openMenu(kp);
    }

    @EventHandler
    public void onRightClickRegulator(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (!e.getClickedBlock().hasMetadata("regulator")) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            kp.sendMessage(ChatColor.RED + "The regulator is at [" + chunk.toString() + "] but no kingdom owns the land.");
            kp.sendMessage(ChatColor.RED + "Please report this glitch.");
            return;
        }
        if (!land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Land));
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(kp.getKingdom().getPermissionsInfo().getOverrideRegulator())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kp.getKingdom().getPermissionsInfo().getOverrideRegulator().toString()));
            return;
        }
        GUIManagement.getRegulatorGUIManager().openRegulatorMenu(kp, land);
    }

    @EventHandler
    public void onRightClickWarpPad(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (!e.getClickedBlock().hasMetadata("warppad")) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            kp.sendMessage(ChatColor.RED + "The warp pad is at [" + chunk.toString() + "] but no kingdom owns the land.");
            kp.sendMessage(ChatColor.RED + "Please report this glitch.");
            return;
        }
        if (!land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Land));
            return;
        }
        if (land.getStructure().getType() == StructureType.WARPPAD) {
            selected.put(kp, land);
            GUIManagement.getWarppadGUIManager().openMenu(kp);
        }
    }

    @EventHandler
    public void onRightClickExtractor(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (!e.getClickedBlock().hasMetadata("extractor")) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(e.getClickedBlock().getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            kp.sendMessage(ChatColor.RED + "The extractor is at [" + chunk.toString() + "] but no kingdom owns the land.");
            kp.sendMessage(ChatColor.RED + "Please report this glitch.");
            return;
        }
        if (!land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Land));
            return;
        }
        if (land.getStructure().getType() == StructureType.EXTRACTOR) {
            GUIManagement.getExtractorGUIManager().openExtractorMenu((Extractor)land.getStructure(), kp);
        }
        extractors.put(kp.getUuid(), (Extractor)land.getStructure());
    }

    @EventHandler
    public void onSetStructure(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getPlayer().getItemInHand() == null) {
            return;
        }
        if (event.getPlayer().getItemInHand().getType() != Material.RECORD_3) {
            // empty if block
        }
        if (event.getPlayer().getItemInHand().getItemMeta() == null) {
            return;
        }
        if (event.getPlayer().getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        String displayName = event.getPlayer().getItemInHand().getItemMeta().getDisplayName();
        if (!(displayName.equals(this.getPowerCellDisk().getItemMeta().getDisplayName()) || displayName.equals(this.getOutpostDisk().getItemMeta().getDisplayName()) || displayName.equals(this.getExtractorDisk().getItemMeta().getDisplayName()) || displayName.equals(this.getWarpPadDisk().getItemMeta().getDisplayName()) || displayName.equals(this.getRegulatorDisk().getItemMeta().getDisplayName()))) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        SimpleLocation loc = new SimpleLocation(clickedBlock.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getStructures())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getStructures().toString()));
            return;
        }
        if (land.getStructure() != null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
            return;
        }
        if (land.getOwner() == null || !land.getOwner().equals(kp.getKingdom().getKingdomName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Land));
            return;
        }
        if (Kingdoms.config.unreplaceableblocks.contains(clickedBlock.getType().toString())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Nexus_Setting_Cannot_Replace));
            return;
        }
        if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Powercell))) {
            ItemStack IS = kp.getPlayer().getItemInHand();
            if (IS.getAmount() > 1) {
                IS.setAmount(IS.getAmount() - 1);
            } else {
                kp.getPlayer().setItemInHand(null);
            }
            Structure structure = new Structure(loc, StructureType.POWERCELL);
            land.setStructure(structure);
            clickedBlock.setType(Material.REDSTONE_LAMP_ON);
            clickedBlock.setMetadata("powercell", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kp.getKingdom().getKingdomName()));
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost))) {
            ItemStack IS = kp.getPlayer().getItemInHand();
            if (IS.getAmount() > 1) {
                IS.setAmount(IS.getAmount() - 1);
            } else {
                kp.getPlayer().setItemInHand(null);
            }
            Structure structure = new Structure(loc, StructureType.OUTPOST);
            WarpPadManager.addLand(kp.getKingdom(), land);
            land.setStructure(structure);
            clickedBlock.setType(Material.HAY_BLOCK);
            clickedBlock.setMetadata("outpost", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kp.getKingdom().getKingdomName()));
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Extractor))) {
            ItemStack IS = kp.getPlayer().getItemInHand();
            if (IS.getAmount() > 1) {
                IS.setAmount(IS.getAmount() - 1);
            } else {
                kp.getPlayer().setItemInHand(null);
            }
            Extractor structure = new Extractor(loc, StructureType.EXTRACTOR);
            land.setStructure(structure);
            clickedBlock.setType(Material.EMERALD_BLOCK);
            clickedBlock.setMetadata("extractor", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kp.getKingdom().getKingdomName()));
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad))) {
            ItemStack IS = kp.getPlayer().getItemInHand();
            if (IS.getAmount() > 1) {
                IS.setAmount(IS.getAmount() - 1);
            } else {
                kp.getPlayer().setItemInHand(null);
            }
            Extractor structure = new Extractor(loc, StructureType.WARPPAD);
            WarpPadManager.addLand(kp.getKingdom(), land);
            land.setStructure(structure);
            clickedBlock.setType(Material.SEA_LANTERN);
            clickedBlock.setMetadata("warppad", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kp.getKingdom().getKingdomName()));
        } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Regulator))) {
            ItemStack IS = kp.getPlayer().getItemInHand();
            if (IS.getAmount() > 1) {
                IS.setAmount(IS.getAmount() - 1);
            } else {
                kp.getPlayer().setItemInHand(null);
            }
            Regulator structure = new Regulator(loc, StructureType.REGULATOR);
            land.setStructure(structure);
            clickedBlock.setType(Material.REDSTONE_BLOCK);
            clickedBlock.setMetadata("regulator", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)kp.getKingdom().getKingdomName()));
        }
    }

    @EventHandler
    public void onPistonPushStructure(BlockPistonExtendEvent e) {
        Iterator iter = e.getBlocks().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (block == null || block.getType() == Material.AIR || !block.hasMetadata("outpost") && !block.hasMetadata("powercell") && !block.hasMetadata("extractor") && !block.hasMetadata("warppad") && !block.hasMetadata("regulator") && !block.hasMetadata("nexusblock")) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onPistonPullStructure(BlockPistonRetractEvent e) {
        Iterator iter = e.getBlocks().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (block == null || block.getType() == Material.AIR || !block.hasMetadata("outpost") && !block.hasMetadata("powercell") && !block.hasMetadata("extractor") && !block.hasMetadata("warppad") && !block.hasMetadata("regulator") && !block.hasMetadata("nexusblock")) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onEntityExplodeStructure(EntityExplodeEvent e) {
        for (Block block : e.blockList()) {
            if (block == null || block.getType() == Material.AIR || !block.hasMetadata("outpost") && !block.hasMetadata("powercell") && !block.hasMetadata("extractor") && !block.hasMetadata("warppad") && !block.hasMetadata("regulator") && !block.hasMetadata("nexusblock")) continue;
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onLandLoad(LandLoadEvent e) {
        Kingdoms.logDebug((String)"structure manager land load event");
        loadQueue.add(e.getLand());
    }

    @Override
    public void onDisable() {
    }

    private class SyncLoadTask
    implements Runnable {
        private SyncLoadTask() {
        }

        @Override
        public void run() {
            while (StructureManager.this.plugin.isEnabled()) {
                Land land;
                if (Kingdoms.isDisabling()) {
                    return;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (loadQueue.isEmpty() || (land = (Land)loadQueue.poll()) == null) continue;
                this.initStructure(land);
            }
        }

        private void initStructure(final Land land) {
            new BukkitRunnable(){

                public void run() {
                    Structure structure = land.getStructure();
                    if (structure == null) {
                        return;
                    }
                    if (structure.getLoc() == null) {
                        return;
                    }
                    if (structure.getLoc().toLocation() == null) {
                        return;
                    }
                    if (land.getOwner() == null) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.AIR);
                    } else if (structure.getType() == StructureType.OUTPOST) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.HAY_BLOCK);
                        block.setMetadata("outpost", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.POWERCELL) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.REDSTONE_LAMP_ON);
                        block.setMetadata("powercell", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.EXTRACTOR) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.EMERALD_BLOCK);
                        block.setMetadata("extractor", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.WARPPAD) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.SEA_LANTERN);
                        block.setMetadata("warppad", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.LAB) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setMetadata("lab", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.CRYSTAL) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.LAPIS_BLOCK);
                        block.setMetadata("crystal", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.REGULATOR) {
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Material.REDSTONE_BLOCK);
                        Kingdoms.logDebug((String)"Loaded Regulator");
                        block.setMetadata("regulator", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    } else if (structure.getType() == StructureType.NEXUS) {
                        Kingdoms.logDebug((String)structure.getLoc().toSimpleChunk().toString());
                        Block block = structure.getLoc().toLocation().getBlock();
                        block.setType(Kingdoms.config.nexusMaterial);
                        block.setMetadata("nexusblock", (MetadataValue)new FixedMetadataValue((Plugin)StructureManager.this.plugin, (Object)land.getOwner()));
                    }
                }
            }.runTask((Plugin)StructureManager.this.plugin);
        }
    }
}

