/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.KChestSign;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;

public class PrivateChestManager
extends Manager
implements Listener {
    public static final String SIGN = ChatColor.GOLD + "[" + ChatColor.RED + "Protected" + ChatColor.GOLD + "]";
    private final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};

    protected PrivateChestManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onChestSet(SignChangeEvent e) {
        if (!Kingdoms.config.privateChestsEnabled) {
            return;
        }
        if (e.getBlock().getType() != Material.WALL_SIGN) {
            return;
        }
        org.bukkit.material.Sign s = (org.bukkit.material.Sign)e.getBlock().getState().getData();
        if (e.getBlock().getRelative(s.getAttachedFace()).getType() != Material.CHEST && e.getBlock().getRelative(s.getAttachedFace()).getType() != Material.TRAPPED_CHEST) {
            return;
        }
        if (!e.getLine(0).equalsIgnoreCase(ChatColor.stripColor((String)SIGN))) {
            return;
        }
        Chest clickedChest = (Chest)e.getBlock().getRelative(s.getAttachedFace()).getState();
        Chest neighborChest = this.isDoubleChest(e.getBlock().getRelative(s.getAttachedFace()));
        SimpleLocation loc = new SimpleLocation(clickedChest.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!kingdom.equals(kp.getKingdom())) {
            return;
        }
        Sign oldSign = null;
        oldSign = this.isProtected(clickedChest);
        if (oldSign != null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.PChest_AlreadyProtected));
            e.setCancelled(true);
            return;
        }
        oldSign = this.isProtected(neighborChest);
        if (oldSign != null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.PChest_AlreadyProtected));
            e.setCancelled(true);
            return;
        }
        e.setLine(0, SIGN);
        e.setLine(1, e.getPlayer().getName());
        KChestSign kcSign = new KChestSign(new SimpleLocation(e.getBlock().getLocation()), kp.getUuid());
        land.addChestSign(kcSign);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChestAccess(PlayerInteractEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.CHEST && e.getClickedBlock().getType() != Material.TRAPPED_CHEST) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        if (!(clickedBlock.getState() instanceof Chest)) {
            return;
        }
        Chest clickedChest = (Chest)clickedBlock.getState();
        Chest neighborChest = this.isDoubleChest(clickedBlock);
        Sign oldSign = this.isProtected(clickedChest);
        if (oldSign == null) {
            oldSign = this.isProtected(neighborChest);
        }
        if (oldSign == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(oldSign.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        SimpleLocation backupLoc = new SimpleLocation(e.getClickedBlock().getRelative(((org.bukkit.material.Sign)oldSign.getData()).getAttachedFace()).getLocation());
        SimpleChunkLocation backupChunk = backupLoc.toSimpleChunk();
        KChestSign kcsign = land.getChestSign(loc);
        if (kcsign == null && (kcsign = (land = GameManagement.getLandManager().getOrLoadLand(backupChunk)).getChestSign(loc)) == null) {
            return;
        }
        if (kcsign.getOwner() == null) {
            return;
        }
        if (kcsign.getOwner().equals(kp.getUuid())) {
            return;
        }
        if (kcsign.getOwners().contains(kp.getUuid())) {
            return;
        }
        if (kp.isAdminMode()) {
            return;
        }
        if (kp.getPlayer().hasPermission("kingdoms.protectedchestbypass")) {
            return;
        }
        if (kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getOpenallchest())) {
            return;
        }
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Permissions));
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChestBreak(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getBlock().getType() != Material.CHEST && e.getBlock().getType() != Material.TRAPPED_CHEST) {
            return;
        }
        Chest brokenChest = (Chest)e.getBlock().getState();
        Chest neighborChest = this.isDoubleChest(e.getBlock());
        SimpleLocation loc = new SimpleLocation(brokenChest.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!kingdom.equals(kp.getKingdom()) && !kp.isAdminMode()) {
            Kingdoms.getLang().addString(kingdom.getKingdomName());
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.PChest_NotYourKingdomChest));
            e.setCancelled(true);
            return;
        }
        if (kp.isAdminMode()) {
            return;
        }
        boolean removeSign = true;
        Sign protectedSign = null;
        protectedSign = this.isProtected(brokenChest);
        if (protectedSign != null) {
            removeSign = true;
        } else {
            protectedSign = this.isProtected(neighborChest);
            if (protectedSign != null) {
                removeSign = false;
            }
        }
        if (protectedSign == null) {
            return;
        }
        SimpleLocation locSign = new SimpleLocation(protectedSign.getLocation());
        SimpleLocation backupLoc = new SimpleLocation(protectedSign.getBlock().getRelative(((org.bukkit.material.Sign)protectedSign.getData()).getAttachedFace()).getLocation());
        SimpleChunkLocation backupChunk = backupLoc.toSimpleChunk();
        KChestSign kcsign = land.getChestSign(locSign);
        if (kcsign == null && (kcsign = (land = GameManagement.getLandManager().getOrLoadLand(backupChunk)).getChestSign(locSign)) == null) {
            return;
        }
        Kingdoms.logDebug((String)"chest break");
        if (!kp.isAdminMode() && !kcsign.getOwner().equals(kp.getUuid())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Permissions));
            e.setCancelled(true);
        } else if (removeSign) {
            land.removeChestSign(locSign);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChestExplode(EntityExplodeEvent e) {
        if (!Kingdoms.config.privateChestsExplosionImmune) {
            return;
        }
        Iterator iter = e.blockList().iterator();
        while (iter.hasNext()) {
            Kingdom kingdom;
            Block block = (Block)iter.next();
            if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) continue;
            Chest brokenChest = (Chest)block.getState();
            Chest neighborChest = this.isDoubleChest(block);
            SimpleLocation loc = new SimpleLocation(brokenChest.getLocation());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land.getOwner() == null || (kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner())) == null) continue;
            Sign protectedSign = null;
            protectedSign = this.isProtected(brokenChest);
            if (protectedSign == null) {
                protectedSign = this.isProtected(neighborChest);
            }
            if (protectedSign == null) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onHopperPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType() == Material.HOPPER || event.getBlock().getType() == Material.RAILS) {
            Block block = event.getBlock().getRelative(0, 1, 0);
            if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
                return;
            }
            Chest brokenChest = (Chest)block.getState();
            Chest neighborChest = this.isDoubleChest(block);
            SimpleLocation loc = new SimpleLocation(brokenChest.getLocation());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land.getOwner() == null) {
                return;
            }
            Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
            if (kingdom == null) {
                return;
            }
            Sign protectedSign = null;
            protectedSign = this.isProtected(brokenChest);
            if (protectedSign == null) {
                protectedSign = this.isProtected(neighborChest);
            }
            if (protectedSign != null) {
                event.setCancelled(true);
                Kingdoms.getManagers();
                GameManagement.getPlayerManager().getSession(event.getPlayer()).sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_PrivateSigns_No_Hopper_Tracks));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignBreak(BlockBreakEvent e) {
        if (e.getBlock().getType() != Material.WALL_SIGN) {
            return;
        }
        Sign sign = (Sign)e.getBlock().getState();
        if (sign.getLine(0) == null || !sign.getLine(0).equals(SIGN)) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(sign.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        KChestSign kchestsign = land.getChestSign(loc);
        SimpleLocation backupLoc = new SimpleLocation(e.getBlock().getRelative(((org.bukkit.material.Sign)sign.getData()).getAttachedFace()).getLocation());
        SimpleChunkLocation backupChunk = backupLoc.toSimpleChunk();
        if (kchestsign == null && (kchestsign = (land = GameManagement.getLandManager().getOrLoadLand(backupChunk)).getChestSign(loc)) == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp == null) {
            return;
        }
        if (!kp.getKingdomName().equals(land.getOwner())) {
            return;
        }
        Kingdoms.getManagers();
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        Kingdoms.logDebug((String)"sign break");
        if (!kp.isAdminMode() && !kchestsign.getOwner().equals(e.getPlayer().getUniqueId()) && !kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getOpenallchest()) && kp.getKingdom().getMembersList().contains(kchestsign.getOwner())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Permissions));
            e.setCancelled(true);
        } else {
            land.removeChestSign(loc);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignExplode(EntityExplodeEvent e) {
        if (!Kingdoms.config.privateChestsExplosionImmune) {
            return;
        }
        Iterator iter = e.blockList().iterator();
        while (iter.hasNext()) {
            Sign sign;
            Block block = (Block)iter.next();
            if (block.getType() != Material.WALL_SIGN || (sign = (Sign)block.getState()).getLine(0) == null || !sign.getLine(0).equals(SIGN)) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onRightClickSign(PlayerInteractEvent e) {
        if (!Kingdoms.config.privateChestsEnabled) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Sign sign = null;
        sign = this.isProtectedSign(e.getClickedBlock());
        if (sign == null) {
            return;
        }
        SimpleLocation loc = new SimpleLocation(sign.getLocation());
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        SimpleLocation backupLoc = new SimpleLocation(e.getClickedBlock().getRelative(((org.bukkit.material.Sign)sign.getData()).getAttachedFace()).getLocation());
        SimpleChunkLocation backupChunk = backupLoc.toSimpleChunk();
        KChestSign kcsign = land.getChestSign(loc);
        if (kcsign == null && (kcsign = (land = GameManagement.getLandManager().getOrLoadLand(backupChunk)).getChestSign(loc)) == null) {
            return;
        }
        if (kcsign.getOwner() == null) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!kcsign.getOwner().equals(kp.getUuid())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Permissions));
            return;
        }
        kp.setModifyingSign(kcsign);
        GUIManagement.getPchestGUImanager().openMenu(kp);
    }

    private Chest isDoubleChest(Block b) {
        BlockState state = b.getState();
        if (!(state instanceof Chest)) {
            return null;
        }
        Chest chest = (Chest)state;
        InventoryHolder holder = chest.getInventory().getHolder();
        if (holder instanceof DoubleChest) {
            DoubleChest dchest = (DoubleChest)holder;
            Chest left = (Chest)dchest.getLeftSide();
            Chest right = (Chest)dchest.getRightSide();
            if (state.equals(left)) {
                return right;
            }
            return left;
        }
        return null;
    }

    private Sign isProtectedSign(Block signBlock) {
        if (!Kingdoms.config.privateChestsEnabled) {
            return null;
        }
        if (signBlock.getType() != Material.WALL_SIGN) {
            return null;
        }
        if (!(signBlock.getState() instanceof Sign)) {
            return null;
        }
        Sign sign = (Sign)signBlock.getState();
        if (sign.getLine(0) == null || sign.getLine(1) == null) {
            return null;
        }
        if (sign.getLine(0).length() == 0 || sign.getLine(1).length() == 0) {
            return null;
        }
        if (sign.getLine(0).equals(SIGN)) {
            return sign;
        }
        return null;
    }

    private Sign isProtected(Chest chest) {
        if (!Kingdoms.config.privateChestsEnabled) {
            return null;
        }
        if (chest == null) {
            return null;
        }
        BlockFace[] blockFaceArray = this.faces;
        int n = this.faces.length;
        int n2 = 0;
        while (n2 < n) {
            Sign sign;
            BlockFace face = blockFaceArray[n2];
            Block relative = chest.getBlock().getRelative(face);
            if ((!(relative.getState() instanceof Sign) || relative.getRelative(((org.bukkit.material.Sign)relative.getState().getData()).getAttachedFace()).getLocation().equals((Object)chest.getLocation())) && (sign = this.isProtectedSign(relative)) != null) {
                return sign;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void onDisable() {
    }
}

