/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.PlayerChangeChunkEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;

public class PlayerMovementManager
extends Manager
implements Listener {
    private static final int SEC = 20;

    PlayerMovementManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onJoin(final PlayerJoinEvent e) {
        new BukkitRunnable(){

            public void run() {
                if (e.getPlayer() == null || !e.getPlayer().isOnline() || !e.getPlayer().isValid()) {
                    return;
                }
                PlayerChangeChunkEvent pcce = new PlayerChangeChunkEvent(e.getPlayer(), null, e.getPlayer().getLocation().getChunk());
                PlayerMovementManager.this.plugin.getServer().getPluginManager().callEvent((Event)pcce);
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    @EventHandler
    public void onTp(PlayerTeleportEvent e) {
        if (e.getFrom().getChunk().equals(e.getTo().getChunk())) {
            return;
        }
        if (e.getPlayer() == null || !e.getPlayer().isOnline() || !e.getPlayer().isValid()) {
            return;
        }
        PlayerChangeChunkEvent pcce = new PlayerChangeChunkEvent(e.getPlayer(), null, e.getTo().getChunk());
        this.plugin.getServer().getPluginManager().callEvent((Event)pcce);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!Kingdoms.config.worlds.contains(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!event.getPlayer().isOnline()) {
            return;
        }
        Player p = event.getPlayer();
        if (event.getTo().getChunk() != event.getFrom().getChunk()) {
            PlayerChangeChunkEvent pcce = new PlayerChangeChunkEvent(p, event.getFrom().getChunk(), event.getTo().getChunk());
            Bukkit.getServer().getPluginManager().callEvent((Event)pcce);
        }
    }

    @EventHandler
    public void onChunkChange(final PlayerChangeChunkEvent e) {
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        SimpleChunkLocation locTo = new SimpleChunkLocation(e.getToChunk());
        final Land landTo = GameManagement.getLandManager().getOrLoadLand(locTo);
        if (ExternalManager.isInRegion(kp.getPlayer().getLocation())) {
            return;
        }
        if (e.getFromChunk() != null) {
            SimpleChunkLocation locFrom = new SimpleChunkLocation(e.getFromChunk());
            Land landFrom = GameManagement.getLandManager().getOrLoadLand(locFrom);
            String fromOwner = landFrom.getOwner();
            String toOwner = landTo.getOwner();
            if (fromOwner == null && toOwner == null) {
                return;
            }
            if (fromOwner != null && toOwner != null && fromOwner.equals(toOwner)) {
                return;
            }
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (landTo.getOwner() == null) {
                    ExternalManager.sendActionBar(e.getPlayer(), ChatColor.DARK_GREEN + ChatColor.BOLD + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unoccupied));
                    if (Kingdoms.config.showLandEnterMessage) {
                        kp.sendMessage(ChatColor.DARK_GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Map_Unoccupied));
                    }
                    return;
                }
                Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(landTo.getOwner());
                ChatColor color = kingdom == null ? (landTo.getOwner().equals("WarZone") ? ChatColor.DARK_RED : ChatColor.GOLD) : (kp.getKingdom() == null ? ChatColor.WHITE : (kp.getKingdom().equals(kingdom) ? ChatColor.GREEN : (kp.getKingdom().isAllianceWith(kingdom) ? ChatColor.YELLOW : (kp.getKingdom().isEnemyWith(kingdom) ? ChatColor.RED : ChatColor.WHITE))));
                String lore = "";
                if (kingdom != null) {
                    lore = kingdom.getKingdomLore() != null ? kingdom.getKingdomLore() : "";
                }
                ExternalManager.sendTitleBar(e.getPlayer(), color + landTo.getOwner(), lore);
                ExternalManager.sendActionBar(e.getPlayer(), ChatColor.BOLD + color + ChatColor.BOLD + landTo.getOwner());
                if (Kingdoms.config.showLandEnterMessage) {
                    kp.sendMessage(color + landTo.getOwner());
                }
            }
        }).start();
    }

    @Override
    public void onDisable() {
    }
}

