/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;

public class MasswarManager
extends Manager
implements Listener {
    private long massWarTimeStart = 0L;
    private int time = -1;
    private static final SimpleDateFormat format = new SimpleDateFormat("HH'h' mm'm' ss's'");

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public MasswarManager(final Plugin plugin) {
        super(plugin);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (plugin.isEnabled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (MasswarManager.this.time == -1 || MasswarManager.this.isMassWarOn()) continue;
                    MasswarManager.this.stopMassWar();
                }
            }
        }).start();
    }

    @Override
    public void onDisable() {
        this.stopMassWar();
    }

    public boolean isMassWarOn() {
        return this.getTimeLeft() > 0L;
    }

    public long getTimeLeft() {
        if (this.time == -1) {
            return -1L;
        }
        return this.massWarTimeStart + (long)this.time * 1000L - System.currentTimeMillis();
    }

    public String getTimeLeftInString() {
        if (this.time == -1) {
            return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.EventManager_Masswar_NotOn);
        }
        Date date = new Date(this.getTimeLeft() < 0L ? 0L : this.getTimeLeft());
        Kingdoms.logDebug((String)("millisec :" + this.getTimeLeft()));
        return String.valueOf(format.format(date)) + " left.";
    }

    public void startMassWar(int time) {
        this.time = time;
        Bukkit.broadcastMessage((String)(ChatColor.GRAY + "============================================"));
        Bukkit.broadcastMessage((String)"");
        Bukkit.broadcastMessage((String)(" " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Masswar_Broadcast).replaceAll("%time%", "" + time / 60)));
        Bukkit.broadcastMessage((String)"");
        Bukkit.broadcastMessage((String)(ChatColor.GRAY + "============================================"));
        this.massWarTimeStart = System.currentTimeMillis();
    }

    public void stopMassWar() {
        if (this.time >= 0) {
            Bukkit.broadcastMessage((String)(ChatColor.GRAY + "============================================"));
            Bukkit.broadcastMessage((String)"");
            Bukkit.broadcastMessage((String)(" " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Masswar_End_Broadcast).replaceAll("%time%", "" + this.time / 60)));
            Bukkit.broadcastMessage((String)"");
            Bukkit.broadcastMessage((String)(ChatColor.GRAY + "============================================"));
        }
        this.time = -1;
    }
}

