/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.Date;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.PlayerChangeChunkEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class LandVisualizeManager
extends Manager
implements Listener {
    protected LandVisualizeManager(Plugin plugin) {
        super(plugin);
    }

    public void visualizeLand(KingdomPlayer kp, SimpleChunkLocation chunk) {
        if (!Kingdoms.config.worlds.contains(chunk.getWorld())) {
            return;
        }
        String ownerName = GameManagement.getLandManager().getOrLoadLand(chunk).getOwner();
        Material mat = kp.getKingdom() == null || ownerName == null ? Material.QUARTZ_BLOCK : (kp.getKingdom().equals(GameManagement.getKingdomManager().getOrLoadKingdom(ownerName)) ? Material.EMERALD_BLOCK : (kp.getKingdom().isAllianceWith(GameManagement.getKingdomManager().getOrLoadKingdom(ownerName)) ? Material.GOLD_BLOCK : (kp.getKingdom().isEnemyWith(GameManagement.getKingdomManager().getOrLoadKingdom(ownerName)) ? Material.REDSTONE_BLOCK : (ownerName.equalsIgnoreCase("SafeZone") ? Material.GOLD_BLOCK : (ownerName.equalsIgnoreCase("WarZone") ? Material.REDSTONE_BLOCK : Material.QUARTZ_BLOCK)))));
        Chunk bukkitChunk = SimpleChunkLocation.toChunk(chunk);
        this.sendFalsyBlock(kp, bukkitChunk, 0, 0, Material.SEA_LANTERN);
        this.sendFalsyBlock(kp, bukkitChunk, 1, 0, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 0, 1, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 0, 15, Material.SEA_LANTERN);
        this.sendFalsyBlock(kp, bukkitChunk, 0, 14, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 1, 15, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 15, 15, Material.SEA_LANTERN);
        this.sendFalsyBlock(kp, bukkitChunk, 15, 14, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 14, 15, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 15, 0, Material.SEA_LANTERN);
        this.sendFalsyBlock(kp, bukkitChunk, 14, 0, mat);
        this.sendFalsyBlock(kp, bukkitChunk, 15, 1, mat);
    }

    private void sendFalsyBlock(KingdomPlayer kp, Chunk chunk, int blockX, int blockZ, Material mat) {
        World world = chunk.getWorld();
        Location loc = chunk.getBlock(blockX, 0, blockZ).getLocation();
        loc.setY((double)(world.getHighestBlockYAt(loc) - 1));
        kp.getPlayer().sendBlockChange(loc, mat, (byte)0);
        kp.getLastMarkedChunk().add(loc.clone());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onClickBlock(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!kp.isMarkDisplaying()) {
            return;
        }
        if (kp.getLastDisplayTime() + 1000L > new Date().getTime()) {
            return;
        }
        kp.setLastDisplayTime(new Date().getTime());
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getClickedBlock().getChunk() == null) {
            return;
        }
        final SimpleChunkLocation clickedChunk = new SimpleChunkLocation(e.getClickedBlock().getChunk());
        while (!kp.getLastMarkedChunk().isEmpty()) {
            kp.getLastMarkedChunk().poll().getBlock().getState().update();
        }
        new BukkitRunnable(){

            public void run() {
                Land land = GameManagement.getLandManager().getOrLoadLand(clickedChunk);
                if (land.getOwner() == null) {
                    return;
                }
                LandVisualizeManager.this.visualizeLand(kp, clickedChunk);
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent e) {
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (!kp.isMarkDisplaying()) {
            return;
        }
        if (kp.getLastDisplayTime() + 1000L > new Date().getTime()) {
            return;
        }
        kp.setLastDisplayTime(new Date().getTime());
        if (e.getBlock() == null) {
            return;
        }
        if (e.getBlock().getChunk() == null) {
            return;
        }
        final SimpleChunkLocation clickedChunk = new SimpleChunkLocation(e.getBlock().getChunk());
        while (!kp.getLastMarkedChunk().isEmpty()) {
            kp.getLastMarkedChunk().poll().getBlock().getState().update();
        }
        new BukkitRunnable(){

            public void run() {
                Land land = GameManagement.getLandManager().getOrLoadLand(clickedChunk);
                if (land.getOwner() == null) {
                    return;
                }
                LandVisualizeManager.this.visualizeLand(kp, clickedChunk);
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler
    public void onChunkChangeEvent(PlayerChangeChunkEvent e) {
        kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        chunk = new SimpleChunkLocation(e.getToChunk());
        if (kp != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            kp.getLastMarkedChunk().poll().getBlock().getState().update();
lbl7:
            // 2 sources

            ** while (!kp.getLastMarkedChunk().isEmpty())
        }
lbl8:
        // 1 sources

    }

    @Override
    public void onDisable() {
    }
}

