/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.PowerUp;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;

public class KingdomPowerUpManager
extends Manager
implements Listener {
    protected KingdomPowerUpManager(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void onDisable() {
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAttack(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getDamager())) {
            return;
        }
        Player p = (Player)event.getDamager();
        for (String s : Kingdoms.config.worlds) {
            Kingdoms.logDebug((String)s);
        }
        if (!Kingdoms.config.worlds.contains(p.getWorld().getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        if (kp == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        PowerUp pu = kingdom.getPowerUp();
        int level = pu.getDmgboost();
        event.setDamage(event.getDamage() * (1.0 + (double)level / 100.0));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAttackArrow(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getDamager();
        if (!Kingdoms.config.worlds.contains(arrow.getWorld().getName())) {
            return;
        }
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen((Entity)arrow.getShooter())) {
            return;
        }
        Player p = (Player)arrow.getShooter();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        if (kp == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        PowerUp pu = kingdom.getPowerUp();
        int level = pu.getDmgboost();
        event.setDamage(event.getDamage() * (1.0 + (double)level / 100.0));
        Kingdoms.logDebug((String)("" + event.getDamage()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDefend(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getEntity())) {
            return;
        }
        Player p = (Player)event.getEntity();
        if (!Kingdoms.config.worlds.contains(p.getWorld().getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        if (kp == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        PowerUp pu = kingdom.getPowerUp();
        double level = (double)pu.getDmgreduction() / 100.0;
        event.setDamage(event.getDamage() * (1.0 - level));
        Kingdoms.logDebug((String)("" + event.getDamage()));
    }

    @EventHandler
    public void onNeutralLandExplode(EntityExplodeEvent event) {
        if (!Kingdoms.config.protectNeutralLandFromExplosions) {
            return;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block b : event.blockList()) {
            SimpleLocation loc = new SimpleLocation(event.getLocation());
            SimpleChunkLocation chunk = loc.toSimpleChunk();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land == null) {
                Kingdoms.logInfo((String)"land was null!");
                return;
            }
            if (land.getOwner() == null) {
                return;
            }
            Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
            if (!kingdom.isNeutral()) continue;
            blocks.add(b);
        }
        for (Block b : blocks) {
            event.blockList().remove(b);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHealthRegain(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(event.getEntity())) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!Kingdoms.config.worlds.contains(player.getWorld().getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(player);
        if (kp == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        PowerUp pu = kingdom.getPowerUp();
        int level = pu.getRegenboost();
        event.setAmount(event.getAmount() * (1.0 + (double)level / 100.0));
        Kingdoms.logDebug((String)(String.valueOf(event.getAmount()) + "|" + (1.0 + (double)level / 100.0)));
    }
}

