/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.ChatChannel;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class KingdomChatManager
extends Manager
implements Listener {
    protected KingdomChatManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChatToPublic(AsyncPlayerChatEvent e) {
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        if (kp.getChannel() != ChatChannel.PUBLIC) {
            return;
        }
        if (Kingdoms.config.useKingdomPrefixes) {
            String prefix = "";
            String message = ChatColor.GRAY + e.getMessage();
            prefix = String.valueOf(prefix) + this.getFancyBracket(kp);
            e.setFormat(String.valueOf(prefix) + e.getFormat());
        }
    }

    public ArrayList<World> getEnabledWorlds() {
        ArrayList<World> world = new ArrayList<World>();
        for (World w : Bukkit.getWorlds()) {
            if (!Kingdoms.config.worlds.contains(w.getName())) continue;
            world.add(w);
        }
        return world;
    }

    public void sendMessageToKingdomPlayers(String message, Kingdom kingdom) {
        Bukkit.getConsoleSender().sendMessage(message);
        for (World w : Bukkit.getWorlds()) {
            if (!Kingdoms.config.worlds.contains(w.getName())) continue;
            for (Player p : w.getPlayers()) {
                KingdomPlayer kp;
                if (p == null || (kp = GameManagement.getPlayerManager().getSession(p)) == null || !kingdom.isMember(kp) && !kp.isAdminMode()) continue;
                p.sendMessage(message);
            }
        }
    }

    public void sendMessageToKingdomAllies(String message, Kingdom kingdom) {
        Bukkit.getConsoleSender().sendMessage(message);
        for (World w : Bukkit.getWorlds()) {
            if (!Kingdoms.config.worlds.contains(w.getName())) continue;
            for (Player p : w.getPlayers()) {
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
                if (kp.isAdminMode()) {
                    p.sendMessage(message);
                    continue;
                }
                if (kp.getKingdom() == null || !kingdom.isMember(kp) && (!kingdom.isAllianceWith(kp.getKingdom()) || !kp.getKingdom().isAllianceWith(kingdom))) continue;
                p.sendMessage(message);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChatToAlly(AsyncPlayerChatEvent e) {
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        if (kp.getChannel() != ChatChannel.ALLY) {
            return;
        }
        String tag = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Chat_Allychat_Prefix);
        e.setCancelled(true);
        this.sendMessageToKingdomAllies(String.valueOf(tag.replaceAll("%player%", kp.getName()).replaceAll("%rank%", kp.getRank().getFancyMark()).replaceAll("%kingdom%", kp.getKingdomName())) + e.getMessage(), kp.getKingdom());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChatToKingdom(AsyncPlayerChatEvent e) {
        if (!Kingdoms.config.worlds.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp == null) {
            return;
        }
        if (kp.getKingdom() == null) {
            return;
        }
        if (kp.getChannel() != ChatChannel.KINGDOM) {
            return;
        }
        String prefix = "";
        String tag = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Chat_Kingdomchat_Prefix);
        if (Kingdoms.config.useKingdomPrefixes) {
            String message = ChatColor.GRAY + e.getMessage();
            prefix = String.valueOf(prefix) + ChatColor.stripColor((String)this.getFancyBracket(kp));
        }
        e.setCancelled(true);
        this.sendMessageToKingdomPlayers(String.valueOf(tag.replaceAll("%player%", kp.getName()).replaceAll("%rank%", kp.getRank().getFancyMark()).replaceAll("%kingdom%", kp.getKingdomName())) + e.getMessage(), kp.getKingdom());
    }

    private String getFancyBracket(KingdomPlayer kp) {
        Rank rank = kp.getRank();
        if (rank == Rank.ALL) {
            return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Chat_Prefix_Members).replaceAll("%kingdom%", kp.getKingdomName());
        }
        if (rank == Rank.MODS) {
            return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Chat_Prefix_Mods).replaceAll("%kingdom%", kp.getKingdomName());
        }
        if (rank == Rank.KING) {
            return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Chat_Prefix_Kings).replaceAll("%kingdom%", kp.getKingdomName());
        }
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Chat_Prefix_Members).replaceAll("%kingdom%", kp.getKingdomName());
    }

    @Override
    public void onDisable() {
    }
}

