/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;

public class GuardsManager
extends Manager {
    public static final String GUARDNAME = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Soldier_Name);
    public static final Map<Monster, Player> guardTargets = new HashMap<Monster, Player>();

    protected GuardsManager(Plugin plugin) {
        super(plugin);
        new Thread(new guardTrackWorker()).start();
    }

    public Entity spawnNexusGuard(Location loc, Kingdom owner, KingdomPlayer target) {
        int speed;
        int weapon;
        Entity e = loc.getWorld().spawnEntity(loc, EntityType.ZOMBIE);
        Zombie zombie = (Zombie)e;
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 999999, 1));
        zombie.getEquipment().setHelmet(new ItemStack(Material.LEATHER_HELMET));
        zombie.setBaby(false);
        zombie.getEquipment().setItemInHandDropChance(0.0f);
        if (target != null) {
            zombie.setTarget((LivingEntity)target.getPlayer());
        }
        zombie.setCustomName(GUARDNAME);
        zombie.setCustomNameVisible(true);
        if (owner != null) {
            zombie.setMetadata("kingdom+" + owner.getKingdomName(), (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)""));
        }
        if ((weapon = owner.getChampionInfo().getWeapon()) == 0) {
            zombie.getEquipment().setItemInHand(null);
        } else if (weapon == 1) {
            zombie.getEquipment().setItemInHand(new ItemStack(Material.WOOD_SWORD));
        } else if (weapon == 2) {
            zombie.getEquipment().setItemInHand(new ItemStack(Material.STONE_SWORD));
        } else if (weapon == 3) {
            zombie.getEquipment().setItemInHand(new ItemStack(Material.IRON_SWORD));
        } else if (weapon == 4) {
            zombie.getEquipment().setItemInHand(new ItemStack(Material.DIAMOND_SWORD));
        } else if (weapon > 4) {
            ItemStack diasword = new ItemStack(Material.DIAMOND_SWORD);
            diasword.addUnsafeEnchantment(Enchantment.DAMAGE_ALL, weapon - 4);
            zombie.getEquipment().setItemInHand(diasword);
        }
        if (owner != null && (speed = owner.getChampionInfo().getSpeed()) > 0) {
            zombie.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 999999, speed - 1));
        }
        if (target != null) {
            guardTargets.put((Monster)zombie, target.getPlayer());
        }
        return e;
    }

    public Entity spawnSiegeBreaker(Location loc, Kingdom owner, KingdomPlayer target) {
        Entity e = loc.getWorld().spawnEntity(loc, EntityType.CREEPER);
        Creeper creeper = (Creeper)e;
        creeper.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 999999, 2));
        if (target != null) {
            creeper.setTarget((LivingEntity)target.getPlayer());
        }
        creeper.setCustomName(GUARDNAME);
        creeper.setCustomNameVisible(true);
        if (owner != null) {
            creeper.setMetadata("kingdom+" + owner.getKingdomName(), (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)""));
        }
        creeper.setPowered(true);
        if (target != null) {
            guardTargets.put((Monster)creeper, target.getPlayer());
        }
        return e;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            if (((LivingEntity)event.getEntity()).getCustomName() == null) {
                return;
            }
            if (((LivingEntity)event.getEntity()).getCustomName().equals(GUARDNAME) && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity().getCustomName() != null && event.getEntity().getCustomName().equals(GUARDNAME)) {
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
    }

    @Override
    public void onDisable() {
    }

    public class guardTrackWorker
    implements Runnable {
        @Override
        public void run() {
            while (GuardsManager.this.plugin.isEnabled()) {
                for (Map.Entry<Monster, Player> entry : guardTargets.entrySet()) {
                    Monster guard = entry.getKey();
                    Entity target = (Entity)entry.getValue();
                    if (guard.isDead() || !guard.isValid()) {
                        guardTargets.remove(guard, target);
                        guard.remove();
                        continue;
                    }
                    if (target.isDead() || !target.isValid()) {
                        guardTargets.remove(guard, target);
                        guard.remove();
                        continue;
                    }
                    guard.setTarget((LivingEntity)target);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

