/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.generallib.database.Database;
import org.kingdoms.constants.kingdom.AggressorInfo;
import org.kingdoms.constants.kingdom.ArmyInfo;
import org.kingdoms.constants.kingdom.ChampionInfo;
import org.kingdoms.constants.kingdom.KingdomChest;
import org.kingdoms.constants.kingdom.MisupgradeInfo;
import org.kingdoms.constants.kingdom.PermissionsInfo;
import org.kingdoms.constants.kingdom.PowerUp;
import org.kingdoms.constants.land.KChestSign;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Structure;
import org.kingdoms.constants.land.Turret;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.DynmapManager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.ActiveConquestBattleManager;
import org.kingdoms.manager.game.AggressorManager;
import org.kingdoms.manager.game.ArmyManager;
import org.kingdoms.manager.game.CancelManager;
import org.kingdoms.manager.game.ChampionManager;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.DataZipper;
import org.kingdoms.manager.game.FightManager;
import org.kingdoms.manager.game.GuardsManager;
import org.kingdoms.manager.game.KingdomChatManager;
import org.kingdoms.manager.game.KingdomChestManager;
import org.kingdoms.manager.game.KingdomManager;
import org.kingdoms.manager.game.KingdomPowerUpManager;
import org.kingdoms.manager.game.LandManager;
import org.kingdoms.manager.game.LandVisualizeManager;
import org.kingdoms.manager.game.MasswarManager;
import org.kingdoms.manager.game.MisupManager;
import org.kingdoms.manager.game.NexusManager;
import org.kingdoms.manager.game.PlayerManager;
import org.kingdoms.manager.game.PlayerMovementManager;
import org.kingdoms.manager.game.PrivateChestManager;
import org.kingdoms.manager.game.RegulatorManager;
import org.kingdoms.manager.game.StructureManager;
import org.kingdoms.manager.game.TopListManager;
import org.kingdoms.manager.game.TurretManager;

public class GameManagement
extends Manager {
    private static PlayerMovementManager movementManager;
    private static PlayerManager playerManager;
    private static KingdomManager kingdomManager;
    private static LandManager landManager;
    private static ChampionManager championManager;
    private static FightManager fightManager;
    private static NexusManager nexusManager;
    private static KingdomChestManager chestManager;
    private static KingdomPowerUpManager powerupManager;
    private static KingdomChatManager chatManager;
    private static TopListManager topManager;
    private static StructureManager structureManager;
    private static TurretManager turretManager;
    private static LandVisualizeManager visualManager;
    private static DynmapManager dynmapManager;
    private static CancelManager tpManager;
    private static MisupManager misManager;
    private static ArmyManager armyManager;
    private static AggressorManager aggrManager;
    private static PrivateChestManager pchestManager;
    private static MasswarManager masswarManager;
    private static DataZipper dataZipper;
    private static GuardsManager guardsManager;
    private static ConquestManager conquestManager;
    private static ActiveConquestBattleManager conquestBattleManager;
    private static RegulatorManager regulatorManager;
    private static ExternalManager externalManager;
    private static final List<Class<?>> serClasses;
    private static final String pkgName = "org.kingdoms.json.serialize";

    static {
        serClasses = new ArrayList<Class<?>>(){
            {
                this.add(AggressorInfo.class);
                this.add(ArmyInfo.class);
                this.add(ChampionInfo.class);
                this.add(KChestSign.class);
                this.add(KingdomChest.class);
                this.add(MisupgradeInfo.class);
                this.add(PermissionsInfo.class);
                this.add(PowerUp.class);
                this.add(SimpleChunkLocation.class);
                this.add(SimpleLocation.class);
                this.add(Structure.class);
                this.add(Turret.class);
            }
        };
    }

    public GameManagement(Plugin plugin) {
        super(plugin);
        PluginManager pm = plugin.getServer().getPluginManager();
        this.initSerializers();
        movementManager = new PlayerMovementManager(plugin);
        kingdomManager = new KingdomManager(plugin);
        playerManager = new PlayerManager(plugin);
        try {
            landManager = new LandManager(plugin);
        }
        catch (IOException e1) {
            Kingdoms.logInfo((String)"Fatal Error! could not create landList!");
            Kingdoms.logInfo((String)"Disabling plugin...");
            plugin.getServer().getPluginManager().disablePlugin(plugin);
            e1.printStackTrace();
        }
        structureManager = new StructureManager(plugin);
        championManager = new ChampionManager(plugin);
        fightManager = new FightManager(plugin);
        nexusManager = new NexusManager(plugin);
        chestManager = new KingdomChestManager(plugin);
        powerupManager = new KingdomPowerUpManager(plugin);
        chatManager = new KingdomChatManager(plugin);
        turretManager = new TurretManager(plugin);
        visualManager = new LandVisualizeManager(plugin);
        misManager = new MisupManager(plugin);
        armyManager = new ArmyManager(plugin);
        aggrManager = new AggressorManager(plugin);
        pchestManager = new PrivateChestManager(plugin);
        masswarManager = new MasswarManager(plugin);
        dataZipper = new DataZipper(plugin);
        topManager = new TopListManager(plugin);
        guardsManager = new GuardsManager(plugin);
        externalManager = new ExternalManager(plugin);
        if (Kingdoms.config.structure_regulator_enabled) {
            regulatorManager = new RegulatorManager(plugin);
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("WorldEdit") != null) {
                if (Kingdoms.config.enableKingdomsConquests) {
                    conquestManager = new ConquestManager(plugin);
                    conquestBattleManager = new ActiveConquestBattleManager(plugin);
                } else {
                    Kingdoms.logInfo((String)"Kingdoms will not enable KingdomsConquests.");
                }
            } else {
                Kingdoms.logInfo((String)"[WARNING] Worldedit must be present for Kingdoms to enable Conquests!");
            }
        }
        catch (NoClassDefFoundError e) {
            Kingdoms.logInfo((String)"[WARNING] Worldedit must be present for Kingdoms to enable Conquests!");
        }
        tpManager = new CancelManager(plugin);
    }

    private void initSerializers() {
        for (Class<?> clazz : serClasses) {
            this.initSerializer(clazz);
        }
    }

    private void initSerializer(Class<?> clazz) {
        try {
            Class<?> ser = Class.forName("org.kingdoms.json.serialize." + clazz.getSimpleName() + "Serializer");
            Constructor<?> con = ser.getConstructor(new Class[0]);
            Database.registerTypeAdapter(clazz, con.newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static CancelManager getTpManager() {
        return tpManager;
    }

    public static DynmapManager getDynmapManager() {
        return dynmapManager;
    }

    public static PlayerMovementManager getMovementManager() {
        return movementManager;
    }

    public static PlayerManager getPlayerManager() {
        return playerManager;
    }

    public static KingdomManager getKingdomManager() {
        return kingdomManager;
    }

    public static LandManager getLandManager() {
        return landManager;
    }

    public static ChampionManager getChampionManager() {
        return championManager;
    }

    public static FightManager getFightManager() {
        return fightManager;
    }

    public static NexusManager getNexusManager() {
        return nexusManager;
    }

    public static KingdomPowerUpManager getPowerupManager() {
        return powerupManager;
    }

    public static KingdomChestManager getChestManager() {
        return chestManager;
    }

    public static KingdomChatManager getChatManager() {
        return chatManager;
    }

    public static TopListManager getTopManager() {
        return topManager;
    }

    public static MasswarManager getMasswarManager() {
        return masswarManager;
    }

    public static LandVisualizeManager getVisualManager() {
        return visualManager;
    }

    public static TurretManager getTurretManager() {
        return turretManager;
    }

    public static StructureManager getStructureManager() {
        return structureManager;
    }

    public static ExternalManager getApiManager() {
        return externalManager;
    }

    public static MisupManager getMisManager() {
        return misManager;
    }

    public static ArmyManager getArmyManager() {
        return armyManager;
    }

    public static AggressorManager getAggrManager() {
        return aggrManager;
    }

    public static PrivateChestManager getPchestManager() {
        return pchestManager;
    }

    public static DataZipper getDataZipper() {
        return dataZipper;
    }

    public static GuardsManager getGuardsManager() {
        return guardsManager;
    }

    public static RegulatorManager getRegulatorManager() {
        return regulatorManager;
    }

    public static ConquestManager getConquestManager() {
        return conquestManager;
    }

    public static void setConquestManager(ConquestManager conquestManager) {
        GameManagement.conquestManager = conquestManager;
    }

    @Override
    public void onDisable() {
    }
}

