/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.ChampionInfo;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomPlayerLostEvent;
import org.kingdoms.events.KingdomPlayerWonEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.ProbabilityTool;

public class ChampionManager
extends Manager
implements Listener {
    private static Map<Integer, Kingdom> entityOwners = new ConcurrentHashMap<Integer, Kingdom>();
    private static Map<Integer, KingdomPlayer> targets = new ConcurrentHashMap<Integer, KingdomPlayer>();
    private static HashMap<Integer, Integer> determination = new HashMap();
    public static final HashMap<UUID, Location> defenders = new HashMap();
    private static final Map<Integer, Integer> dragTasks = new ConcurrentHashMap<Integer, Integer>();
    private static final Map<Integer, Integer> thorTasks = new ConcurrentHashMap<Integer, Integer>();
    private static final Map<Integer, Integer> plowTasks = new ConcurrentHashMap<Integer, Integer>();

    protected ChampionManager(Plugin plugin) {
        super(plugin);
    }

    public Kingdom getChampionOwner(int entityID) {
        return entityOwners.get(entityID);
    }

    public Entity startFight(SimpleLocation loc, KingdomPlayer challenger) {
        int thor;
        int plow;
        int weapon;
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("Could not spawn champion at [" + chunk.toString() + "]."));
            Kingdoms.logInfo((String)"No kingdom owns this land.");
            return null;
        }
        Kingdom defending = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (defending == null) {
            Kingdoms.logInfo((String)("Could not spawn champion at [" + chunk.toString() + "]."));
            Kingdoms.logInfo((String)("The owner of this land is [" + land.getOwner() + "] but there is no data."));
            Kingdoms.logInfo((String)"This seems to be a plugin malfunction and needed to be reported.");
            return null;
        }
        for (KingdomPlayer kp : defending.getOnlineMembers()) {
            defenders.put(kp.getUuid(), loc.toLocation());
        }
        challenger.getPlayer().setGameMode(GameMode.SURVIVAL);
        Location bukkitLoc = loc.toLocation();
        ChampionInfo info = defending.getChampionInfo();
        Zombie champion = (Zombie)bukkitLoc.getWorld().spawnEntity(bukkitLoc, EntityType.ZOMBIE);
        String CHAMPNAME = ChatColor.RED + defending.getKingdomName() + "'s Champion";
        champion.setCustomName(CHAMPNAME);
        champion.setCustomNameVisible(true);
        challenger.setChampionPlayerFightingWith((Entity)champion);
        challenger.setInvadingChunk(chunk);
        entityOwners.put(champion.getEntityId(), defending);
        targets.put(champion.getEntityId(), challenger);
        champion.setTarget((LivingEntity)challenger.getPlayer());
        champion.setBaby(false);
        champion.setMaxHealth(info.getHealth() > 2048 ? 2048.0 : (double)info.getHealth());
        champion.setHealth(info.getHealth() > 2048 ? 2048.0 : (double)info.getHealth());
        if (land.getStructure() != null) {
            if (land.getStructure().getType() == StructureType.NEXUS) {
                SimpleLocation nexusLoc = land.getStructure().getLoc();
                SimpleChunkLocation nexusChunk = nexusLoc.toSimpleChunk();
                if (chunk.equals(nexusChunk)) {
                    champion.setMaxHealth(info.getHealth() + 200 > 2048 ? 2048.0 : (double)(info.getHealth() + 200));
                    champion.setHealth(info.getHealth() + 200 > 2048 ? 2048.0 : (double)(info.getHealth() + 200));
                }
                if (chunk.equals(nexusChunk) && defending.getMisupgradeInfo().isNexusguard()) {
                    this.callReinforcement(loc, challenger, 50);
                }
            }
            if (land.getStructure().getType() == StructureType.POWERCELL && defending.getMisupgradeInfo().isPsioniccore() && Kingdoms.config.misc_upgrades_psioniccore_enabled) {
                champion.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 1000, 1));
            }
        }
        champion.getEquipment().setHelmet(new ItemStack(Material.PUMPKIN));
        ItemStack armor = new ItemStack(Material.DIAMOND_CHESTPLATE);
        if (info.getArmor() > 0) {
            armor.addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, info.getArmor() - 1);
        }
        champion.getEquipment().setChestplate(armor);
        if (info.getMimic() > 0) {
            ItemStack IS = challenger.getPlayer().getInventory().getHelmet();
            if (IS != null) {
                champion.getEquipment().setHelmet(IS);
            }
            if ((IS = challenger.getPlayer().getInventory().getBoots()) != null) {
                champion.getEquipment().setBoots(IS);
            }
            if ((IS = challenger.getPlayer().getInventory().getLeggings()) != null) {
                champion.getEquipment().setLeggings(IS);
            }
        }
        if (info.getAqua() > 0 && Enchantment.getByName((String)"DEPTH_STRIDER") != null) {
            ItemStack boots = champion.getEquipment().getBoots();
            if (boots == null) {
                champion.getEquipment().setBoots(new ItemStack(Material.IRON_BOOTS));
                boots = champion.getEquipment().getBoots();
            }
            if (boots.getType() == Material.AIR) {
                champion.getEquipment().setBoots(new ItemStack(Material.IRON_BOOTS));
                boots = champion.getEquipment().getBoots();
            }
            Kingdoms.logDebug((String)boots.getType().toString());
            boots.addUnsafeEnchantment(Enchantment.DURABILITY, 10);
            boots.addUnsafeEnchantment(Enchantment.getByName((String)"DEPTH_STRIDER"), 10);
        }
        if ((weapon = info.getWeapon()) == 0) {
            champion.getEquipment().setItemInHand(null);
        } else if (weapon == 1) {
            champion.getEquipment().setItemInHand(new ItemStack(Material.WOOD_SWORD));
        } else if (weapon == 2) {
            champion.getEquipment().setItemInHand(new ItemStack(Material.STONE_SWORD));
        } else if (weapon == 3) {
            champion.getEquipment().setItemInHand(new ItemStack(Material.IRON_SWORD));
        } else if (weapon == 4) {
            champion.getEquipment().setItemInHand(new ItemStack(Material.DIAMOND_SWORD));
        } else if (weapon > 4) {
            ItemStack diasword = new ItemStack(Material.DIAMOND_SWORD);
            diasword.addUnsafeEnchantment(Enchantment.DAMAGE_ALL, weapon - 4);
            champion.getEquipment().setItemInHand(diasword);
        }
        int drag = info.getDrag();
        if (drag > 0) {
            dragTasks.put(champion.getEntityId(), Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new DragTask(challenger.getPlayer(), (Entity)champion), 1L, 40L));
        }
        if ((plow = info.getPlow()) > 0) {
            plowTasks.put(champion.getEntityId(), Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new PlowTask(challenger.getPlayer(), (Entity)champion), 1L, 5L));
        }
        if ((thor = info.getThor()) > 0) {
            thorTasks.put(champion.getEntityId(), Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new ThorTask(challenger.getPlayer(), (Entity)champion, defending), 1L, (long)(Kingdoms.config.championThorTimer * 20.0)));
        }
        champion.getEquipment().setBootsDropChance(0.0f);
        champion.getEquipment().setChestplateDropChance(0.0f);
        champion.getEquipment().setHelmetDropChance(0.0f);
        champion.getEquipment().setItemInHandDropChance(0.0f);
        champion.getEquipment().setLeggingsDropChance(0.0f);
        int speed = info.getSpeed();
        if (speed > 0) {
            champion.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 999999, speed - 1));
        }
        return champion;
    }

    private void callReinforcement(SimpleLocation loc, KingdomPlayer target, int duration) {
        Location bukkitLoc = loc.toLocation();
        SimpleChunkLocation chunk = loc.toSimpleChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("Could not call reinforcement at [" + chunk.toString() + "]."));
            Kingdoms.logInfo((String)"No kingdom owns this land.");
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            Kingdoms.logInfo((String)("Could not call reinforcement at [" + chunk.toString() + "]."));
            Kingdoms.logInfo((String)("The owner of this land is [" + land.getOwner() + "] but there is no data."));
            Kingdoms.logInfo((String)"This seems to be a plugin malfunction and needed to be reported.");
            return;
        }
        GameManagement.getGuardsManager().spawnNexusGuard(bukkitLoc, kingdom, target);
    }

    public void stopFight(KingdomPlayer kp) {
        Entity champion = kp.getChampionPlayerFightingWith();
        if (champion == null) {
            Kingdoms.logInfo((String)"could not stop the fight.");
            Kingdoms.logInfo((String)("[" + kp.getPlayer().getName() + "] was fighting with nobody."));
            return;
        }
        Integer dragTask = dragTasks.remove(champion.getEntityId());
        Integer thorTask = thorTasks.remove(champion.getEntityId());
        Integer plowTask = plowTasks.remove(champion.getEntityId());
        if (dragTask != null) {
            Bukkit.getScheduler().cancelTask(dragTask.intValue());
        }
        if (thorTask != null) {
            Bukkit.getScheduler().cancelTask(thorTask.intValue());
        }
        if (plowTask != null) {
            Bukkit.getScheduler().cancelTask(plowTask.intValue());
        }
        entityOwners.remove(champion.getEntityId());
        targets.remove(champion.getEntityId());
        champion.remove();
        kp.setChampionPlayerFightingWith(null);
        kp.setInvadingChunk(null);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChallengerQuit(PlayerQuitEvent event) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (kp == null) {
            Kingdoms.logInfo((String)"kp was null!");
            return;
        }
        Entity champion = kp.getChampionPlayerFightingWith();
        if (champion == null) {
            return;
        }
        SimpleChunkLocation chunk = kp.getFightZone();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("[" + kp.getPlayer().getName() + "] was quit during fight."));
            Kingdoms.logInfo((String)"But the fightzone has no owner.");
            this.stopFight(kp);
            return;
        }
        this.stopFight(kp);
        Kingdom defending = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomPlayerLostEvent(kp, defending, chunk));
    }

    @EventHandler
    public void onChallengerDeath(PlayerDeathEvent e) {
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen((Entity)e.getEntity())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getEntity());
        if (kp.getChampionPlayerFightingWith() == null) {
            return;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(kp.getFightZone());
        Kingdom defender = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomPlayerLostEvent(kp, defender, kp.getFightZone()));
        this.stopFight(kp);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void championHp(EntityDamageEvent e) {
        World bukkitWorld = e.getEntity().getWorld();
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        if (!(e.getEntity() instanceof Damageable)) {
            return;
        }
        Damageable champion = (Damageable)e.getEntity();
        Kingdom kingdom = entityOwners.get(e.getEntity().getEntityId());
        e.getEntity().setCustomName(ChatColor.RED + kingdom.getKingdomName() + "'s Champion " + ChatColor.GRAY + "[" + ChatColor.GREEN + (int)(champion.getHealth() - e.getFinalDamage()) + ChatColor.AQUA + "/" + ChatColor.GREEN + champion.getMaxHealth() + ChatColor.GRAY + "]");
        e.getEntity().setCustomNameVisible(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChampionDamage(EntityDamageByEntityEvent e) {
        World bukkitWorld = e.getEntity().getWorld();
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        Player damager = (Player)e.getDamager();
        if (damager == null) {
            return;
        }
        KingdomPlayer challenger = GameManagement.getPlayerManager().getSession(damager);
        if (challenger == null) {
            Kingdoms.logInfo((String)"Fatal error! challenger was null!");
            return;
        }
        if (challenger.getKingdom() == null) {
            return;
        }
        Kingdom attacking = challenger.getKingdom();
        if (attacking.equals(entityOwners.get(e.getEntity().getEntityId()))) {
            Kingdoms.logInfo((String)"check kingdom");
            challenger.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Own_Kingdom));
            e.setDamage(0.0);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onChampionDetermination(EntityDamageByEntityEvent e) {
        World bukkitWorld = e.getEntity().getWorld();
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        Player damager = (Player)e.getDamager();
        if (damager == null) {
            return;
        }
        KingdomPlayer challenger = GameManagement.getPlayerManager().getSession(damager);
        if (challenger == null) {
            Kingdoms.logInfo((String)"Fatal error! challenger was null!");
            return;
        }
        ChampionInfo info = entityOwners.get(e.getEntity().getEntityId()).getChampionInfo();
        if (info.getDetermination() > 0) {
            if (!determination.containsKey(e.getEntity().getEntityId())) {
                determination.put(e.getEntity().getEntityId(), info.getDetermination());
            }
            if (determination.get(e.getEntity().getEntityId()) > 0) {
                int newd = (int)((double)determination.get(e.getEntity().getEntityId()).intValue() - e.getDamage());
                e.setDamage(0.0);
                challenger.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Determination).replaceAll("%amt%", "" + determination.get(e.getEntity().getEntityId())).replaceAll("%max%", "" + info.getDetermination()));
                determination.put(e.getEntity().getEntityId(), newd);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChampionDamageByTurretArrow(EntityDamageByEntityEvent e) {
        World bukkitWorld = e.getEntity().getWorld();
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        Kingdom champKingdom = entityOwners.get(e.getEntity().getEntityId());
        if (!(e.getDamager() instanceof Arrow)) {
            return;
        }
        Arrow a = (Arrow)e.getDamager();
        if (a.getMetadata("shooter") == null) {
            return;
        }
        if (a.getMetadata("shooter").size() < 1) {
            return;
        }
        String shooterKingdom = ((MetadataValue)a.getMetadata("shooter").get(0)).asString();
        if (shooterKingdom == null) {
            return;
        }
        Kingdom shootKingdom = GameManagement.getKingdomManager().getOrLoadKingdom(shooterKingdom);
        if (shootKingdom == null) {
            return;
        }
        if (shootKingdom.equals(champKingdom)) {
            e.setDamage(0.0);
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChampionDamageByPotion(PotionSplashEvent e) {
        World bukkitWorld = e.getEntity().getWorld();
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        Iterator iter = e.getAffectedEntities().iterator();
        while (iter.hasNext()) {
            KingdomPlayer shooter;
            Entity entity = (Entity)iter.next();
            if (!entityOwners.containsKey(entity.getEntityId())) continue;
            Kingdom champKingdom = entityOwners.get(entity.getEntityId());
            if (!(e.getPotion().getShooter() instanceof Player) || !champKingdom.equals((shooter = GameManagement.getPlayerManager().getSession((Player)e.getPotion().getShooter())).getKingdom()) && !champKingdom.isAllianceWith(shooter.getKingdom()) && shooter.getPlayer().getGameMode() == GameMode.SURVIVAL) continue;
            iter.remove();
        }
    }

    @EventHandler
    public void onChampionDeath(EntityDeathEvent event) {
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen((Entity)event.getEntity())) {
            return;
        }
        World bukkitWorld = event.getEntity().getWorld();
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        if (!entityOwners.containsKey(event.getEntity().getEntityId())) {
            return;
        }
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        KingdomPlayer challenger = targets.get(event.getEntity().getEntityId());
        if (challenger == null) {
            Kingdoms.logInfo((String)"Fatal error! challenger was null!");
            return;
        }
        if (challenger.getKingdom() == null) {
            return;
        }
        if (event.getEntity() != challenger.getChampionPlayerFightingWith()) {
            return;
        }
        SimpleChunkLocation chunk = challenger.getFightZone().clone();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        if (land.getOwner() == null) {
            Kingdoms.logInfo((String)("Error! champion of [" + chunk.toString() + "] is dead."));
            Kingdoms.logInfo((String)"But no kingdom owns this land.");
            this.stopFight(challenger);
            return;
        }
        Kingdom defending = entityOwners.get(event.getEntity().getEntityId());
        this.stopFight(challenger);
        event.getDrops().clear();
        this.plugin.getServer().getPluginManager().callEvent((Event)new KingdomPlayerWonEvent(challenger, defending, chunk));
    }

    @EventHandler
    public void onChallengerDeathWhileInvade(PlayerDeathEvent e) {
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen((Entity)e.getEntity())) {
            return;
        }
        World bukkitWorld = e.getEntity().getWorld();
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getEntity());
        if (kp.getChampionPlayerFightingWith() == null) {
            return;
        }
        this.stopFight(kp);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommandWhileFight(PlayerCommandPreprocessEvent e) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp == null) {
            GameManagement.getPlayerManager().loadKingdomPlayer(e.getPlayer());
        }
        if (kp.getChampionPlayerFightingWith() == null) {
            return;
        }
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Command_Block));
        e.setCancelled(true);
    }

    @EventHandler
    public void onTargetChange(EntityTargetLivingEntityEvent e) {
        World bukkitWorld = e.getEntity().getWorld();
        if (!Kingdoms.config.worlds.contains(bukkitWorld.getName())) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen((Entity)e.getTarget())) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        Kingdom kingdom = entityOwners.get(e.getEntity().getEntityId());
        KingdomPlayer challenger = targets.get(e.getEntity().getEntityId());
        if (e.getTarget() instanceof Player) {
            Player targetP = (Player)e.getTarget();
            KingdomPlayer target = GameManagement.getPlayerManager().getSession(targetP);
            if (target.getKingdom() == null) {
                return;
            }
            if (kingdom.equals(target.getKingdom()) || kingdom.equals(target.getKingdom())) {
                e.setTarget((Entity)challenger.getPlayer());
            }
        }
    }

    @EventHandler
    public void onKnockBack(final EntityDamageByEntityEvent e) {
        if (e.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK || e.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
            return;
        }
        if (e.getEntity().getType() != EntityType.ZOMBIE) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        Kingdom kingdom = entityOwners.get(e.getEntity().getEntityId());
        ChampionInfo info = kingdom.getChampionInfo();
        int resist = info.getResist();
        if (resist <= 0) {
            return;
        }
        if (ProbabilityTool.testProbability100(resist)) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    e.getEntity().setVelocity(new Vector());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onPlaceInMockRange(BlockPlaceEvent e) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(e.getPlayer());
        if (kp.getKingdom() == null) {
            return;
        }
        Entity entity = kp.getChampionPlayerFightingWith();
        if (entity == null) {
            return;
        }
        Kingdom defender = entityOwners.get(entity.getEntityId());
        ChampionInfo info = defender.getChampionInfo();
        int mock = info.getMock();
        if (mock <= 0) {
            return;
        }
        Location champLoc = entity.getLocation();
        int champX = champLoc.getBlockX();
        int champZ = champLoc.getBlockZ();
        int placingX = e.getBlock().getX();
        int placingZ = e.getBlock().getZ();
        int x = -mock;
        while (x <= mock) {
            int z = -mock;
            while (z <= mock) {
                if (champX + x == placingX && champZ + z == placingZ) {
                    e.setCancelled(true);
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Mock).replaceAll("%mock%", String.valueOf(mock)));
                    return;
                }
                ++z;
            }
            ++x;
        }
    }

    @EventHandler
    public void onDeathDuelChampDamageToNonInvader(EntityDamageByEntityEvent e) {
        if (e.getDamager().getType() != EntityType.ZOMBIE) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!entityOwners.containsKey(e.getDamager().getEntityId())) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getDamager())) {
            return;
        }
        KingdomPlayer damaged = GameManagement.getPlayerManager().getSession((Player)e.getEntity());
        if (damaged.getChampionPlayerFightingWith() != null) {
            return;
        }
        Kingdom kingdom = entityOwners.get(e.getDamager().getEntityId());
        ChampionInfo info = kingdom.getChampionInfo();
        int duel = info.getDuel();
        if (duel <= 0) {
            return;
        }
        e.setDamage(e.getDamage() * 2.0);
    }

    @EventHandler
    public void onDeathDuelNonInvaderDamageToChamp(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getDamager())) {
            return;
        }
        if (e.getEntity().getType() != EntityType.ZOMBIE) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        KingdomPlayer damager = GameManagement.getPlayerManager().getSession((Player)e.getDamager());
        if (damager.getChampionPlayerFightingWith() != null) {
            return;
        }
        Kingdom kingdom = entityOwners.get(e.getEntity().getEntityId());
        ChampionInfo info = kingdom.getChampionInfo();
        int duel = info.getDuel();
        if (duel <= 0) {
            return;
        }
        e.setDamage(e.getDamage() / 2.0);
        damager.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_DeathDuel));
    }

    @EventHandler
    public void onChampDamageWhileDamageCapOn(EntityDamageByEntityEvent e) {
        if (e.getEntity().getType() != EntityType.ZOMBIE) {
            return;
        }
        if (!entityOwners.containsKey(e.getEntity().getEntityId())) {
            return;
        }
        Kingdom kingdom = entityOwners.get(e.getEntity().getEntityId());
        ChampionInfo info = kingdom.getChampionInfo();
        int damageCap = info.getDamagecap();
        if (damageCap <= 0) {
            return;
        }
        if (e.getDamage() > 15.0) {
            e.setDamage(15.0);
        }
    }

    @EventHandler
    public void onFocus(EntityDamageByEntityEvent e) {
        if (e.getDamager().getType() != EntityType.ZOMBIE) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!entityOwners.containsKey(e.getDamager().getEntityId())) {
            return;
        }
        Player p = (Player)e.getEntity();
        Kingdom kingdom = entityOwners.get(e.getDamager().getEntityId());
        ChampionInfo info = kingdom.getChampionInfo();
        int focus = info.getFocus();
        if (focus <= 0) {
            return;
        }
        Collection effects = p.getActivePotionEffects();
        if (effects.size() > 0) {
            for (PotionEffect effect : effects) {
                PotionEffect pe = new PotionEffect(effect.getType(), effect.getDuration() - 1, effect.getAmplifier());
                p.removePotionEffect(effect.getType());
                p.addPotionEffect(effect);
            }
        }
    }

    @EventHandler
    public void onDamageWhileStrengthUp(EntityDamageByEntityEvent e) {
        if (e.getDamager().getType() != EntityType.ZOMBIE) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        GameManagement.getApiManager();
        if (ExternalManager.isCitizen(e.getEntity())) {
            return;
        }
        if (!entityOwners.containsKey(e.getDamager().getEntityId())) {
            return;
        }
        Kingdom kingdom = entityOwners.get(e.getDamager().getEntityId());
        ChampionInfo info = kingdom.getChampionInfo();
        int strength = info.getStrength();
        if (strength <= 0) {
            return;
        }
        if (ProbabilityTool.testProbability100(strength)) {
            e.getEntity().setVelocity(new Vector(0.0, 1.5, 0.0));
        }
    }

    public static Entity getEntityByEntityID(World world, int id) {
        for (Entity e : world.getEntities()) {
            if (e.getEntityId() != id) continue;
            return e;
        }
        return null;
    }

    @Override
    public void onDisable() {
        for (Map.Entry<Integer, KingdomPlayer> entry : targets.entrySet()) {
            this.stopFight(entry.getValue());
        }
        targets.clear();
    }

    public static void sendLightning(Player p, Location l) {
        Class<?> light = ChampionManager.getNMSClass("EntityLightning");
        try {
            Constructor<?> constu = light.getConstructor(ChampionManager.getNMSClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE);
            Object wh = p.getWorld().getClass().getMethod("getHandle", new Class[0]).invoke((Object)p.getWorld(), new Object[0]);
            Object lighobj = constu.newInstance(wh, l.getX(), l.getY(), l.getZ(), false, false);
            Object obj = ChampionManager.getNMSClass("PacketPlayOutSpawnEntityWeather").getConstructor(ChampionManager.getNMSClass("Entity")).newInstance(lighobj);
            try {
                ChampionManager.sendPacket(p, obj);
                p.playSound(p.getLocation(), Sound.valueOf((String)"AMBIENCE_THUNDER"), 100.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                try {
                    ChampionManager.sendPacket(p, obj);
                    p.playSound(p.getLocation(), Sound.valueOf((String)"ENTITY_LIGHTNING_THUNDER"), 100.0f, 1.0f);
                }
                catch (IllegalArgumentException ex) {
                    p.getWorld().strikeLightningEffect(p.getLocation());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Class<?> getNMSClass(String name) {
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            return Class.forName("net.minecraft.server." + version + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
            playerConnection.getClass().getMethod("sendPacket", ChampionManager.getNMSClass("Packet")).invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class DragTask
    implements Runnable {
        Player p;
        Entity champion;

        public DragTask(Player p, Entity champion) {
            this.p = p;
            this.champion = champion;
        }

        @Override
        public void run() {
            if (this.p == null || this.champion == null) {
                return;
            }
            if (!this.p.isDead() && !this.champion.isDead() && this.champion.isValid() && this.p.isOnline() && this.p.getLocation().distance(this.champion.getLocation()) > 7.0) {
                this.p.teleport(this.champion.getLocation());
                this.p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Drag));
            }
        }
    }

    private class PlowTask
    implements Runnable {
        Player p;
        Entity champion;

        public PlowTask(Player p, Entity champion) {
            this.p = p;
            this.champion = champion;
        }

        @Override
        public void run() {
            if (!this.p.isDead() && !this.champion.isDead() && this.champion.isValid() && this.p.isOnline()) {
                int radius = 1;
                int x = -radius;
                while (x <= radius) {
                    int y = -radius;
                    while (y <= radius) {
                        int z = -radius;
                        while (z <= radius) {
                            Material type = this.champion.getLocation().getBlock().getRelative(x, y, z).getType();
                            if (type == Material.WEB || type == Material.LAVA) {
                                this.champion.getLocation().getBlock().setType(Material.AIR);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        }
    }

    private class ThorTask
    implements Runnable {
        Player p;
        Entity champion;
        Kingdom kingdom;

        public ThorTask(Player p, Entity champion, Kingdom kingdom) {
            this.p = p;
            this.champion = champion;
            this.kingdom = kingdom;
        }

        @Override
        public void run() {
            if (this.p == null || this.champion == null) {
                return;
            }
            if (!this.p.isDead() && !this.champion.isDead() && this.champion.isValid() && this.p.isOnline()) {
                ChampionManager.sendLightning(this.p, this.p.getLocation());
                this.p.damage((double)this.kingdom.getChampionInfo().getThor(), this.champion);
                this.p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Thor));
            }
            for (Entity e : this.champion.getNearbyEntities(7.0, 7.0, 7.0)) {
                if (!(e instanceof Player) || e.getUniqueId().equals(this.p.getUniqueId())) continue;
                KingdomPlayer kpNear = GameManagement.getPlayerManager().getSession(e.getUniqueId());
                if (kpNear.getKingdom() == null) {
                    ChampionManager.sendLightning(this.p, this.p.getLocation());
                    this.p.damage((double)(this.kingdom.getChampionInfo().getThor() + 2), this.champion);
                    this.p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Thor));
                }
                if (kpNear.getKingdom().equals(this.kingdom) || kpNear.getKingdom().isAllianceWith(this.kingdom)) continue;
                ChampionManager.sendLightning(this.p, this.p.getLocation());
                this.p.damage((double)(this.kingdom.getChampionInfo().getThor() + 2), this.champion);
                this.p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Champion_Thor));
            }
        }
    }
}

