/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.external;

import com.github.games647.scoreboardstats.ScoreboardStats;
import com.github.games647.scoreboardstats.variables.ReplaceEvent;
import com.github.games647.scoreboardstats.variables.VariableReplaceAdapter;
import com.github.games647.scoreboardstats.variables.VariableReplacer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.events.KingdomMemberJoinEvent;
import org.kingdoms.events.KingdomMemberLeaveEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class ScoreboardManager
extends Manager
implements Listener {
    ScoreboardStats scoreboardStats;
    private boolean isNewVersion = false;

    protected ScoreboardManager(Plugin plugin) {
        super(plugin);
        this.scoreboardStats = (ScoreboardStats)plugin.getServer().getPluginManager().getPlugin("ScoreboardStats");
        Method method = this.getMethod();
        if (method == null) {
            Kingdoms.logInfo((String)"Couldn't initialize ScoreboardStats.");
            Kingdoms.logInfo((String)"This feature will be disabled.");
            return;
        }
        if (!this.isNewVersion) {
            try {
                method.invoke((Object)this.scoreboardStats.getReplaceManager(), new VariableReplacer(){

                    public void onReplace(Player p, String var, ReplaceEvent e) {
                        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
                        if (kp.getKingdom() == null) {
                            return;
                        }
                        Kingdom kingdom = kp.getKingdom();
                        switch (var) {
                            case "rp": {
                                e.setScore(kingdom.getResourcepoints());
                                break;
                            }
                            case "membercount": {
                                e.setScore(kingdom.getMembersList().size());
                                break;
                            }
                            case "memberonlinecount": {
                                e.setScore(kingdom.getOnlineMembers().size());
                                break;
                            }
                            case "land": {
                                e.setScore(kingdom.getLand());
                            }
                        }
                    }
                }, plugin, new String[]{"rp", "membercount", "memberonlinecount", "land"});
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                method.invoke((Object)this.scoreboardStats.getReplaceManager(), new VariableReplaceAdapter(plugin, new String[]{"rp", "membercount", "memberonlinecount", "land"}){

                    public void onReplace(Player p, String var, ReplaceEvent e) {
                        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
                        if (kp.getKingdom() == null) {
                            return;
                        }
                        Kingdom kingdom = kp.getKingdom();
                        switch (var) {
                            case "rp": {
                                e.setScore(kingdom.getResourcepoints());
                                break;
                            }
                            case "membercount": {
                                e.setScore(kingdom.getMembersList().size());
                                break;
                            }
                            case "memberonlinecount": {
                                e.setScore(kingdom.getOnlineMembers().size());
                                break;
                            }
                            case "land": {
                                e.setScore(kingdom.getLand());
                            }
                        }
                    }
                });
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private Method getMethod() {
        Class<?> clazz = this.scoreboardStats.getReplaceManager().getClass();
        Method method = null;
        try {
            method = clazz.getMethod("register", VariableReplacer.class, Plugin.class, String[].class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            this.isNewVersion = true;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        try {
            if (this.isNewVersion) {
                method = clazz.getMethod("register", VariableReplaceAdapter.class);
                method.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return method;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerJoin(PlayerJoinEvent event) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(event.getPlayer());
        if (kp == null) {
            return;
        }
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        this.scoreboardStats.getReplaceManager().updateScore(event.getPlayer(), "rp", kingdom.getResourcepoints());
        this.scoreboardStats.getReplaceManager().updateScore(event.getPlayer(), "membercount", kingdom.getMembersList().size());
        this.scoreboardStats.getReplaceManager().updateScore(event.getPlayer(), "memberonlinecount", kingdom.getOnlineMembers().size());
        this.scoreboardStats.getReplaceManager().updateScore(event.getPlayer(), "land", kingdom.getLand());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onKingdomMemberJoin(KingdomMemberJoinEvent e) {
        OfflineKingdomPlayer okp = e.getKp();
        if (!(okp instanceof KingdomPlayer)) {
            return;
        }
        KingdomPlayer kp = okp.getKingdomPlayer();
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = e.getKingdom();
        this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "rp", kingdom.getResourcepoints());
        this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "membercount", kingdom.getMembersList().size());
        this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "memberonlinecount", kingdom.getOnlineMembers().size());
        this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "land", kingdom.getLand());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onKingdomMemberQuit(KingdomMemberLeaveEvent e) {
        if (e.getKp() instanceof KingdomPlayer) {
            KingdomPlayer kp = (KingdomPlayer)e.getKp();
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "rp", 0);
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "membercount", 0);
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "memberonlinecount", 0);
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "land", 0);
        }
    }

    public void updateScoreboard(KingdomPlayer kp) {
        if (kp.getKingdom() == null) {
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "rp", 0);
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "membercount", 0);
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "memberonlinecount", 0);
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "land", 0);
        } else {
            Kingdom kingdom = kp.getKingdom();
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "rp", kingdom.getResourcepoints());
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "membercount", kingdom.getMembersList().size());
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "memberonlinecount", kingdom.getOnlineMembers().size());
            this.scoreboardStats.getReplaceManager().updateScore(kp.getPlayer(), "land", kingdom.getLand());
        }
    }

    @Override
    public void onDisable() {
    }
}

