/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.external;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.PlayerChangeChunkEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class DynmapManager
extends Manager
implements Listener {
    public DynmapAPI dynmap = (DynmapAPI)Bukkit.getPluginManager().getPlugin("dynmap");
    private static final String base = "<div>This land is owned by: <span style=\"font-weight:bold;color:black\">%kingdomName% </span><br><span style=\"font-weight:italic;color:red\">%king% </span><br><span style=\"font-weight:italic;color:red\">%membercount% </span><br><span style=\"font-weight:italic;color:red\">%resourcepoints% </span><br><span style=\"font-weight:bold;color:black\">Members: </span><br></div>";
    private boolean isLoading = false;

    public DynmapManager(Plugin plugin) {
        super(plugin);
        MarkerSet set = this.dynmap.getMarkerAPI().getMarkerSet("kingdoms");
        if (set != null) {
            set.deleteMarkerSet();
        }
        new BukkitRunnable(){

            public void run() {
                for (SimpleChunkLocation chunk : GameManagement.getLandManager().getAllLandLoc()) {
                    DynmapManager.this.updateClaimMarker(chunk);
                }
            }
        }.runTaskLater(plugin, 20L);
    }

    private String getChunkName(SimpleChunkLocation chunk) {
        return String.valueOf(chunk.getWorld()) + "@" + chunk.getX() + "," + chunk.getZ();
    }

    private static double[] toPrimitive(List<Double> array) {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return new double[0];
        }
        double[] result = new double[array.size()];
        int i = 0;
        while (i < array.size()) {
            result[i] = array.get(i);
            ++i;
        }
        return result;
    }

    private String getKingdomDesc(OfflineKingdom offKingdom) {
        String desc = base;
        desc = desc.replace("%kingdomName%", offKingdom.getKingdomName());
        desc = desc.replace("%king%", "King: " + offKingdom.getKingName());
        desc = desc.replace("%membercount%", "Number of Members: " + offKingdom.getMembersList().size());
        desc = desc.replace("%resourcepoints%", "ResourcePoints: " + offKingdom.getResourcepoints());
        if (offKingdom.isOnline()) {
            Kingdom kingdom = offKingdom.getKingdom();
            for (KingdomPlayer kp : kingdom.getOnlineMembers()) {
                try {
                    if (kp == null || kp.getPlayer() == null) continue;
                    desc = String.valueOf(desc) + "<span style=\"font-weight:italic;color:black\">" + kp.getPlayer().getName() + "</span><br>";
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        return desc;
    }

    private String getMarkerName(Chunk c) {
        return this.chunkToString(c);
    }

    private String chunkToString(Chunk c) {
        return String.valueOf(c.getWorld().getName()) + "@" + c.getX() + "," + c.getZ();
    }

    public void updateClaimMarker(SimpleChunkLocation chunk) {
        if (chunk == null) {
            return;
        }
        new Thread(new DynmapUpdateTask(chunk)).start();
    }

    public void removeClaimMarker(Chunk c) {
        if (c == null) {
            return;
        }
        MarkerAPI marker = this.dynmap.getMarkerAPI();
        MarkerSet set = marker.getMarkerSet("kingdoms");
        if (set == null) {
            return;
        }
        AreaMarker amarker = set.findAreaMarker(this.getMarkerName(c));
        if (amarker != null) {
            amarker.deleteMarker();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkChange(PlayerChangeChunkEvent e) {
        int radius = 1;
        Chunk center = e.getToChunk();
        int x = -radius;
        while (x <= radius) {
            int z = -radius;
            while (z <= radius) {
                SimpleChunkLocation loc = new SimpleChunkLocation(center.getWorld().getName(), center.getX() + x, center.getZ() + z);
                new Thread(new DynmapUpdateTask(loc)).start();
                ++z;
            }
            ++x;
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        Chunk center = e.getChunk();
        SimpleChunkLocation loc = new SimpleChunkLocation(center.getWorld().getName(), center.getX(), center.getZ());
        new Thread(new DynmapUpdateTask(loc)).start();
    }

    public void addMarkerUpdateQueue(SimpleChunkLocation chunk) {
        new Thread(new DynmapUpdateTask(chunk)).start();
    }

    @Override
    public void onDisable() {
    }

    private class DynmapUpdateTask
    implements Runnable {
        private SimpleChunkLocation chunk;
        private int count = 0;

        public DynmapUpdateTask(SimpleChunkLocation chunk) {
            this.chunk = chunk;
        }

        @Override
        public void run() {
            try {
                while (DynmapManager.this.isLoading) {
                    if (this.count == 10) {
                        return;
                    }
                    ++this.count;
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                return;
            }
            DynmapManager.this.isLoading = true;
            this.update();
            DynmapManager.this.isLoading = false;
        }

        public void update() {
            Land land;
            MarkerAPI marker = DynmapManager.this.dynmap.getMarkerAPI();
            MarkerSet set = marker.getMarkerSet("kingdoms");
            if (set == null) {
                set = marker.createMarkerSet("kingdoms", "kingdoms", null, true);
            }
            if ((land = GameManagement.getLandManager().getOrLoadLand(this.chunk)) == null || land.getOwner() == null) {
                AreaMarker amarker = set.findAreaMarker(DynmapManager.this.getChunkName(this.chunk));
                if (amarker != null) {
                    amarker.deleteMarker();
                }
                return;
            }
            OfflineKingdom kingdom = GameManagement.getKingdomManager().getOfflineKingdom(land.getOwner());
            if (kingdom == null && !land.getOwner().equals("WarZone") && !land.getOwner().equals("SafeZone")) {
                return;
            }
            ArrayList<Double> arrX = new ArrayList<Double>();
            ArrayList<Double> arrZ = new ArrayList<Double>();
            arrX.add((double)(this.chunk.getX() << 4) - 0.5);
            arrZ.add((double)(this.chunk.getZ() << 4) - 0.5);
            arrX.add((double)(this.chunk.getX() << 4) - 0.5);
            arrZ.add((double)(this.chunk.getZ() << 4 | 0xF) + 0.5);
            arrX.add((double)(this.chunk.getX() << 4 | 0xF) + 0.5);
            arrZ.add((double)(this.chunk.getZ() << 4 | 0xF) + 0.5);
            arrX.add((double)(this.chunk.getX() << 4 | 0xF) + 0.5);
            arrZ.add((double)(this.chunk.getZ() << 4) - 0.5);
            AreaMarker amarker = set.findAreaMarker(DynmapManager.this.getChunkName(this.chunk));
            if (amarker == null) {
                amarker = set.createAreaMarker(DynmapManager.this.getChunkName(this.chunk), land.getOwner(), false, this.chunk.getWorld(), DynmapManager.toPrimitive(arrX), DynmapManager.toPrimitive(arrZ), true);
            }
            if (kingdom == null) {
                if (land.getOwner().equals("WarZone")) {
                    amarker.setLineStyle(0, 0.0, 0xFF0000);
                    amarker.setFillStyle(0.8, 0xFF0000);
                    amarker.setDescription("WARZONE");
                } else {
                    amarker.setLineStyle(0, 0.0, 0xFFFF00);
                    amarker.setFillStyle(0.8, 0xFFFF00);
                    amarker.setDescription("SAFEZONE");
                }
                amarker.setCornerLocations(DynmapManager.toPrimitive(arrX), DynmapManager.toPrimitive(arrZ));
            } else {
                amarker.setLineStyle(0, 0.0, kingdom.getDynmapColor());
                amarker.setFillStyle(0.4, kingdom.getDynmapColor());
                amarker.setDescription(" " + DynmapManager.this.getKingdomDesc(kingdom));
                amarker.setCornerLocations(DynmapManager.toPrimitive(arrX), DynmapManager.toPrimitive(arrZ));
            }
            Kingdoms.logDebug((String)("updated dynmap at " + this.chunk.toString()));
        }
    }
}

