/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.KCommand;
import org.kingdoms.commands.admin.KCommandAdminBackup;
import org.kingdoms.commands.admin.KCommandAdminClear;
import org.kingdoms.commands.admin.KCommandAdminCreateConquestMap;
import org.kingdoms.commands.admin.KCommandAdminDeleteConquestMap;
import org.kingdoms.commands.admin.KCommandAdminDeleteKingdom;
import org.kingdoms.commands.admin.KCommandAdminDisband;
import org.kingdoms.commands.admin.KCommandAdminExtraLandClaimMax;
import org.kingdoms.commands.admin.KCommandAdminForceStopMasswar;
import org.kingdoms.commands.admin.KCommandAdminHelp;
import org.kingdoms.commands.admin.KCommandAdminImport;
import org.kingdoms.commands.admin.KCommandAdminJoin;
import org.kingdoms.commands.admin.KCommandAdminKing;
import org.kingdoms.commands.admin.KCommandAdminMassWar;
import org.kingdoms.commands.admin.KCommandAdminMod;
import org.kingdoms.commands.admin.KCommandAdminPacifistToggle;
import org.kingdoms.commands.admin.KCommandAdminReload;
import org.kingdoms.commands.admin.KCommandAdminRp;
import org.kingdoms.commands.admin.KCommandAdminRpForAll;
import org.kingdoms.commands.admin.KCommandAdminRpForPlayer;
import org.kingdoms.commands.admin.KCommandAdminSafeZone;
import org.kingdoms.commands.admin.KCommandAdminSeeNexus;
import org.kingdoms.commands.admin.KCommandAdminToggle;
import org.kingdoms.commands.admin.KCommandAdminWarZone;
import org.kingdoms.commands.user.KCommandAccept;
import org.kingdoms.commands.user.KCommandAlly;
import org.kingdoms.commands.user.KCommandBroadcast;
import org.kingdoms.commands.user.KCommandChat;
import org.kingdoms.commands.user.KCommandClaimLand;
import org.kingdoms.commands.user.KCommandCreateKingdom;
import org.kingdoms.commands.user.KCommandDecline;
import org.kingdoms.commands.user.KCommandDefend;
import org.kingdoms.commands.user.KCommandDemote;
import org.kingdoms.commands.user.KCommandDeposit;
import org.kingdoms.commands.user.KCommandDisbandKingdom;
import org.kingdoms.commands.user.KCommandDonate;
import org.kingdoms.commands.user.KCommandEnemy;
import org.kingdoms.commands.user.KCommandHome;
import org.kingdoms.commands.user.KCommandInfo;
import org.kingdoms.commands.user.KCommandInvade;
import org.kingdoms.commands.user.KCommandInvite;
import org.kingdoms.commands.user.KCommandJoinConquest;
import org.kingdoms.commands.user.KCommandKick;
import org.kingdoms.commands.user.KCommandKing;
import org.kingdoms.commands.user.KCommandLeave;
import org.kingdoms.commands.user.KCommandMap;
import org.kingdoms.commands.user.KCommandMarkers;
import org.kingdoms.commands.user.KCommandMod;
import org.kingdoms.commands.user.KCommandNexus;
import org.kingdoms.commands.user.KCommandSethome;
import org.kingdoms.commands.user.KCommandSetlore;
import org.kingdoms.commands.user.KCommandShow;
import org.kingdoms.commands.user.KCommandTop;
import org.kingdoms.commands.user.KCommandTradable;
import org.kingdoms.commands.user.KCommandUnclaim;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;

public class CommandExecutor {
    private Kingdoms plugin;
    private static final Map<String, KCommand> commands = new ConcurrentSkipListMap<String, KCommand>(String.CASE_INSENSITIVE_ORDER){
        {
            this.put("create", new KCommandCreateKingdom());
            this.put("disband", new KCommandDisbandKingdom());
            this.put("claim", new KCommandClaimLand());
            this.put("unclaim", new KCommandUnclaim());
            this.put("invade", new KCommandInvade());
            this.put("nexus", new KCommandNexus());
            this.put("map", new KCommandMap());
            this.put("invite", new KCommandInvite());
            this.put("accept", new KCommandAccept());
            this.put("decline", new KCommandDecline());
            this.put("leave", new KCommandLeave());
            this.put("kick", new KCommandKick());
            this.put("c", new KCommandChat());
            this.put("chat", new KCommandChat());
            this.put("broad", new KCommandBroadcast());
            this.put("bc", new KCommandBroadcast());
            this.put("king", new KCommandKing());
            this.put("info", new KCommandInfo());
            this.put("show", new KCommandShow());
            this.put("sethome", new KCommandSethome());
            this.put("home", new KCommandHome());
            this.put("ally", new KCommandAlly());
            this.put("enemy", new KCommandEnemy());
            this.put("setlore", new KCommandSetlore());
            this.put("top", new KCommandTop());
            this.put("mod", new KCommandMod());
            this.put("demote", new KCommandDemote());
            this.put("markers", new KCommandMarkers());
            this.put("tradable", new KCommandTradable());
            this.put("donate", new KCommandDonate());
            this.put("admin", new KCommandAdminHelp());
            this.put("defend", new KCommandDefend());
            this.put("deposit", new KCommandDeposit());
            this.put("joinconquest", new KCommandJoinConquest());
        }
    };
    private static final Map<String, KCommand> adminCommands = new ConcurrentSkipListMap<String, KCommand>(String.CASE_INSENSITIVE_ORDER){
        {
            this.put("toggle", new KCommandAdminToggle());
            this.put("disband", new KCommandAdminDisband());
            this.put("extralandclaimmax", new KCommandAdminExtraLandClaimMax());
            this.put("elcm", new KCommandAdminExtraLandClaimMax());
            this.put("rp", new KCommandAdminRp());
            this.put("rpforall", new KCommandAdminRpForAll());
            this.put("safezone", new KCommandAdminSafeZone());
            this.put("warzone", new KCommandAdminWarZone());
            this.put("clear", new KCommandAdminClear());
            this.put("rpforplayer", new KCommandAdminRpForPlayer());
            this.put("masswar", new KCommandAdminMassWar());
            this.put("forcestopmasswar", new KCommandAdminForceStopMasswar());
            this.put("king", new KCommandAdminKing());
            this.put("join", new KCommandAdminJoin());
            this.put("reload", new KCommandAdminReload());
            this.put("backup", new KCommandAdminBackup());
            this.put("import", new KCommandAdminImport());
            this.put("seenexus", new KCommandAdminSeeNexus());
            this.put("mod", new KCommandAdminMod());
            this.put("debugdelete", new KCommandAdminDeleteKingdom());
            this.put("pacifisttoggle", new KCommandAdminPacifistToggle());
            this.put("createconquestmap", new KCommandAdminCreateConquestMap());
            this.put("deleteconquestmap", new KCommandAdminDeleteConquestMap());
        }
    };
    private static final int MAXLINES = 6;

    CommandExecutor(Plugin plugin) {
        this.plugin = (Kingdoms)plugin;
    }

    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        block35: {
            LinkedList<String> arguments;
            KCommand command;
            Player player;
            block36: {
                block38: {
                    block37: {
                        block34: {
                            int i;
                            player = null;
                            if (sender instanceof Player) {
                                player = (Player)sender;
                            }
                            if (!(label.equals("k") || label.equals("kingdom") || label.equals("kingdoms"))) {
                                return;
                            }
                            if (player != null && !Kingdoms.config.worlds.contains(player.getWorld().getName())) {
                                player.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Invalid_World));
                                return;
                            }
                            if (args.length == 0 || args.length == 1 && (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("h"))) {
                                ArrayList<Map.Entry<String, KCommand>> entries = new ArrayList<Map.Entry<String, KCommand>>();
                                entries.addAll(commands.entrySet());
                                for (Map.Entry<String, KCommand> entry : adminCommands.entrySet()) {
                                    if (!entry.getValue().canExecute(sender)) continue;
                                    entries.add(new AbstractMap.SimpleEntry<String, KCommand>("admin " + entry.getKey(), entry.getValue()));
                                }
                                sender.sendMessage(ChatColor.GRAY + "======== " + ChatColor.GOLD + "Kingdoms+" + ChatColor.GRAY + " ========");
                                int i2 = 0;
                                while (i2 < 6) {
                                    String key = (String)((Map.Entry)entries.get(i2)).getKey();
                                    KCommand command2 = (KCommand)((Map.Entry)entries.get(i2)).getValue();
                                    if (player != null) {
                                        sender.sendMessage(ChatColor.LIGHT_PURPLE + "/k " + key + ChatColor.WHITE + " - " + (command2.getDescription() == null ? null : command2.getDescription()));
                                    } else {
                                        sender.sendMessage("/k " + key + " - " + (command2.getDescription() == null ? null : command2.getDescription()));
                                    }
                                    ++i2;
                                }
                                sender.sendMessage("" + ChatColor.LIGHT_PURPLE);
                                if (entries.size() % 6 == 0) {
                                    sender.sendMessage(ChatColor.GOLD + "Page " + ChatColor.GRAY + "1/" + entries.size() / 6);
                                } else {
                                    sender.sendMessage(ChatColor.GOLD + "Page " + ChatColor.GRAY + "1/" + (entries.size() / 6 + 1));
                                }
                                sender.sendMessage(ChatColor.GOLD + "to " + ChatColor.GOLD + "/k help " + ChatColor.GRAY + "<page> " + ChatColor.GOLD + "to see next pages.");
                                sender.sendMessage("" + ChatColor.GRAY);
                                return;
                            }
                            if (args.length == 2 && (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("h"))) {
                                int page = 0;
                                try {
                                    page = Integer.parseInt(args[1]);
                                }
                                catch (NumberFormatException e) {
                                    sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Invalid_Page).replaceAll("%args%", args[1]));
                                    return;
                                }
                                --page;
                                ArrayList<Map.Entry<String, KCommand>> entries = new ArrayList<Map.Entry<String, KCommand>>();
                                entries.addAll(commands.entrySet());
                                for (Map.Entry<String, KCommand> entry : adminCommands.entrySet()) {
                                    if (!entry.getValue().canExecute(sender)) continue;
                                    entries.add(new AbstractMap.SimpleEntry<String, KCommand>("admin " + entry.getKey(), entry.getValue()));
                                }
                                if (page * 6 >= entries.size() || page < 0) {
                                    sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Invalid_Page).replaceAll("%args%", args[1]));
                                    return;
                                }
                                sender.sendMessage(ChatColor.GRAY + "======== " + ChatColor.GOLD + "Kingdoms+" + ChatColor.GRAY + " ========");
                                int i3 = page * 6;
                                while (i3 < (page + 1) * 6) {
                                    if (i3 == entries.size()) break;
                                    String key = (String)((Map.Entry)entries.get(i3)).getKey();
                                    KCommand command3 = (KCommand)((Map.Entry)entries.get(i3)).getValue();
                                    if (player != null) {
                                        sender.sendMessage(ChatColor.LIGHT_PURPLE + "/k " + key + ChatColor.WHITE + " - " + (command3.getDescription() == null ? null : command3.getDescription()));
                                    } else {
                                        sender.sendMessage("/k " + key + " - " + (command3.getDescription() == null ? null : command3.getDescription()));
                                    }
                                    ++i3;
                                }
                                sender.sendMessage("" + ChatColor.LIGHT_PURPLE);
                                if (entries.size() % 6 == 0) {
                                    sender.sendMessage(ChatColor.GOLD + "Page " + ChatColor.GRAY + args[1] + "/" + entries.size() / 6);
                                } else {
                                    sender.sendMessage(ChatColor.GOLD + "Page " + ChatColor.GRAY + args[1] + "/" + (entries.size() / 6 + 1));
                                }
                                sender.sendMessage(ChatColor.GOLD + "do " + ChatColor.GOLD + "/k help " + ChatColor.GRAY + "<page> " + ChatColor.GOLD + "to see next pages.");
                                sender.sendMessage("" + ChatColor.GRAY);
                                return;
                            }
                            command = null;
                            arguments = new LinkedList<String>();
                            if (args.length > 1 && args[0].equalsIgnoreCase("admin")) {
                                i = 2;
                                while (i < args.length) {
                                    arguments.add(args[i]);
                                    ++i;
                                }
                                command = adminCommands.get(args[1]);
                            } else {
                                i = 1;
                                while (i < args.length) {
                                    arguments.add(args[i]);
                                    ++i;
                                }
                                command = commands.get(args[0]);
                            }
                            if (command != null) break block34;
                            if (player != null) {
                                sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Invalid_Command));
                            } else {
                                sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Invalid_Command));
                            }
                            break block35;
                        }
                        if (!sender.isOp() && !command.canExecute(sender)) {
                            sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Permissions));
                            return;
                        }
                        if (player == null) break block36;
                        if (command.getArgsAmount() != -1) break block37;
                        command.execute((CommandSender)player, arguments);
                        break block35;
                    }
                    if (arguments.size() != command.getArgsAmount()) break block38;
                    command.execute((CommandSender)player, arguments);
                    break block35;
                }
                sender.sendMessage(ChatColor.LIGHT_PURPLE + "/k " + args[0] + " 's explanation:");
                if (command.getUsage() == null) break block35;
                String[] stringArray = command.getUsage();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    sender.sendMessage(ChatColor.GRAY + "   " + str);
                    ++n2;
                }
                break block35;
            }
            Kingdoms.logDebug((String)(arguments.size() + "|" + command.getArgsAmount() + "|" + command.getDescription()));
            if (command.getArgsAmount() == -1) {
                command.execute((CommandSender)player, arguments);
            } else if (arguments.size() == command.getArgsAmount()) {
                command.execute((CommandSender)player, arguments);
            } else {
                sender.sendMessage("/k " + args[0] + " 's explanation:");
                if (command.getUsage() != null) {
                    String[] stringArray = command.getUsage();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String str = stringArray[n3];
                        sender.sendMessage("    " + str);
                        ++n3;
                    }
                }
            }
        }
    }

    private void CommandReload() {
        Kingdoms.config.reload();
        Kingdoms.getLang().reload();
    }
}

