/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.json.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.UUID;
import org.generallib.database.serialize.Serializer;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.land.Extractor;
import org.kingdoms.constants.land.Regulator;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Structure;
import org.kingdoms.main.Kingdoms;

public class StructureSerializer
implements Serializer<Structure> {
    public JsonElement serialize(Structure obj, Type type, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add("type", context.serialize((Object)obj.getType()));
        json.add("loc", context.serialize((Object)obj.getLoc()));
        if (obj.getType() == StructureType.EXTRACTOR) {
            json.add("time", context.serialize((Object)((Extractor)obj).getTimeToNextCollection()));
        }
        if (obj.getType() == StructureType.REGULATOR) {
            json.add("whoCanBuild", context.serialize(((Regulator)obj).getWhoCanBuild()));
            json.add("whoCanInteract", context.serialize(((Regulator)obj).getWhoCanInteract()));
            json.add("allowMonsterSpawning", context.serialize((Object)((Regulator)obj).isAllowMonsterSpawning()));
            json.add("allowAnimalSpawning", context.serialize((Object)((Regulator)obj).isAllowAnimalSpawning()));
        }
        return json;
    }

    public Structure deserialize(JsonElement obj, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = (JsonObject)obj;
        StructureType t = (StructureType)((Object)context.deserialize(json.get("type"), StructureType.class));
        SimpleLocation loc = (SimpleLocation)context.deserialize(json.get("loc"), SimpleLocation.class);
        if (t == StructureType.EXTRACTOR) {
            long time = 0L;
            time = json.get("time") != null ? (Long)context.deserialize(json.get("time"), Long.class) : System.currentTimeMillis();
            return new Extractor(loc, t, time);
        }
        if (t == StructureType.REGULATOR) {
            ArrayList list;
            ArrayList<UUID> whoCanBuild = new ArrayList<UUID>();
            ArrayList<UUID> whoCanInteract = new ArrayList<UUID>();
            boolean allowMonsterSpawning = false;
            boolean allowAnimalSpawning = false;
            if (json.get("whoCanBuild") != null) {
                list = (ArrayList)context.deserialize(json.get("whoCanBuild"), ArrayList.class);
                for (String s : list) {
                    if (whoCanBuild.contains(UUID.fromString(s))) continue;
                    whoCanBuild.add(UUID.fromString(s));
                }
            }
            if (json.get("whoCanInteract") != null) {
                list = (ArrayList)context.deserialize(json.get("whoCanInteract"), ArrayList.class);
                for (String s : list) {
                    if (whoCanInteract.contains(UUID.fromString(s))) continue;
                    whoCanInteract.add(UUID.fromString(s));
                }
            }
            if (json.get("allowMonsterSpawning") != null) {
                allowMonsterSpawning = (Boolean)context.deserialize(json.get("allowMonsterSpawning"), Boolean.class);
                if (!Kingdoms.config.regulatorAllowMonsterToggle) {
                    allowMonsterSpawning = true;
                }
            }
            if (json.get("allowAnimalSpawning") != null) {
                allowAnimalSpawning = (Boolean)context.deserialize(json.get("allowAnimalSpawning"), Boolean.class);
                if (!Kingdoms.config.regulatorAllowAnimalToggle) {
                    allowAnimalSpawning = true;
                }
            }
            return new Regulator(loc, t, whoCanBuild, whoCanInteract, allowMonsterSpawning, allowAnimalSpawning);
        }
        return new Structure(loc, t);
    }
}

