/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.kingdoms.constants.land.SimpleChunkLocation;

public class SimpleLocation {
    private String world;
    private int x;
    private int y;
    private int z;

    public SimpleLocation(Location loc) {
        this.world = loc.getWorld().getName();
        this.x = loc.getBlockX();
        this.y = loc.getBlockY();
        this.z = loc.getBlockZ();
    }

    public SimpleLocation(String world, int x, int y, int z) {
        Validate.notNull((Object)world);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location toLocation() {
        Location loc = new Location(Bukkit.getWorld((String)this.world), (double)this.x, (double)this.y, (double)this.z);
        return loc;
    }

    public SimpleChunkLocation toSimpleChunk() {
        SimpleChunkLocation sc = new SimpleChunkLocation(this.world, this.x >> 4, this.z >> 4);
        return sc;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public SimpleLocation clone() {
        return new SimpleLocation(this.world, this.x, this.y, this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleLocation other = (SimpleLocation)obj;
        if (this.world == null ? other.world != null : !this.world.equals(other.world)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return String.valueOf(this.world) + " , " + this.x + " , " + this.y + " , " + this.z;
    }

    public static String locToStr(Location loc) {
        if (loc == null) {
            return "";
        }
        String world = loc.getWorld().getName();
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        float pitch = loc.getPitch();
        float yaw = loc.getYaw();
        return String.valueOf(world) + " , " + x + " , " + y + " , " + z;
    }

    public static Location strToLoc(String loc) {
        if (loc == null) {
            return null;
        }
        String[] split = loc.replaceAll(" ", "").split(",");
        if (split.length != 4 && split.length != 6) {
            return null;
        }
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            return null;
        }
        double x = Double.parseDouble(split[1]);
        double y = Double.parseDouble(split[2]);
        double z = Double.parseDouble(split[3]);
        Location location = new Location(world, x, y, z);
        return location;
    }

    public static Location oldComplexStrToLoc(String reverseChunk) {
        if (reverseChunk == null) {
            return null;
        }
        String[] split = reverseChunk.replaceAll(" ", "").split(",");
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            return null;
        }
        double x = Double.parseDouble(split[1]);
        double y = Double.parseDouble(split[2]);
        double z = Double.parseDouble(split[3]);
        float pitch = Float.parseFloat(split[4]);
        float yaw = Float.parseFloat(split[5]);
        Location loc = new Location(world, x, y, z);
        loc.setPitch(pitch);
        loc.setYaw(yaw);
        return loc;
    }
}

