/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.kingdoms.main.Kingdoms;

public class SimpleChunkLocation {
    private String world;
    private int x;
    private int z;

    public SimpleChunkLocation(String world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public SimpleChunkLocation(Chunk chunk) {
        this.world = chunk.getWorld().getName();
        this.x = chunk.getX();
        this.z = chunk.getZ();
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public SimpleChunkLocation clone() {
        return new SimpleChunkLocation(this.world, this.x, this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleChunkLocation other = (SimpleChunkLocation)obj;
        if (this.world == null ? other.world != null : !this.world.equals(other.world)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return String.valueOf(this.world) + " , " + this.x + " , " + this.z;
    }

    public Chunk toChunk() {
        return Bukkit.getWorld((String)this.world).getChunkAt(this.x, this.z);
    }

    public static Chunk toChunk(SimpleChunkLocation loc) {
        return Bukkit.getWorld((String)loc.world).getChunkAt(loc.x, loc.z);
    }

    public static SimpleChunkLocation chunkStrToLoc(String chunk) {
        if (chunk == null) {
            return null;
        }
        String[] split = chunk.replaceAll(" ", "").split(",");
        String world = split.length == 2 ? Kingdoms.config.worlds.get(0) : split[0];
        int x = split.length == 2 ? Integer.parseInt(split[0]) : Integer.parseInt(split[1]);
        int z = split.length == 2 ? Integer.parseInt(split[1]) : Integer.parseInt(split[2]);
        SimpleChunkLocation sc = new SimpleChunkLocation(world, x, z);
        return sc;
    }

    public static SimpleChunkLocation oldReversedChunkStrToLoc(String chunk) {
        if (chunk == null) {
            return null;
        }
        String[] split = chunk.replaceAll(" ", "").split(",");
        int x = Integer.parseInt(split[0]);
        int z = Integer.parseInt(split[1]);
        String world = split.length == 2 ? Kingdoms.config.worlds.get(0) : split[2];
        SimpleChunkLocation sc = new SimpleChunkLocation(world, x, z);
        return sc;
    }
}

