/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Structure;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class Extractor
extends Structure {
    private long timeToNextCollection;

    public Extractor(SimpleLocation loc, StructureType type) {
        super(loc, type);
        this.timeToNextCollection = System.currentTimeMillis();
    }

    public Extractor(SimpleLocation loc, StructureType type, long timeToNextCollection) {
        super(loc, type);
        this.timeToNextCollection = timeToNextCollection;
    }

    public void collect() {
        this.timeToNextCollection = System.currentTimeMillis();
        Kingdoms.getManagers();
        Land land = GameManagement.getLandManager().getOrLoadLand(this.getLoc().toSimpleChunk());
        if (land.getOwner() != null) {
            Kingdoms.getManagers();
            Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
            kingdom.setResourcepoints(kingdom.getResourcepoints() + Kingdoms.config.minerewardamt);
            kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Extractor_Collection_Announcement).replaceAll("%amount%", "" + Kingdoms.config.minerewardamt), true);
        }
    }

    public boolean isReady() {
        return this.getTimeLeft() <= 0;
    }

    public long getTimeToNextCollection() {
        return this.timeToNextCollection;
    }

    public int getTimeLeft() {
        int f = -1;
        long now = System.currentTimeMillis();
        int totalTime = Kingdoms.config.minerewardtime * 60;
        int r = (int)(now - this.timeToNextCollection) / 1000;
        f = (r - totalTime) * -1;
        return f / 60;
    }
}

