/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.kingdom;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.KingdomManager;

public class OfflineKingdom {
    String kingName = null;
    String kingdomName;
    String kingdomLore;
    int dynmapColor = KingdomManager.getRandomColor();
    UUID king;
    int might = 0;
    int resourcepoints = 0;
    long shieldDuration = 0L;
    int extraLandClaims = 0;
    List<UUID> membersList = new ArrayList<UUID>();
    boolean isNeutral = false;
    boolean hasInvaded = false;
    List<String> enemiesList = new ArrayList<String>();
    List<String> alliesList = new ArrayList<String>();
    HashMap<String, String> invasionLog = new HashMap();
    public int timeLeftToNextInvasion = 0;

    protected OfflineKingdom() {
    }

    public OfflineKingdom(String kingdomName) {
        this.kingdomName = kingdomName;
    }

    public void addInvasionLog(OfflineKingdom victim, OfflineKingdomPlayer invader, boolean isVictory, Land target) {
        Date date = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("E dd MM YYYY 'at' hh:mm:ss a zzz");
        String stringDate = ft.format(date);
        if (!this.invasionLog.containsKey("[" + this.invasionLog.size() + "] " + stringDate)) {
            this.invasionLog.put("[" + this.invasionLog.size() + "] " + stringDate, String.valueOf(victim.getKingdomName()) + "," + invader.getName() + "," + isVictory + "," + target.getLoc().toString());
        }
    }

    public boolean isShieldUp() {
        return this.getShieldTimeLeft() > 0;
    }

    public long getTimeToShieldExpiration() {
        return this.shieldDuration;
    }

    public void removeShield() {
        this.shieldDuration = 0L;
    }

    public int getShieldTimeLeft() {
        if (this.shieldDuration == 0L) {
            return 0;
        }
        int f = -1;
        long now = System.currentTimeMillis();
        int totalTime = Kingdoms.config.beginnerKingdomShieldTime * 60;
        int r = (int)(now - this.shieldDuration) / 1000;
        f = (r - totalTime) * -1;
        return f / 60;
    }

    public void giveShield() {
        this.shieldDuration = System.currentTimeMillis();
    }

    public HashMap<String, String> getInvasionLog() {
        return this.invasionLog;
    }

    public boolean isOnline() {
        return GameManagement.getKingdomManager().isOnline(this.kingdomName);
    }

    public String getKingdomName() {
        return this.kingdomName;
    }

    public Kingdom getKingdom() {
        return GameManagement.getKingdomManager().getOrLoadKingdom(this.kingdomName);
    }

    public String getKingName() {
        OfflinePlayer p;
        if (this.kingName == null && (p = Bukkit.getOfflinePlayer((UUID)this.king)) != null) {
            this.kingName = p.getName();
        }
        return this.kingName;
    }

    public int getResourcepoints() {
        return this.resourcepoints;
    }

    public int getMight() {
        return this.might;
    }

    public String getKingdomLore() {
        return this.kingdomLore;
    }

    public void setKing(UUID uuid) {
        this.king = uuid;
    }

    public UUID getKing() {
        return this.king;
    }

    public int getDynmapColor() {
        return this.dynmapColor;
    }

    public List<UUID> getMembersList() {
        ArrayList<UUID> contained = new ArrayList<UUID>();
        for (UUID uuid : this.membersList) {
            if (contained.contains(uuid)) continue;
            contained.add(uuid);
        }
        this.membersList = contained;
        return this.membersList;
    }

    public List<String> getEnemiesList() {
        return this.enemiesList;
    }

    public List<String> getAlliesList() {
        return this.alliesList;
    }

    public boolean isAllianceWith(Kingdom ally) {
        if (ally == null) {
            return false;
        }
        return this.alliesList.contains(ally.getKingdomName()) && ally.alliesList.contains(this.getKingdomName());
    }

    public boolean isEnemyWith(Kingdom enemy) {
        if (enemy == null) {
            return false;
        }
        return this.enemiesList.contains(enemy.getKingdomName());
    }

    public boolean isNeutral() {
        return this.isNeutral;
    }

    public boolean hasInvaded() {
        return this.hasInvaded;
    }

    public void setNeutral(boolean isNeutral) {
        this.isNeutral = isNeutral;
    }

    public int getExtraLandClaims() {
        return this.extraLandClaims;
    }

    public void setExtraLandClaims(int additionalLandMax) {
        this.extraLandClaims = additionalLandMax;
    }

    public void setHasInvaded(boolean hasInvaded) {
        this.hasInvaded = hasInvaded;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kingdomName == null ? 0 : this.kingdomName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfflineKingdom other = (OfflineKingdom)obj;
        return !(this.kingdomName == null ? other.kingdomName != null : !this.kingdomName.equals(other.kingdomName));
    }
}

