/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.kingdom;

import java.util.HashMap;
import java.util.Map;

public class KingdomCooldown {
    private static Map<String, KingdomCooldown> cooldowns = new HashMap<String, KingdomCooldown>();
    private long start;
    private final int timeInSeconds;
    private final String kingdomName;
    private final String cooldownName;

    public KingdomCooldown(String kingdomName, String cooldownName, int timeInSeconds) {
        this.kingdomName = kingdomName;
        this.cooldownName = cooldownName;
        this.timeInSeconds = timeInSeconds;
    }

    public static boolean isInCooldown(String id, String cooldownName) {
        if (KingdomCooldown.getTimeLeft(id, cooldownName) >= 1) {
            return true;
        }
        KingdomCooldown.stop(id, cooldownName);
        return false;
    }

    private static void stop(String id, String cooldownName) {
        cooldowns.remove(String.valueOf(id) + cooldownName);
    }

    private static KingdomCooldown getCooldown(String id, String cooldownName) {
        return cooldowns.get(String.valueOf(id.toString()) + cooldownName);
    }

    public static int getTimeLeft(String id, String cooldownName) {
        KingdomCooldown cooldown = KingdomCooldown.getCooldown(id, cooldownName);
        int f = -1;
        if (cooldown != null) {
            long now = System.currentTimeMillis();
            long cooldownTime = cooldown.start;
            int totalTime = cooldown.timeInSeconds;
            int r = (int)(now - cooldownTime) / 1000;
            f = (r - totalTime) * -1;
        }
        return f;
    }

    public void start() {
        this.start = System.currentTimeMillis();
        cooldowns.put(String.valueOf(this.kingdomName.toString()) + this.cooldownName, this);
    }
}

