/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandUnclaim
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return -1;
    }

    @Override
    public String[] getUsage() {
        return new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_All_Usage), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_Usage)};
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.unclaim");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        String arg = args.poll();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getUnclaim())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getClaim().toString()));
            return;
        }
        if (arg == null) {
            SimpleChunkLocation chunk = kp.getLoc();
            Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
            if (land.getOwner() == null || !land.getOwner().equals(kingdom.getKingdomName())) {
                kp.sendMessage("This is not your land.");
                return;
            }
            GameManagement.getLandManager().unclaimLand(chunk, kingdom);
            Kingdoms.getLang().addInteger(5);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_Lostmight));
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_Success));
        } else if (arg.equalsIgnoreCase("all")) {
            if (kp.isConfirmed("unclaimAll")) {
                int lands = GameManagement.getLandManager().unclaimAllLand(kingdom);
                Kingdoms.getLang().addInteger(lands);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_All_LostLandTotal));
                Kingdoms.getLang().addInteger(5 * lands);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_Lostmight));
            } else {
                kp.setConfirmed("unclaimAll");
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_All_DoNotMove));
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Unclaim_All_TypeAgain));
            }
        } else {
            String[] stringArray = this.getUsage();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                user.sendMessage(ChatColor.GRAY + "    " + str);
                ++n2;
            }
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Unclaim);
    }
}

