/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.manager.gui.NexusGUIManager;

public class KCommandTradable
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        if (sender.hasPermission("kingdoms.untradable")) {
            return true;
        }
        return sender.hasPermission("kingdoms.tradable");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (Kingdoms.config.useWhiteList) {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_Conversion_Ratio_Msg).replaceAll("%rpi%", "" + Kingdoms.config.items_needed_for_one_resource_point));
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_Enabled_Items_Title));
            Kingdoms.getGuiManagement();
            GUIManagement.getNexusGUIManager();
            for (ItemStack mat : NexusGUIManager.whiteListed.keySet()) {
                String addition = mat.getType().toString();
                if (mat.getDurability() != 0) {
                    addition = String.valueOf(addition) + ":" + mat.getDurability();
                }
                StringBuilder stringBuilder = new StringBuilder().append(ChatColor.GREEN).append(addition).append(" | ").append(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_Worth)).append(" ");
                Kingdoms.getGuiManagement();
                GUIManagement.getNexusGUIManager();
                user.sendMessage(stringBuilder.append(NexusGUIManager.whiteListed.get(new ItemStack(mat.getType(), 1, (short)((byte)mat.getDurability())))).append(" ").append(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_ItemsUnit)).toString());
            }
        } else {
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_Disabled_Items_Title));
            Kingdoms.getGuiManagement();
            GUIManagement.getNexusGUIManager();
            for (ItemStack mat : NexusGUIManager.blackListed) {
                String message = ChatColor.RED + mat.getType().toString();
                if (mat.getDurability() != 0) {
                    message = String.valueOf(message) + ":" + mat.getDurability();
                }
                user.sendMessage(message);
            }
            user.sendMessage("");
            user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_Special_Case_Items_Title));
            Kingdoms.getGuiManagement();
            GUIManagement.getNexusGUIManager();
            for (ItemStack mat : NexusGUIManager.specials.keySet()) {
                String addition = mat.getType().toString();
                if (mat.getDurability() != 0) {
                    addition = String.valueOf(addition) + ":" + mat.getDurability();
                }
                StringBuilder stringBuilder = new StringBuilder().append(ChatColor.GREEN).append(addition).append(" | ").append(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_Worth)).append(" ");
                Kingdoms.getGuiManagement();
                GUIManagement.getNexusGUIManager();
                user.sendMessage(stringBuilder.append(NexusGUIManager.specials.get(new ItemStack(mat.getType(), 1, (short)((byte)mat.getDurability())))).append(" ").append(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Tradable_ItemsUnit)).toString());
            }
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Tradable);
    }
}

