/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.ArrayList;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandShow
extends KCommandBase {
    private static boolean isProcessing = false;

    @Override
    public int getArgsAmount() {
        return -1;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.show");
    }

    @Override
    public void executeCommandConsole(final Queue<String> args) {
        final ConsoleCommandSender sender = Bukkit.getConsoleSender();
        if (args.size() == 0) {
            sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        new Thread(new Runnable(){
            private int count = 0;

            @Override
            public void run() {
                try {
                    while (isProcessing) {
                        if (this.count == 100) {
                            Kingdoms.logDebug((String)"k show requested but was pending for 10secs.");
                            isProcessing = false;
                            return;
                        }
                        ++this.count;
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                isProcessing = true;
                if (args.size() == 0) {
                    return;
                }
                String kingdomName = (String)args.poll();
                Kingdoms.logDebug((String)("kingdomName=" + kingdomName));
                Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(kingdomName);
                if (kingdom == null) {
                    OfflinePlayer op = Bukkit.getOfflinePlayer((String)kingdomName);
                    if (op == null) {
                        sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Non_Existant));
                        isProcessing = false;
                        return;
                    }
                    OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op.getUniqueId());
                    if (okp == null) {
                        sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Non_Existant));
                        isProcessing = false;
                        return;
                    }
                    if (okp.getKingdomName() != null) {
                        kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(okp.getKingdomName());
                        KCommandShow.this.displayInfo((CommandSender)sender, kingdom);
                        isProcessing = false;
                        return;
                    }
                    sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Player_No_Kingdom));
                    isProcessing = false;
                    return;
                }
                KCommandShow.this.displayInfo((CommandSender)sender, kingdom);
                isProcessing = false;
                isProcessing = false;
            }
        }).start();
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, final Queue<String> args) {
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (args.size() == 0 && kp.getKingdom() == null) {
            kp.getPlayer().sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        new Thread(new Runnable(){
            private int count = 0;

            @Override
            public void run() {
                try {
                    while (isProcessing) {
                        if (this.count == 100) {
                            Kingdoms.logDebug((String)"k show requested but was pending for 10secs.");
                            isProcessing = false;
                            return;
                        }
                        ++this.count;
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                isProcessing = true;
                if (args.size() == 0 && kp.getKingdom() != null) {
                    KCommandShow.this.displayInfo((CommandSender)kp.getPlayer(), kp.getKingdom());
                    isProcessing = false;
                    return;
                }
                String kingdomName = (String)args.poll();
                Kingdoms.logDebug((String)("kingdomName=" + kingdomName));
                Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(kingdomName);
                if (kingdom == null) {
                    OfflinePlayer op = Bukkit.getOfflinePlayer((String)kingdomName);
                    if (op == null) {
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Non_Existant));
                        isProcessing = false;
                        return;
                    }
                    OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
                    if (okp == null) {
                        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Non_Existant));
                        isProcessing = false;
                        return;
                    }
                    if (okp.getKingdomName() != null) {
                        kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(okp.getKingdomName());
                        KCommandShow.this.displayInfo((CommandSender)kp.getPlayer(), kingdom);
                        isProcessing = false;
                        return;
                    }
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Player_No_Kingdom));
                    isProcessing = false;
                    return;
                }
                KCommandShow.this.displayInfo((CommandSender)kp.getPlayer(), kingdom);
                isProcessing = false;
                isProcessing = false;
            }
        }).start();
    }

    private void displayInfo(CommandSender sender, Kingdom kingdom) {
        if (sender == null) {
            return;
        }
        String king = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_King);
        String members = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Members);
        String allies = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Allies);
        String land = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Land);
        String maxLandClaims = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_MaxLandClaims);
        String enemies = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Enemies);
        String rp = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_ResourcePoints);
        String might = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Might);
        String home = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Home);
        String nexus = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Nexus);
        String extra = "";
        if (kingdom.getExtraLandClaims() > 0) {
            extra = ChatColor.GREEN + " + (" + kingdom.getExtraLandClaims() + ")";
        } else if (kingdom.getExtraLandClaims() < 0) {
            extra = ChatColor.RED + " - (" + kingdom.getExtraLandClaims() * -1 + ")";
        }
        sender.sendMessage(ChatColor.GRAY + "==== " + ChatColor.LIGHT_PURPLE + kingdom.getKingdomName() + ChatColor.GRAY + " ====");
        if (kingdom.isShieldUp()) {
            sender.sendMessage(ChatColor.GREEN + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Show_Shield) + ": " + kingdom.getShieldTimeLeft() + "min");
        }
        sender.sendMessage(ChatColor.AQUA + "| " + king + ": " + ChatColor.YELLOW + Bukkit.getOfflinePlayer((UUID)kingdom.getKing()).getName());
        sender.sendMessage(ChatColor.AQUA + "| " + land + ": " + ChatColor.YELLOW + kingdom.getLand());
        sender.sendMessage(ChatColor.AQUA + "| " + maxLandClaims + ": " + ChatColor.YELLOW + kingdom.getMembersList().size() * Kingdoms.config.land_per_member + extra);
        sender.sendMessage(ChatColor.AQUA + "| " + might + ": " + ChatColor.YELLOW + kingdom.getMight());
        sender.sendMessage(ChatColor.AQUA + "| " + rp + ": " + ChatColor.YELLOW + kingdom.getResourcepoints());
        if (sender.hasPermission("kingdoms.admin.toggle")) {
            Kingdom k = GameManagement.getKingdomManager().getOrLoadKingdom(kingdom.getKingdomName());
            sender.sendMessage(ChatColor.AQUA + "| " + home + ": " + ChatColor.YELLOW + SimpleLocation.locToStr(k.getHome_loc()));
            sender.sendMessage(ChatColor.AQUA + "| " + nexus + ": " + ChatColor.YELLOW + SimpleLocation.locToStr(k.getNexus_loc()));
        }
        sender.sendMessage(ChatColor.AQUA + "| " + members + ": ");
        ArrayList<String> sentNames = new ArrayList<String>();
        for (UUID uuid : kingdom.getMembersList()) {
            OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(uuid);
            if (okp == null) {
                Kingdoms.logDebug((String)"okp was null (k show)");
                continue;
            }
            if (sentNames.contains(okp.getName())) continue;
            sentNames.add(okp.getName());
            String rank = okp.getRank().getColor() + okp.getRank().getFancyMark();
            ChatColor status = ChatColor.RED;
            if (okp.isOnline()) {
                status = ChatColor.GREEN;
            }
            sender.sendMessage(ChatColor.AQUA + "| " + status + ChatColor.GRAY + "[" + rank + ChatColor.GRAY + "]" + status + okp.getName());
        }
        sender.sendMessage(ChatColor.AQUA + "| " + allies + ":");
        for (String ally : kingdom.getAlliesList()) {
            sender.sendMessage(ChatColor.AQUA + "| " + ChatColor.GREEN + ally);
        }
        sender.sendMessage(ChatColor.AQUA + "| " + enemies + ":");
        for (String enemy : kingdom.getEnemiesList()) {
            sender.sendMessage(ChatColor.AQUA + "| " + ChatColor.RED + enemy);
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Show);
    }
}

