/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomMemberLeaveEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandLeave
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.leave");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        if (kp.getRank() == Rank.KING) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Leave_King_Error));
            return;
        }
        kp.getKingdom().sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Leave_Broadcast).replaceAll("%player%", kp.getPlayer().getName()), true);
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Leave_Success).replaceAll("%kingdom%", kp.getKingdom().getKingdomName()));
        kp.setKingdom(null);
        kp.setRank(Rank.ALL);
        Bukkit.getPluginManager().callEvent((Event)new KingdomMemberLeaveEvent(kp, kp.getKingdomName()));
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Leave);
    }
}

