/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandHome
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.home");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        final KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getKingdom() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.getHome_loc() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Home_No_Home_Error));
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getUseKHome())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getUseKHome().toString()));
            return;
        }
        final Location home = kingdom.getHome_loc();
        if (Kingdoms.config.kingdomHomeCannotBeUnclaimed) {
            Kingdoms.getManagers();
            if (GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(home.getChunk())).getOwner() == null) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Home_Not_Own_Land));
                return;
            }
            Kingdoms.getManagers();
            if (!GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(home.getChunk())).getOwner().equals(kingdom.getKingdomName())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Home_Not_Own_Land));
                return;
            }
        }
        final List<UUID> iswarping = GameManagement.getTpManager().iswarping;
        iswarping.add(kp.getUuid());
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Home_Wait));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Kingdoms.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (iswarping.contains(kp.getUuid())) {
                    kp.getPlayer().teleport(home, PlayerTeleportEvent.TeleportCause.COMMAND);
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Home_Success));
                    iswarping.remove(kp.getUuid());
                }
            }
        }, (long)(Kingdoms.config.KHOMEDELAY * 20));
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Home);
    }
}

