/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;

public class KCommandDeposit
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String[] getUsage() {
        return new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Usage_Deposit)};
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.deposit");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        Kingdoms.logDebug((String)("" + Kingdoms.config.economyEnabled));
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Player p = kp.getPlayer();
        Kingdoms plugin = Kingdoms.getInstance();
        if (ExternalManager.getVaultManager() != null) {
            double amt = 0.0;
            try {
                amt = Double.parseDouble(args.poll());
            }
            catch (NumberFormatException e) {
                kp.sendMessage(ChatColor.RED + "Usage: /k deposit [amount]");
            }
            if (kp.getKingdom() != null) {
                if (ExternalManager.getBalance((OfflinePlayer)p) >= amt) {
                    this.tradeMoneyForRp(kp, amt);
                } else {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Economy_Insufficient_Money));
                }
            } else {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            }
        } else {
            p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Enonomy_Not_Enabled));
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Deposit);
    }

    public void tradeMoneyForRp(KingdomPlayer kp, double amount) {
        Player p = kp.getPlayer();
        Kingdoms plugin = Kingdoms.getInstance();
        if (amount >= (double)Kingdoms.config.economy_money_for_one_rp) {
            int rp = (int)(amount / (double)Kingdoms.config.economy_money_for_one_rp);
            double leftover = amount - (double)(rp * Kingdoms.config.economy_money_for_one_rp);
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Economy_Trade_Successful).replaceAll("%traded%", "" + rp).replaceAll("%amount%", "" + (amount - leftover)));
            ExternalManager.withdrawPlayer((OfflinePlayer)p, amount - leftover);
            if (leftover > 0.0) {
                p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Economy_Trade_Leftover_Return).replaceAll("%leftover%", "" + leftover));
                ExternalManager.depositPlayer((OfflinePlayer)p, leftover);
            }
            kp.getKingdom().setResourcepoints(kp.getKingdom().getResourcepoints() + rp);
        } else {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Economy_Amount_Insufficient_For_Trade));
        }
    }
}

