/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;

public class KCommandClaimLand
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String[] getUsage() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Usage_Claim).split(" | ");
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.claim");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (!Kingdoms.config.worlds.contains(user.getWorld().getName())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Invalid_World));
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getClaim())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getClaim().toString()));
            return;
        }
        if (ExternalManager.isInRegion(kp.getPlayer().getLocation())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Worldguard_Claim_Off_Limits));
            return;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(kp.getLoc());
        String owner = land.getOwner();
        if (owner != null) {
            if (owner.equals(kingdom.getKingdomName())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Claim_Land_Owned_Error));
                return;
            }
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Claim_Land_Occupied_Error).replaceAll("%kingdom%", owner));
            kp.sendMessage("You may conquer this land by invading. (/k invade)");
            return;
        }
        if (kingdom.getLand() >= Kingdoms.config.land_per_member * kingdom.getMembersList().size() + kingdom.getExtraLandClaims()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Members_Needed).replaceAll("%amount%", String.valueOf(Kingdoms.config.land_per_member * kingdom.getMembersList().size())).replaceAll("%members%", String.valueOf(kingdom.getMembersList().size())));
            return;
        }
        if (Kingdoms.config.maximum_land_claims > 0 && kingdom.getLand() >= Kingdoms.config.maximum_land_claims) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Max_Land_Reached));
            return;
        }
        if (kingdom.getLand() <= 0) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Claim_FirstTime1).replaceAll("%kingdom%", kingdom.getKingdomName()));
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Claim_FirstTime2));
        } else {
            if (Kingdoms.config.landMustBeConnected) {
                boolean conn = false;
                Chunk main = kp.getPlayer().getLocation().getChunk();
                World w = kp.getPlayer().getWorld();
                int x = -1;
                while (x <= 1) {
                    int z = -1;
                    while (z <= 1) {
                        if (x != 0 || z != 0) {
                            Chunk c = w.getChunkAt(main.getX() + x, main.getZ() + z);
                            Kingdoms.getManagers();
                            Land adj = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(c));
                            if (adj.getOwner() != null && adj.getOwner().equals(kingdom.getKingdomName())) {
                                conn = true;
                                break;
                            }
                        }
                        ++z;
                    }
                    ++x;
                }
                if (!conn) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Must_Be_Connected));
                    return;
                }
            }
            int cost = Kingdoms.config.claimcost;
            if (!kp.isAdminMode() && kingdom.getResourcepoints() < cost) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                return;
            }
            if (!kp.isAdminMode()) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - Kingdoms.config.claimcost);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Claim_Success).replaceAll("%cost%", "" + Kingdoms.config.claimcost));
            } else {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Claim_Op));
            }
        }
        GameManagement.getLandManager().claimLand(kp.getLoc(), kingdom);
        GameManagement.getVisualManager().visualizeLand(kp, land.getLoc());
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Claim);
    }
}

