/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminMassWar
extends KCommandBase {
    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.masswar");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        String strtime = args.poll();
        if (!GameManagement.getMasswarManager().isMassWarOn()) {
            try {
                int time = Integer.parseInt(strtime) * 60;
                GameManagement.getMasswarManager().startMassWar(time);
                sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Masswar_Success).replaceAll("%time%", "" + time / 60));
            }
            catch (NumberFormatException e) {
                sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Masswar_Not_Number));
            }
        }
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        String strtime = args.poll();
        if (!GameManagement.getMasswarManager().isMassWarOn()) {
            try {
                int time = Integer.parseInt(strtime) * 60;
                GameManagement.getMasswarManager().startMassWar(time);
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Masswar_Success).replaceAll("%time%", "" + time / 60));
            }
            catch (NumberFormatException e) {
                user.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Masswar_Not_Number));
            }
        }
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Admin_MassWar);
    }
}

