/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.uCarsAPI.CarRespawnReason;
import com.useful.uCarsAPI.uCarCrashEvent;
import com.useful.uCarsAPI.uCarRespawnEvent;
import com.useful.ucars.CarHealthData;
import com.useful.ucars.ClosestFace;
import com.useful.ucars.ControlInput;
import com.useful.ucars.ItemStackFromId;
import com.useful.ucars.Lang;
import com.useful.ucars.PlaceManager;
import com.useful.ucars.controls.ControlSchemeManager;
import com.useful.ucars.ucarDeathEvent;
import com.useful.ucars.ucarUpdateEvent;
import com.useful.ucars.ucars;
import com.useful.ucarsCommon.StatValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class uCarsListener
implements Listener {
    private ucars plugin;
    private List<String> ignoreJump = null;
    private Boolean carsEnabled = true;
    private Boolean licenseEnabled = false;
    private Boolean roadBlocksEnabled = false;
    private Boolean trafficLightsEnabled = true;
    private Boolean effectBlocksEnabled = true;
    private Boolean usePerms = false;
    private Boolean fuelEnabled = false;
    private Boolean fuelUseItems = false;
    private double defaultSpeed = 30.0;
    private double defaultHealth = 10.0;
    private double damage_water = 0.0;
    private double damage_lava = 10.0;
    private double damage_cactus = 5.0;
    private double uCar_jump_amount = 20.0;
    private double crash_damage = 0.0;
    private double hitby_crash_damage = 0.0;
    private String fuelBypassPerm = "ufuel.bypass";
    private List<String> roadBlocks = new ArrayList<String>();
    private List<String> trafficLightRawIds = new ArrayList<String>();
    private List<String> blockBoost = new ArrayList<String>();
    private List<String> highBlockBoost = new ArrayList<String>();
    private List<String> resetBlockBoost = new ArrayList<String>();
    private List<String> jumpBlock = new ArrayList<String>();
    private List<String> teleportBlock = new ArrayList<String>();
    private List<String> barriers = new ArrayList<String>();
    private ConcurrentHashMap<String, Double> speedMods = new ConcurrentHashMap();

    public uCarsListener(ucars plugin) {
        this.plugin = ucars.plugin;
        this.ignoreJump = new ArrayList<String>();
        this.ignoreJump.add("AIR");
        this.ignoreJump.add("LAVA");
        this.ignoreJump.add("STATIONARY_LAVA");
        this.ignoreJump.add("WATER");
        this.ignoreJump.add("STATIONARY_WATER");
        this.ignoreJump.add("COBBLE_WALL");
        this.ignoreJump.add("FENCE");
        this.ignoreJump.add("NETHER_FENCE");
        this.ignoreJump.add("STONE_PLATE");
        this.ignoreJump.add("WOOD_PLATE");
        this.ignoreJump.add("TRIPWIRE");
        this.ignoreJump.add("TRIPWIRE_HOOK");
        this.ignoreJump.add("TORCH");
        this.ignoreJump.add("REDSTONE_TORCH_ON");
        this.ignoreJump.add("REDSTONE_TORCH_OFF");
        this.ignoreJump.add("DIODE_BLOCK_OFF");
        this.ignoreJump.add("DIODE_BLOCK_ON");
        this.ignoreJump.add("REDSTONE_COMPARATOR_OFF");
        this.ignoreJump.add("REDSTONE_COMPARATOR_ON");
        this.ignoreJump.add("VINE");
        this.ignoreJump.add("LONG_GRASS");
        this.ignoreJump.add("STONE_BUTTON");
        this.ignoreJump.add("WOOD_BUTTON");
        this.ignoreJump.add("FENCE_GATE");
        this.ignoreJump.add("LEVER");
        this.ignoreJump.add("SNOW");
        this.ignoreJump.add("DAYLIGHT_DETECTOR");
        this.ignoreJump.add("SIGN_POST");
        this.ignoreJump.add("WALL_SIGN");
        this.usePerms = ucars.config.getBoolean("general.permissions.enable");
        this.carsEnabled = ucars.config.getBoolean("general.cars.enable");
        this.defaultHealth = ucars.config.getDouble("general.cars.health.default");
        this.damage_water = ucars.config.getDouble("general.cars.health.underwaterDamage");
        this.damage_lava = ucars.config.getDouble("general.cars.health.lavaDamage");
        this.damage_cactus = ucars.config.getDouble("general.cars.health.cactusDamage");
        this.defaultSpeed = ucars.config.getDouble("general.cars.defSpeed");
        this.fuelBypassPerm = ucars.config.getString("general.cars.fuel.bypassPerm");
        this.uCar_jump_amount = ucars.config.getDouble("general.cars.jumpAmount");
        this.crash_damage = ucars.config.getDouble("general.cars.health.crashDamage");
        this.hitby_crash_damage = ucars.config.getDouble("general.cars.hitBy.damage");
        this.licenseEnabled = ucars.config.getBoolean("general.cars.licenses.enable");
        this.roadBlocksEnabled = ucars.config.getBoolean("general.cars.roadBlocks.enable");
        this.trafficLightsEnabled = ucars.config.getBoolean("general.cars.trafficLights.enable");
        this.effectBlocksEnabled = ucars.config.getBoolean("general.cars.effectBlocks.enable");
        this.fuelEnabled = ucars.config.getBoolean("general.cars.fuel.enable");
        this.fuelUseItems = ucars.config.getBoolean("general.cars.fuel.items.enable");
        if (this.roadBlocksEnabled.booleanValue()) {
            List ids = ucars.config.getStringList("general.cars.roadBlocks.ids");
            ids.addAll(ucars.config.getStringList("general.cars.blockBoost"));
            ids.addAll(ucars.config.getStringList("general.cars.HighblockBoost"));
            ids.addAll(ucars.config.getStringList("general.cars.ResetblockBoost"));
            ids.addAll(ucars.config.getStringList("general.cars.jumpBlock"));
            ids.add("AIR");
            ids.add("LAVA");
            ids.add("STATIONARY_LAVA");
            ids.add("WATER");
            ids.add("STATIONARY_WATER");
            this.roadBlocks = ids;
        }
        if (this.trafficLightsEnabled.booleanValue()) {
            this.trafficLightRawIds = ucars.config.getStringList("general.cars.trafficLights.waitingBlock");
        }
        if (this.effectBlocksEnabled.booleanValue()) {
            this.blockBoost = ucars.config.getStringList("general.cars.blockBoost");
            this.highBlockBoost = ucars.config.getStringList("general.cars.HighblockBoost");
            this.resetBlockBoost = ucars.config.getStringList("general.cars.ResetblockBoost");
            this.jumpBlock = ucars.config.getStringList("general.cars.jumpBlock");
            this.teleportBlock = ucars.config.getStringList("general.cars.teleportBlock");
        }
        this.barriers = ucars.config.getStringList("general.cars.barriers");
        List units = ucars.config.getStringList("general.cars.speedMods");
        for (String unit : units) {
            String[] sections = unit.split("-");
            try {
                String rawMat = sections[0];
                double mult = Double.parseDouble(sections[1]);
                this.speedMods.put(rawMat, mult);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Vector calculateCarStats(Minecart car, Player player, Vector velocity, double currentMult) {
        if (car.hasMetadata("car.frozen")) {
            velocity = new Vector(0, 0, 0);
            return velocity;
        }
        velocity = this.plugin.getAPI().getTravelVector(car, velocity, currentMult);
        return velocity;
    }

    public boolean trafficlightSignOn(Block block) {
        Sign sign;
        return block.getRelative(BlockFace.NORTH).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.NORTH).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.EAST).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.EAST).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.SOUTH).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.SOUTH).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.WEST).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.WEST).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.DOWN).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.DOWN).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : block.getRelative(BlockFace.UP).getState() instanceof Sign && ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.UP).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]"))))));
    }

    public boolean inACar(String playername) {
        try {
            Player p = this.plugin.getServer().getPlayer(playername);
            return this.inACar(p);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isACar(Minecart cart) {
        if (cart.hasMetadata("ucars.ignore")) {
            return false;
        }
        Location loc = cart.getLocation();
        Block b = loc.getBlock();
        String mat = b.getType().name().toUpperCase();
        String underMat = b.getRelative(BlockFace.DOWN).getType().name().toUpperCase();
        String underUnderMat = b.getRelative(BlockFace.DOWN, 2).getType().name().toUpperCase();
        ArrayList<String> checks = new ArrayList<String>();
        checks.add("POWERED_RAIL");
        checks.add("RAILS");
        checks.add("DETECTOR_RAIL");
        checks.add("ACTIVATOR_RAIL");
        if (checks.contains(mat) || checks.contains(underMat) || checks.contains(underUnderMat)) {
            return false;
        }
        return this.plugin.getAPI().runCarChecks(cart) != false;
    }

    public void ResetCarBoost(String playername, Minecart car, double defaultSpeed) {
        String p = playername;
        World w = this.plugin.getServer().getPlayer(p).getLocation().getWorld();
        w.playSound(this.plugin.getServer().getPlayer(p).getLocation(), Sound.BAT_TAKEOFF, 1.5f, -2.0f);
        if (ucars.carBoosts.containsKey(p)) {
            ucars.carBoosts.remove(p);
        }
    }

    public boolean carBoost(String playerName, final double power, final long lengthMillis, double defaultSpeed) {
        double defMult;
        final String p = playerName;
        double Cur = defMult = defaultSpeed;
        if (ucars.carBoosts.containsKey(p)) {
            Cur = ucars.carBoosts.get(p);
        }
        if (Cur > defMult) {
            return false;
        }
        final double current = Cur;
        if (this.plugin == null) {
            this.plugin.getLogger().log(Level.SEVERE, Lang.get("lang.error.pluginNull"));
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                World w = uCarsListener.this.plugin.getServer().getPlayer(p).getLocation().getWorld();
                w.playSound(uCarsListener.this.plugin.getServer().getPlayer(p).getLocation(), Sound.FIZZ, 1.5f, -2.0f);
                double speed = current + power;
                ucars.carBoosts.put(p, speed);
                try {
                    Thread.sleep(lengthMillis);
                }
                catch (InterruptedException e) {
                    ucars.carBoosts.remove(p);
                    return;
                }
                ucars.carBoosts.remove(p);
            }
        });
        return true;
    }

    public boolean inACar(Player p) {
        Entity ent;
        block8: {
            block7: {
                block6: {
                    if (p != null) break block6;
                    return false;
                }
                if (p.getVehicle() != null) break block7;
                return false;
            }
            try {
                ent = p.getVehicle();
                if (ent instanceof Minecart) break block8;
                while (!(ent instanceof Minecart) && ent.getVehicle() != null) {
                    ent = ent.getVehicle();
                }
                if (ent instanceof Minecart) break block8;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Minecart cart = (Minecart)ent;
        return this.isACar(cart);
    }

    public Entity getDrivingPassengerOfCar(Vehicle vehicle) {
        Entity passenger = vehicle.getPassenger();
        if (passenger == null || !(vehicle instanceof Minecart)) {
            return null;
        }
        if (!(passenger instanceof Player)) {
            while (!(passenger instanceof Player) && passenger.getPassenger() != null) {
                passenger = passenger.getPassenger();
            }
        }
        return passenger;
    }

    @EventHandler
    public void signWriter(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (ChatColor.stripColor((String)lines[1]).equalsIgnoreCase("[TrafficLight]")) {
            lines[1] = "[TrafficLight]";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[uFuel]")) {
            lines[0] = "[uFuel]";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[Teleport]")) {
            lines[0] = "[Teleport]";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[wir]") && !event.getPlayer().hasPermission("wirelessredstone")) {
            event.getPlayer().sendMessage(ChatColor.RED + "Sorry you need the permisson 'wirelessredstone' to do this!");
            lines[0] = "";
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerJoinControlsUnlock(PlayerJoinEvent event) {
        ControlSchemeManager.setControlsLocked(event.getPlayer(), false);
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp() && !this.plugin.protocolLib.booleanValue()) {
            event.getPlayer().sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.messages.noProtocolLib"));
        }
    }

    @EventHandler
    public void tickCalcsAndLegacy(VehicleUpdateEvent event) {
        ChatColor color;
        double left;
        double max;
        double damage;
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Entity passenger = this.getDrivingPassengerOfCar(vehicle);
        Boolean driven = passenger != null && passenger instanceof Player;
        if (!driven.booleanValue()) {
            return;
        }
        if (!(event instanceof ucarUpdateEvent) && vehicle.hasMetadata("car.vec")) {
            ucarUpdateEvent evt = (ucarUpdateEvent)((Object)((MetadataValue)vehicle.getMetadata("car.vec").get(0)).value());
            evt.player = (Player)passenger;
            evt.incrementRead();
            vehicle.removeMetadata("car.vec", (Plugin)ucars.plugin);
            ucarUpdateEvent et = new ucarUpdateEvent(vehicle, evt.getTravelVector().clone(), null);
            et.setRead(evt.getReadCount());
            vehicle.setMetadata("car.vec", (MetadataValue)new StatValue((Object)et, (Plugin)ucars.plugin));
            ucars.plugin.getServer().getPluginManager().callEvent((Event)evt);
        }
        Block normalblock = vehicle.getLocation().getBlock();
        Player player = null;
        if (driven.booleanValue()) {
            player = (Player)passenger;
        }
        if (!this.carsEnabled.booleanValue()) {
            return;
        }
        Minecart car = (Minecart)vehicle;
        if (!this.isACar(car)) {
            return;
        }
        Vector vel = car.getVelocity();
        if (car.getVelocity().getY() > 0.1 && !car.hasMetadata("car.falling") && !car.hasMetadata("car.ascending")) {
            if (car.hasMetadata("car.jumping")) {
                vel.setY(2.5);
                car.removeMetadata("car.jumping", (Plugin)this.plugin);
            } else if (car.hasMetadata("car.jumpFull")) {
                if (car.getVelocity().getY() > 10.0) {
                    vel.setY(5);
                }
                car.removeMetadata("car.jumpFull", (Plugin)this.plugin);
            } else {
                vel.setY(0);
            }
            car.setVelocity(vel);
        }
        if (car.hasMetadata("car.jumpUp")) {
            double amt = (Double)((MetadataValue)car.getMetadata("car.jumpUp").get(0)).value();
            car.removeMetadata("car.jumpUp", (Plugin)this.plugin);
            if (amt >= 1.5) {
                double y = amt * 0.1;
                car.setMetadata("car.jumpUp", (MetadataValue)new StatValue(amt - y, (Plugin)this.plugin));
                vel.setY(y);
                car.setVelocity(vel);
                return;
            }
            car.setMetadata("car.falling", (MetadataValue)new StatValue(0.01, (Plugin)this.plugin));
        }
        if (car.hasMetadata("car.falling")) {
            double gravity = (Double)((MetadataValue)car.getMetadata("car.falling").get(0)).value();
            double newGravity = gravity + gravity * 0.6;
            car.removeMetadata("car.falling", (Plugin)this.plugin);
            if (gravity <= 0.6) {
                car.setMetadata("car.falling", (MetadataValue)new StatValue(newGravity, (Plugin)ucars.plugin));
                vel.setY(-(gravity * 1.333 + 0.2));
                car.setVelocity(vel);
            }
        }
        CarHealthData health = this.getCarHealthHandler(car);
        Boolean recalculateHealth = false;
        if ((normalblock.getType().equals((Object)Material.WATER) || normalblock.getType().equals((Object)Material.STATIONARY_WATER)) && (damage = this.damage_water) > 0.0) {
            if (driven.booleanValue()) {
                max = this.defaultHealth;
                left = health.getHealth() - damage;
                color = ChatColor.YELLOW;
                if (left > max * 0.66) {
                    color = ChatColor.GREEN;
                }
                if (left < max * 0.33) {
                    color = ChatColor.RED;
                }
                player.sendMessage(ChatColor.RED + "-" + damage + "[" + Material.WATER.name().toLowerCase() + "]" + color + " (" + left + ")");
            }
            health.damage(damage);
            recalculateHealth = true;
        }
        if ((normalblock.getType().equals((Object)Material.LAVA) || normalblock.getType().equals((Object)Material.STATIONARY_LAVA)) && (damage = this.damage_lava) > 0.0) {
            if (driven.booleanValue()) {
                max = this.defaultHealth;
                left = health.getHealth() - damage;
                color = ChatColor.YELLOW;
                if (left > max * 0.66) {
                    color = ChatColor.GREEN;
                }
                if (left < max * 0.33) {
                    color = ChatColor.RED;
                }
                player.sendMessage(ChatColor.RED + "-" + damage + "[" + Material.LAVA.name().toLowerCase() + "]" + color + " (" + left + ")");
            }
            health.damage(damage);
            recalculateHealth = true;
        }
        if (recalculateHealth.booleanValue()) {
            this.updateCarHealthHandler(car, health);
        }
        if (this.plugin.protocolLib.booleanValue()) {
            return;
        }
        Vector playerVelocity = car.getPassenger().getVelocity();
        ucarUpdateEvent ucarupdate = new ucarUpdateEvent((Vehicle)car, playerVelocity, player);
        this.plugin.getServer().getPluginManager().callEvent((Event)ucarupdate);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onUcarUpdate(ucarUpdateEvent event) {
        double fuel;
        double damage;
        double fz;
        if (event.isCancelled()) {
            return;
        }
        Boolean modY = true;
        Vehicle vehicle = event.getVehicle();
        if (event.getReadCount() > 2) {
            vehicle.removeMetadata("car.vec", (Plugin)ucars.plugin);
        }
        Location under = vehicle.getLocation();
        under.setY(vehicle.getLocation().getY() - 1.0);
        Block underblock = under.getBlock();
        Block underunderblock = underblock.getRelative(BlockFace.DOWN);
        Block normalblock = vehicle.getLocation().getBlock();
        final Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        if (!this.carsEnabled.booleanValue()) {
            return;
        }
        try {
            if (this.licenseEnabled.booleanValue() && !this.plugin.licensedPlayers.contains(player.getName()).booleanValue()) {
                player.sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.licenses.noLicense"));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Minecart car = (Minecart)vehicle;
        if (!this.isACar(car)) {
            return;
        }
        if (!player.isInsideVehicle()) {
            return;
        }
        CarHealthData health = this.getCarHealthHandler(car);
        Boolean recalculateHealth = false;
        if (car.getVelocity().getY() > 0.01 && !car.hasMetadata("car.falling") && !car.hasMetadata("car.ascending")) {
            modY = false;
        }
        if (car.hasMetadata("car.jumping")) {
            if (!car.hasMetadata("car.ascending")) {
                modY = false;
            }
            car.removeMetadata("car.jumping", (Plugin)this.plugin);
        }
        car.setMaxSpeed(5.0);
        if (this.roadBlocksEnabled.booleanValue() && !this.plugin.isBlockEqualToConfigIds(this.roadBlocks, underblock).booleanValue()) {
            return;
        }
        Location loc = car.getLocation();
        if (!ucars.playersIgnoreTrafficLights && this.atTrafficLight(car, underblock, underunderblock, loc).booleanValue()) {
            return;
        }
        if (this.effectBlocksEnabled.booleanValue()) {
            if (this.plugin.isBlockEqualToConfigIds(this.blockBoost, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.blockBoost, underunderblock).booleanValue()) {
                this.carBoost(player.getName(), 20.0, 6000L, this.defaultSpeed);
            }
            if (this.plugin.isBlockEqualToConfigIds(this.highBlockBoost, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.highBlockBoost, underunderblock).booleanValue()) {
                this.carBoost(player.getName(), 50.0, 8000L, this.defaultSpeed);
            }
            if (this.plugin.isBlockEqualToConfigIds(this.resetBlockBoost, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.resetBlockBoost, underunderblock).booleanValue()) {
                this.ResetCarBoost(player.getName(), car, this.defaultSpeed);
            }
        }
        Vector travel = event.getTravelVector();
        if (ucars.smoothDrive) {
            float a = ControlInput.getAccel(event.getPlayer());
            travel.setX(travel.getX() * (double)a);
            travel.setZ(travel.getZ() * (double)a);
        }
        double multiplier = this.defaultSpeed;
        try {
            if (ucars.carBoosts.containsKey(player.getName())) {
                multiplier = ucars.carBoosts.get(player.getName());
            }
        }
        catch (Exception e1) {
            return;
        }
        String underMat = under.getBlock().getType().name().toUpperCase();
        byte underdata = under.getBlock().getData();
        String key = String.valueOf(underMat) + ":" + underdata;
        if (this.speedMods.containsKey(key)) {
            multiplier = !ucars.carBoosts.containsKey(player.getName()) ? this.speedMods.get(key) : (this.speedMods.get(key) + multiplier) * 0.5;
        }
        if (event.getDoDivider().booleanValue()) {
            multiplier *= event.getDivider();
        }
        travel = travel.multiply(multiplier);
        if (this.usePerms.booleanValue() && !player.hasPermission("ucars.cars")) {
            player.sendMessage(String.valueOf(ucars.colors.getInfo()) + Lang.get("lang.messages.noDrivePerm"));
            return;
        }
        if (normalblock.getType() != Material.AIR && normalblock.getType() != Material.WATER && normalblock.getType() != Material.STATIONARY_WATER && normalblock.getType() != Material.STEP && normalblock.getType() != Material.DOUBLE_STEP && normalblock.getType() != Material.LONG_GRASS && !normalblock.getType().name().toLowerCase().contains("stairs")) {
            car.setVelocity(new Vector(0.0, 1.1, 0.0));
        }
        Location before = car.getLocation();
        float dir = player.getLocation().getYaw();
        BlockFace faceDir = ClosestFace.getClosestFace(dir);
        double fx = travel.getX();
        if (Math.abs(fx) > 1.0) {
            fx = faceDir.getModX();
        }
        if (Math.abs(fz = travel.getZ()) > 1.0) {
            fz = faceDir.getModZ();
        }
        before.add(new Vector(fx, (double)faceDir.getModY(), fz));
        Block block = before.getBlock();
        if (block.getType().equals((Object)Material.CACTUS) && (damage = this.damage_cactus) > 0.0) {
            double max = this.defaultHealth;
            double left = health.getHealth() - damage;
            ChatColor color = ChatColor.YELLOW;
            if (left > max * 0.66) {
                color = ChatColor.GREEN;
            }
            if (left < max * 0.33) {
                color = ChatColor.RED;
            }
            player.sendMessage(ChatColor.RED + "-" + damage + "[" + Material.CACTUS.name().toLowerCase() + "]" + color + " (" + left + ")");
            health.damage(damage);
            recalculateHealth = true;
        }
        if (this.fuelEnabled.booleanValue() && !this.fuelUseItems.booleanValue() && !player.hasPermission(this.fuelBypassPerm)) {
            fuel = 0.0;
            if (ucars.fuel.containsKey(player.getName())) {
                fuel = ucars.fuel.get(player.getName());
            }
            if (fuel < 0.1) {
                player.sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.fuel.empty"));
                return;
            }
            int amount = 0 + (int)(Math.random() * 250.0);
            if (amount == 10) {
                fuel -= 0.1;
                fuel = (double)Math.round(fuel * 10.0) / 10.0;
                ucars.fuel.put(player.getName(), fuel);
            }
        } else if (this.fuelEnabled.booleanValue() && this.fuelUseItems.booleanValue() && !player.hasPermission(this.fuelBypassPerm)) {
            fuel = 0.0;
            ArrayList<ItemStack> items = this.plugin.ufuelitems;
            PlayerInventory inv = player.getInventory();
            for (ItemStack item : items) {
                if (!inv.contains(item.getType(), 1)) continue;
                fuel += 0.1;
            }
            if (fuel < 0.1) {
                player.sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.fuel.empty"));
                return;
            }
            int amount = 0 + (int)(Math.random() * 150.0);
            if (amount == 10) {
                Boolean taken = false;
                Boolean last = false;
                int toUse = 0;
                int i = 0;
                while (i < inv.getContents().length) {
                    ItemStack item = inv.getItem(i);
                    Boolean ignore = false;
                    try {
                        item.getType();
                    }
                    catch (Exception e) {
                        ignore = true;
                    }
                    if (!ignore.booleanValue() && !taken.booleanValue() && this.plugin.isItemOnList(items, item).booleanValue()) {
                        taken = true;
                        if (item.getAmount() < 2) {
                            last = true;
                            toUse = i;
                        }
                        item.setAmount(item.getAmount() - 1);
                    }
                    ++i;
                }
                if (last.booleanValue()) {
                    inv.setItem(toUse, new ItemStack(Material.AIR));
                }
            }
        }
        if (travel.getY() < 0.0) {
            double newy = travel.getY() + 2.0;
            travel.setY(newy);
        }
        Material bType = block.getType();
        byte bData = block.getData();
        Boolean fly = false;
        if (normalblock.getRelative(faceDir).getType() == Material.STEP) {
            fly = true;
        }
        if (this.effectBlocksEnabled.booleanValue()) {
            if (this.plugin.isBlockEqualToConfigIds(this.jumpBlock, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.jumpBlock, underunderblock).booleanValue()) {
                double y = this.uCar_jump_amount;
                car.setMetadata("car.jumpUp", (MetadataValue)new StatValue(this.uCar_jump_amount, (Plugin)this.plugin));
                travel.setY(y);
                car.setVelocity(travel);
            }
            if (this.plugin.isBlockEqualToConfigIds(this.teleportBlock, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.teleportBlock, underunderblock).booleanValue()) {
                String[] lines;
                Sign s = null;
                if (underunderblock.getState() instanceof Sign) {
                    s = (Sign)underunderblock.getState();
                }
                if (underunderblock.getRelative(BlockFace.DOWN).getState() instanceof Sign) {
                    s = (Sign)underunderblock.getRelative(BlockFace.DOWN).getState();
                }
                if (s != null && (lines = s.getLines())[0].equalsIgnoreCase("[Teleport]")) {
                    Boolean raceCar = false;
                    if (car.hasMetadata("kart.racing")) {
                        raceCar = true;
                    }
                    car.setMetadata("safeExit.ignore", (MetadataValue)new StatValue(null, (Plugin)this.plugin));
                    car.eject();
                    UUID carId = car.getUniqueId();
                    car.remove();
                    final Minecart ca = car;
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            if (ca != null) {
                                ca.remove();
                            }
                        }
                    }, 2L);
                    String xs = lines[1];
                    String ys = lines[2];
                    String zs = lines[3];
                    Boolean valid = true;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    try {
                        x = Double.parseDouble(xs);
                        y = Double.parseDouble(ys);
                        y += 0.5;
                        z = Double.parseDouble(zs);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                    if (valid.booleanValue()) {
                        Location toTele;
                        Chunk ch;
                        List metas = null;
                        if (player.hasMetadata("car.stayIn")) {
                            metas = player.getMetadata("car.stayIn");
                            for (MetadataValue val : metas) {
                                player.removeMetadata("car.stayIn", val.getOwningPlugin());
                            }
                        }
                        if ((ch = (toTele = new Location(s.getWorld(), x, y, z)).getChunk()).isLoaded()) {
                            ch.load(true);
                        }
                        Minecart v = car = (Minecart)s.getWorld().spawnEntity(toTele, EntityType.MINECART);
                        car.setMetadata("carhealth", (MetadataValue)health);
                        if (raceCar.booleanValue()) {
                            car.setMetadata("kart.racing", (MetadataValue)new StatValue(null, (Plugin)this.plugin));
                        }
                        health.onDeath = this.defaultDeathHandler(car);
                        uCarRespawnEvent evnt = new uCarRespawnEvent(car, carId, car.getUniqueId(), CarRespawnReason.TELEPORT);
                        this.plugin.getServer().getPluginManager().callEvent((Event)evnt);
                        if (evnt.isCancelled()) {
                            car.remove();
                        } else {
                            player.sendMessage(String.valueOf(ucars.colors.getTp()) + "Teleporting...");
                            car.setPassenger((Entity)player);
                            final Minecart ucar = car;
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                                @Override
                                public void run() {
                                    ucar.setPassenger((Entity)player);
                                }
                            }, 2L);
                            car.setVelocity(travel);
                            if (metas != null) {
                                for (MetadataValue val : metas) {
                                    player.setMetadata("car.stayIn", val);
                                }
                            }
                            this.plugin.getAPI().updateUcarMeta(carId, car.getUniqueId());
                        }
                    }
                }
            }
        }
        Location theNewLoc = block.getLocation();
        Location bidUpLoc = block.getLocation().add(0.0, 1.0, 0.0);
        Material bidU = bidUpLoc.getBlock().getType();
        Boolean cont = true;
        cont = this.plugin.isBlockEqualToConfigIds(this.barriers, block) == false;
        Boolean inStairs = false;
        Material carBlock = car.getLocation().getBlock().getType();
        if (carBlock.name().toLowerCase().contains("stairs")) {
            inStairs = true;
        }
        if (car.hasMetadata("car.ascending")) {
            car.removeMetadata("car.ascending", (Plugin)this.plugin);
        }
        if (inStairs.booleanValue() || !this.ignoreJump.contains(bType.name().toUpperCase()) && cont.booleanValue() && modY.booleanValue()) {
            if (bidU == Material.AIR || bidU == Material.LAVA || bidU == Material.STATIONARY_LAVA || bidU == Material.WATER || bidU == Material.STATIONARY_WATER || bidU == Material.STEP || bidU == Material.CARPET || bidU == Material.DOUBLE_STEP || inStairs.booleanValue()) {
                theNewLoc.add(0.0, 1.5, 0.0);
                Boolean calculated = false;
                double y = 7.0;
                if (block.getType().name().toLowerCase().contains("step")) {
                    calculated = true;
                    y = 8.0;
                }
                if (carBlock.name().toLowerCase().contains("step")) {
                    calculated = true;
                    y = 8.0;
                }
                if (carBlock.name().toLowerCase().contains(Pattern.quote("stairs")) || block.getType().name().toLowerCase().contains(Pattern.quote("stairs")) || inStairs.booleanValue()) {
                    calculated = true;
                    y = 2.5;
                }
                Boolean ignore = false;
                if (car.getVelocity().getY() > 4.0) {
                    ignore = true;
                }
                if (!ignore.booleanValue()) {
                    travel.setY(y);
                    if (calculated.booleanValue()) {
                        car.setMetadata("car.jumping", (MetadataValue)new StatValue(null, (Plugin)this.plugin));
                    } else {
                        car.setMetadata("car.jumpFull", (MetadataValue)new StatValue(null, (Plugin)this.plugin));
                    }
                }
            }
            if (fly.booleanValue() && cont.booleanValue()) {
                travel.setY(0.8);
                car.setMetadata("car.ascending", (MetadataValue)new StatValue(null, (Plugin)this.plugin));
            }
            car.setVelocity(this.calculateCarStats(car, player, travel, multiplier));
        } else {
            if (fly.booleanValue()) {
                travel.setY(0.8);
                car.setMetadata("car.ascending", (MetadataValue)new StatValue(null, (Plugin)this.plugin));
            }
            car.setVelocity(this.calculateCarStats(car, player, travel, multiplier));
        }
        if (recalculateHealth.booleanValue()) {
            this.updateCarHealthHandler(car, health);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    void safeFly(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Player p = (Player)event.getEntity();
        if (this.inACar(p.getName())) {
            Vector vel = p.getVehicle().getVelocity();
            if (!(vel.getY() > -0.1) || !(vel.getY() < 0.1)) {
                event.setCancelled(true);
            } else {
                try {
                    p.damage(event.getDamage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @EventHandler
    void hitByCar(VehicleEntityCollisionEvent event) {
        double damage;
        double pDmg;
        Vehicle veh = event.getVehicle();
        if (!(veh instanceof Minecart)) {
            return;
        }
        Minecart cart = (Minecart)veh;
        if (!this.isACar(cart)) {
            return;
        }
        Entity ent = event.getEntity();
        if (cart.getPassenger() == null) {
            return;
        }
        Entity passenger = cart.getPassenger();
        while (passenger.getPassenger() != null) {
            passenger = passenger.getPassenger();
        }
        if (passenger.equals(ent)) {
            return;
        }
        if (ent.hasMetadata("hitByLast")) {
            try {
                long l = (Long)((MetadataValue)ent.getMetadata("hitByLast").get(0)).value();
                long pastTime = System.currentTimeMillis() - l;
                if (pastTime < 500L) {
                    return;
                }
                ent.removeMetadata("hitByLast", (Plugin)ucars.plugin);
            }
            catch (Exception e) {
                ent.removeMetadata("hitByLast", (Plugin)ucars.plugin);
            }
        }
        ent.removeMetadata("hitByLast", (Plugin)ucars.plugin);
        ent.setMetadata("hitByLast", (MetadataValue)new StatValue(System.currentTimeMillis(), (Plugin)ucars.plugin));
        double speed = cart.getVelocity().length() * 3.5;
        if (passenger instanceof Villager) {
            speed = cart.getVelocity().length() * 1.6;
        }
        if ((pDmg = (damage = this.hitby_crash_damage) * speed * 2.0) < 1.0) {
            pDmg = 1.0;
        }
        if (pDmg > this.hitby_crash_damage * 1.5) {
            pDmg = this.hitby_crash_damage * 1.5;
        }
        if (pDmg > 8.0) {
            pDmg = 8.0;
        }
        if (speed > 0.0) {
            CarHealthData health = this.getCarHealthHandler(cart);
            double dmg = this.crash_damage;
            if (dmg > 0.0) {
                if (cart.getPassenger() instanceof Player) {
                    double max = this.defaultHealth;
                    double left = health.getHealth() - dmg;
                    ChatColor color = ChatColor.YELLOW;
                    if (left > max * 0.66) {
                        color = ChatColor.GREEN;
                    }
                    if (left < max * 0.33) {
                        color = ChatColor.RED;
                    }
                    ((Player)cart.getPassenger()).sendMessage(ChatColor.RED + "-" + dmg + "[crash]" + color + " (" + left + ")");
                }
                health.damage(dmg);
            }
            this.updateCarHealthHandler(cart, health);
        }
        if (speed <= 0.0) {
            return;
        }
        if (!ucars.config.getBoolean("general.cars.hitBy.enable")) {
            return;
        }
        if (ucars.config.getBoolean("general.cars.hitBy.enableMonsterDamage") && (ent instanceof Monster || ucars.config.getBoolean("general.cars.hitBy.enableAllMonsterDamage") && ent instanceof Damageable)) {
            if (ent instanceof Villager && ent.getVehicle() != null && passenger instanceof Villager) {
                return;
            }
            uCarCrashEvent evt = new uCarCrashEvent(cart, ent, pDmg);
            if (evt.isCancelled()) {
                return;
            }
            pDmg = evt.getDamageToBeDoneToTheEntity();
            double mult = ucars.config.getDouble("general.cars.hitBy.power") / 7.0;
            ent.setVelocity(cart.getVelocity().setY(0.5).multiply(mult));
            ((Damageable)ent).damage(pDmg);
        }
        if (!(ent instanceof Player)) {
            return;
        }
        Player p = (Player)ent;
        if (this.inACar(p)) {
            return;
        }
        uCarCrashEvent evt = new uCarCrashEvent(cart, (Entity)p, pDmg);
        Bukkit.getPluginManager().callEvent((Event)evt);
        if (evt.isCancelled()) {
            return;
        }
        pDmg = evt.getDamageToBeDoneToTheEntity();
        double mult = ucars.config.getDouble("general.cars.hitBy.power") / 5.0;
        p.setVelocity(cart.getVelocity().setY(0.5).multiply(mult));
        p.sendMessage(String.valueOf(ucars.colors.getInfo()) + Lang.get("lang.messages.hitByCar"));
        p.damage(pDmg);
    }

    @EventHandler
    void interact(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (event.getPlayer().getItemInHand().getType() == Material.MINECART) {
            Material iar = block.getType();
            if (iar == Material.RAILS || iar == Material.ACTIVATOR_RAIL || iar == Material.POWERED_RAIL || iar == Material.DETECTOR_RAIL) {
                return;
            }
            if (!PlaceManager.placeableOn(iar.name().toUpperCase(), block.getData()).booleanValue()) {
                return;
            }
            if (!ucars.config.getBoolean("general.cars.enable")) {
                return;
            }
            if (ucars.config.getBoolean("general.cars.placePerm.enable")) {
                String perm = ucars.config.getString("general.cars.placePerm.perm");
                if (!event.getPlayer().hasPermission(perm)) {
                    String noPerm = Lang.get("lang.messages.noPlacePerm");
                    noPerm = noPerm.replaceAll("%perm%", perm);
                    event.getPlayer().sendMessage(String.valueOf(ucars.colors.getError()) + noPerm);
                    return;
                }
            }
            if (event.isCancelled()) {
                event.getPlayer().sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.messages.noPlaceHere"));
                return;
            }
            if (!this.plugin.API.runCarChecks(event.getPlayer().getItemInHand()).booleanValue()) {
                return;
            }
            Location loc = block.getLocation().add(0.0, 1.5, 0.0);
            loc.setYaw(event.getPlayer().getLocation().getYaw() + 270.0f);
            Minecart car = (Minecart)event.getPlayer().getWorld().spawnEntity(loc, EntityType.MINECART);
            this.updateCarHealthHandler(car, this.getCarHealthHandler(car));
            event.getPlayer().sendMessage(String.valueOf(ucars.colors.getInfo()) + Lang.get("lang.messages.place"));
            event.getPlayer().sendMessage(String.valueOf(ucars.colors.getInfo()) + "You can also use 'jump' to change driving mode!");
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                ItemStack placed = event.getPlayer().getItemInHand();
                placed.setAmount(placed.getAmount() - 1);
                event.getPlayer().getInventory().setItemInHand(placed);
            }
        }
        if (this.inACar(event.getPlayer()) && ucars.config.getBoolean("general.cars.fuel.enable") && this.plugin.isItemEqualToConfigIds(ucars.config.getStringList("general.cars.fuel.check"), event.getPlayer().getItemInHand()).booleanValue()) {
            event.getPlayer().performCommand("ufuel view");
        }
        List LowBoostRaw = ucars.config.getStringList("general.cars.lowBoost");
        List MedBoostRaw = ucars.config.getStringList("general.cars.medBoost");
        List HighBoostRaw = ucars.config.getStringList("general.cars.highBoost");
        ItemStack inHand = event.getPlayer().getItemInHand();
        String bid = inHand.getType().name().toUpperCase();
        short bdata = inHand.getDurability();
        ItemStack remove = inHand.clone();
        remove.setAmount(1);
        if (ItemStackFromId.equals(LowBoostRaw, bid, (int)bdata).booleanValue() && this.inACar(event.getPlayer())) {
            boolean boosting = this.carBoost(event.getPlayer().getName(), 10.0, 3000L, ucars.config.getDouble("general.cars.defSpeed"));
            if (boosting) {
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().removeItem(new ItemStack[]{remove});
                }
                event.getPlayer().sendMessage(String.valueOf(ucars.colors.getSuccess()) + Lang.get("lang.boosts.low"));
                return;
            }
            event.getPlayer().sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.boosts.already"));
            return;
        }
        if (ItemStackFromId.equals(MedBoostRaw, bid, (int)bdata).booleanValue() && this.inACar(event.getPlayer())) {
            boolean boosting = this.carBoost(event.getPlayer().getName(), 20.0, 6000L, ucars.config.getDouble("general.cars.defSpeed"));
            if (boosting) {
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().removeItem(new ItemStack[]{remove});
                }
                event.getPlayer().sendMessage(String.valueOf(ucars.colors.getSuccess()) + Lang.get("lang.boosts.med"));
                return;
            }
            event.getPlayer().sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.boosts.already"));
            return;
        }
        if (ItemStackFromId.equals(HighBoostRaw, bid, (int)bdata).booleanValue() && this.inACar(event.getPlayer())) {
            boolean boosting = this.carBoost(event.getPlayer().getName(), 50.0, 10000L, ucars.config.getDouble("general.cars.defSpeed"));
            if (boosting) {
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().removeItem(new ItemStack[]{remove});
                }
                event.getPlayer().sendMessage(String.valueOf(ucars.colors.getSuccess()) + Lang.get("lang.boosts.high"));
                return;
            }
            event.getPlayer().sendMessage(String.valueOf(ucars.colors.getError()) + Lang.get("lang.boosts.already"));
            return;
        }
    }

    @EventHandler
    void signInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String[] lines = sign.getLines();
        if (!lines[0].equalsIgnoreCase("[uFuel]")) {
            return;
        }
        event.setCancelled(true);
        String action = lines[1];
        String quantity = lines[2];
        double amount = 0.0;
        try {
            amount = Double.parseDouble(quantity);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (action.equalsIgnoreCase("buy")) {
            String[] args = new String[]{"buy", "" + amount};
            this.plugin.cmdExecutor.ufuel((CommandSender)event.getPlayer(), args);
        } else if (action.equalsIgnoreCase("sell")) {
            String[] args = new String[]{"sell", "" + amount};
            this.plugin.cmdExecutor.ufuel((CommandSender)event.getPlayer(), args);
        } else {
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    void minecartBreak(VehicleDamageEvent event) {
        if (!(event.getVehicle() instanceof Minecart) || !(event.getAttacker() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Minecart car = (Minecart)event.getVehicle();
        Player player = (Player)event.getAttacker();
        if (!this.isACar(car)) {
            return;
        }
        if (!ucars.config.getBoolean("general.cars.health.overrideDefault")) {
            return;
        }
        CarHealthData health = this.getCarHealthHandler(car);
        double damage = ucars.config.getDouble("general.cars.health.punchDamage");
        if (event.getDamage() > 0.0 && damage > 0.0) {
            double max = ucars.config.getDouble("general.cars.health.default");
            double left = health.getHealth() - damage;
            ChatColor color = ChatColor.YELLOW;
            if (left > max * 0.66) {
                color = ChatColor.GREEN;
            }
            if (left < max * 0.33) {
                color = ChatColor.RED;
            }
            if (left < 0.0) {
                left = 0.0;
            }
            player.sendMessage(ChatColor.RED + "-" + damage + ChatColor.YELLOW + "[" + player.getName() + "]" + color + " (" + left + ")");
            health.damage(damage);
            this.updateCarHealthHandler(car, health);
            event.setCancelled(true);
            event.setDamage(0.0);
        } else {
            event.setCancelled(true);
            event.setDamage(0.0);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void carDeath(ucarDeathEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Minecart cart = event.getCar();
        if (cart.hasMetadata("car.destroyed")) {
            return;
        }
        cart.setMetadata("car.destroyed", (MetadataValue)new StatValue(true, (Plugin)ucars.plugin));
        cart.eject();
        Location loc = cart.getLocation();
        cart.remove();
        loc.getWorld().dropItemNaturally(loc, new ItemStack(Material.MINECART));
    }

    @EventHandler
    void wirelessRedstone(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        if (!block.getType().equals((Object)Material.REDSTONE_LAMP_ON) && !block.getType().equals((Object)Material.REDSTONE_LAMP_OFF)) {
            return;
        }
        boolean on = block.isBlockPowered();
        Sign sign = null;
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace dir = blockFaceArray[n2];
            Block bd = block.getRelative(dir);
            if (bd.getState() instanceof Sign) {
                sign = (Sign)bd.getState();
            }
            ++n2;
        }
        if (sign == null) {
            return;
        }
        if (sign.getLine(0) == null || !sign.getLine(0).equalsIgnoreCase("[wir]")) {
            return;
        }
        String otherLoc = sign.getLine(1);
        if (otherLoc == null) {
            return;
        }
        String[] parts = otherLoc.split(",");
        if (parts.length < 3) {
            return;
        }
        try {
            if (!otherLoc.matches("-*\\d+,-*\\d+,-*\\d+")) {
                return;
            }
            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            Block otherBlock = block.getWorld().getBlockAt(x, y, z);
            otherBlock.getLocation().getChunk();
            if (on) {
                otherBlock.setType(Material.REDSTONE_BLOCK);
            } else {
                otherBlock.setType(Material.AIR);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private int getCoord(String in, int current) throws Exception {
        if (in.matches("-*\\d+")) {
            try {
                return Integer.parseInt(in);
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        if (in.matches("~-*\\d+") && in.length() > 1) {
            try {
                return Integer.parseInt(in.substring(1)) + current;
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        throw new Exception();
    }

    @EventHandler
    void trafficIndicators(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        if (!block.getType().equals((Object)Material.REDSTONE_LAMP_ON) && !block.getType().equals((Object)Material.REDSTONE_LAMP_OFF)) {
            return;
        }
        boolean on = block.isBlockPowered();
        Sign sign = null;
        BlockFace[] blockFaceArray = uCarsListener.dirs();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace dir = blockFaceArray[n2];
            Block bd = block.getRelative(dir);
            if (bd.getState() instanceof Sign) {
                sign = (Sign)bd.getState();
            }
            ++n2;
        }
        if (sign == null) {
            return;
        }
        if (sign.getLine(1) == null || !sign.getLine(1).equalsIgnoreCase("[trafficlight]")) {
            return;
        }
        String otherLoc = sign.getLine(2);
        if (otherLoc == null) {
            return;
        }
        String[] parts = otherLoc.split(",");
        if (parts.length < 3) {
            return;
        }
        try {
            int z;
            int y;
            int x;
            if (otherLoc.matches(".+,.+,.+")) {
                try {
                    x = this.getCoord(parts[0], sign.getX());
                    y = this.getCoord(parts[1], sign.getY());
                    z = this.getCoord(parts[2], sign.getZ());
                }
                catch (Exception e1) {
                    return;
                }
            } else {
                return;
            }
            Block otherBlock = block.getWorld().getBlockAt(x, y, z);
            Entity[] entityArray = otherBlock.getLocation().getChunk().getEntities();
            int n3 = entityArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Entity e = entityArray[n4];
                if (e.getLocation().distanceSquared(otherBlock.getLocation()) < 4.0 && e instanceof ItemFrame) {
                    ItemFrame ifr = (ItemFrame)e;
                    if (on) {
                        ifr.setItem(new ItemStack(Material.EMERALD_BLOCK));
                    } else {
                        ifr.setItem(new ItemStack(Material.REDSTONE_BLOCK));
                    }
                }
                ++n4;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public Boolean atTrafficLight(Minecart car, Block underblock, Block underunderblock, Location loc) {
        if (this.trafficLightsEnabled.booleanValue() && (this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underunderblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underunderblock.getRelative(BlockFace.DOWN)).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underunderblock.getRelative(BlockFace.DOWN, 2)).booleanValue())) {
            Boolean found = false;
            Boolean on = false;
            int radius = 3;
            int radiusSquared = radius * radius;
            int x = -radius;
            while (x <= radius && !found.booleanValue()) {
                int z = -radius;
                while (z <= radius && !found.booleanValue()) {
                    if (x * x + z * z <= radiusSquared) {
                        double locX = loc.getX() + (double)x;
                        double locZ = loc.getZ() + (double)z;
                        int y = (int)Math.round(loc.getY() - 4.0);
                        while ((double)y < loc.getY() + 4.0 && !found.booleanValue()) {
                            Location light = new Location(loc.getWorld(), locX, (double)y, locZ);
                            if (light.getBlock().getType() == Material.REDSTONE_LAMP_OFF) {
                                if (this.trafficlightSignOn(light.getBlock())) {
                                    found = true;
                                    on = false;
                                }
                            } else if (light.getBlock().getType() == Material.REDSTONE_TORCH_ON && this.trafficlightSignOn(light.getBlock())) {
                                found = true;
                                on = true;
                            }
                            ++y;
                        }
                    }
                    ++z;
                }
                ++x;
            }
            if (found.booleanValue() && !on.booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private static BlockFace[] dirs() {
        return new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH_WEST, BlockFace.NORTH_EAST, BlockFace.SOUTH_EAST, BlockFace.NORTH_WEST};
    }

    public void updateCarHealthHandler(Minecart car, CarHealthData handler) {
        car.removeMetadata("carhealth", (Plugin)ucars.plugin);
        car.setMetadata("carhealth", (MetadataValue)new StatValue(handler, (Plugin)ucars.plugin));
    }

    public CarHealthData getCarHealthHandler(Minecart car) {
        CarHealthData health = null;
        if (car.hasMetadata("carhealth")) {
            try {
                List vals = car.getMetadata("carhealth");
                for (MetadataValue val : vals) {
                    if (!(val instanceof CarHealthData)) continue;
                    health = (CarHealthData)val;
                }
            }
            catch (Exception e) {
                health = null;
            }
        }
        if (health == null) {
            health = new CarHealthData(this.defaultHealth, this.defaultDeathHandler(car), (Plugin)this.plugin);
        }
        return health;
    }

    public Runnable defaultDeathHandler(final Minecart cart) {
        return new Runnable(){

            @Override
            public void run() {
                uCarsListener.this.plugin.getServer().getPluginManager().callEvent((Event)new ucarDeathEvent(cart));
            }
        };
    }
}

