/*
 * Decompiled with CFR 0.152.
 */
package com.useful.uCarsAPI;

import com.useful.uCarsAPI.CarAccelerationModifier;
import com.useful.uCarsAPI.CarCheck;
import com.useful.uCarsAPI.CarSpeedModifier;
import com.useful.uCarsAPI.ItemCarCheck;
import com.useful.ucars.ucars;
import com.useful.ucarsCommon.StatValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class uCarsAPI {
    private ucars plugin = null;
    private Map<Plugin, CarCheck> carChecks = new HashMap<Plugin, CarCheck>();
    private Map<Plugin, ItemCarCheck> itemCarChecks = new HashMap<Plugin, ItemCarCheck>();
    private Map<Plugin, CarSpeedModifier> carSpeedMods = new HashMap<Plugin, CarSpeedModifier>();
    private Map<Plugin, CarAccelerationModifier> carAccelMods = new HashMap<Plugin, CarAccelerationModifier>();
    private Map<UUID, Map<String, StatValue>> ucarsMeta = new HashMap<UUID, Map<String, StatValue>>();

    public uCarsAPI() {
        this.plugin = ucars.plugin;
    }

    public static uCarsAPI getAPI() {
        return ucars.plugin.getAPI();
    }

    public void hookPlugin(Plugin plugin) {
        ucars.plugin.getLogger().info("Successfully hooked into by: " + plugin.getName());
        ucars.plugin.hookedPlugins.add(plugin);
    }

    public void unHookPlugin(Plugin plugin) {
        ucars.plugin.getLogger().info("Successfully unhooked: " + plugin.getName());
        ucars.plugin.hookedPlugins.remove(plugin);
    }

    public void unHookPlugins() {
        this.plugin.hookedPlugins.removeAll(this.plugin.hookedPlugins);
        this.plugin.getLogger().info("Successfully unhooked all plugins!");
    }

    public Boolean isPluginHooked(Plugin plugin) {
        if (plugin == ucars.plugin) {
            return true;
        }
        return ucars.plugin.hookedPlugins.contains(plugin);
    }

    public Boolean registerCarCheck(Plugin plugin, CarCheck carCheck) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.carChecks.put(plugin, carCheck);
        return true;
    }

    public Boolean registerItemCarCheck(Plugin plugin, ItemCarCheck carCheck) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.itemCarChecks.put(plugin, carCheck);
        return true;
    }

    public Boolean unRegisterCarCheck(Plugin plugin) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.carChecks.remove(plugin);
        return true;
    }

    public Boolean unRegisterItemCarCheck(Plugin plugin) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.itemCarChecks.remove(plugin);
        return true;
    }

    public synchronized Boolean runCarChecks(Minecart car) {
        for (CarCheck c : this.carChecks.values()) {
            if (c.isACar(car).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized Boolean runCarChecks(ItemStack carStack) {
        for (ItemCarCheck c : this.itemCarChecks.values()) {
            if (c.isACar(carStack).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean registerSpeedMod(Plugin plugin, CarSpeedModifier speedMod) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.carSpeedMods.put(plugin, speedMod);
        return true;
    }

    public Boolean unRegisterSpeedMod(Plugin plugin) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.carSpeedMods.remove(plugin);
        return true;
    }

    public Boolean registerAccelerationMod(Plugin plugin, CarAccelerationModifier accMod) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.carAccelMods.put(plugin, accMod);
        return true;
    }

    public Boolean unRegisterAccelerationMod(Plugin plugin) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.carAccelMods.remove(plugin);
        return true;
    }

    public float getAcceleration(Player driver, float currentMult) {
        if (this.carAccelMods.size() < 1) {
            return currentMult;
        }
        for (CarAccelerationModifier m : new ArrayList<CarAccelerationModifier>(this.carAccelMods.values())) {
            currentMult = m.getAccelerationDecimal(driver, currentMult);
        }
        return currentMult;
    }

    public synchronized Vector getTravelVector(Minecart car, Vector travelVector, double currentMult) {
        for (CarSpeedModifier m : this.carSpeedMods.values()) {
            travelVector = m.getModifiedSpeed(car, travelVector, currentMult);
        }
        return travelVector;
    }

    public Map<String, StatValue> getuCarMeta(UUID entityId) {
        if (!this.ucarsMeta.containsKey(entityId)) {
            return new HashMap<String, StatValue>();
        }
        return this.ucarsMeta.get(entityId);
    }

    public boolean setUseRaceControls(UUID id, Plugin plugin) {
        return this.adduCarsMeta(plugin, id, "car.controls", new StatValue("race", (Plugin)ucars.plugin));
    }

    public Boolean adduCarsMeta(Plugin plugin, UUID entityId, String statName, StatValue toAdd) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        Map<String, StatValue> stats = new HashMap<String, StatValue>();
        if (this.ucarsMeta.containsKey(entityId)) {
            stats = this.ucarsMeta.get(entityId);
        }
        stats.put(statName, toAdd);
        this.ucarsMeta.put(entityId, stats);
        return true;
    }

    public StatValue getUcarMeta(Plugin plugin, String statName, UUID entityId) {
        if (!this.isPluginHooked(plugin).booleanValue() || !this.ucarsMeta.containsKey(entityId)) {
            return null;
        }
        Map<String, StatValue> metas = this.ucarsMeta.get(entityId);
        if (!metas.containsKey(statName)) {
            return null;
        }
        return metas.get(statName);
    }

    public Boolean removeUcarMeta(Plugin plugin, String statName, UUID entityId) {
        if (!this.isPluginHooked(plugin).booleanValue() || !this.ucarsMeta.containsKey(entityId)) {
            return false;
        }
        Map<String, StatValue> metas = this.ucarsMeta.get(entityId);
        if (!metas.containsKey(statName)) {
            return false;
        }
        metas.remove(statName);
        this.ucarsMeta.put(entityId, metas);
        return true;
    }

    public Boolean clearCarMeta(Plugin plugin, UUID entityId) {
        if (!this.isPluginHooked(plugin).booleanValue()) {
            return false;
        }
        this.ucarsMeta.remove(entityId);
        return true;
    }

    public void updateUcarMeta(UUID previousId, UUID newId) {
        if (!this.ucarsMeta.containsKey(previousId)) {
            return;
        }
        this.ucarsMeta.put(newId, new HashMap<String, StatValue>(this.ucarsMeta.get(previousId)));
        this.ucarsMeta.remove(previousId);
    }

    public Boolean checkIfCar(Minecart car) {
        return ucars.listener.isACar(car);
    }

    public Boolean checkInCar(Player player) {
        return ucars.listener.inACar(player);
    }

    public Boolean checkInCar(String player) {
        return ucars.listener.inACar(player);
    }

    public String getUCarsVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public Boolean atTrafficLight(Minecart car) {
        Location loc = car.getLocation();
        Block under = loc.getBlock().getRelative(BlockFace.DOWN);
        Block underunder = under.getRelative(BlockFace.DOWN);
        return ucars.listener.atTrafficLight(car, under, underunder, loc);
    }
}

