/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.XPGainReason;
import com.gmail.nossr50.events.fake.FakeEntityDamageByEntityEvent;
import com.gmail.nossr50.events.fake.FakeEntityDamageEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.runnables.skills.AwardCombatXpTask;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.swords.Swords;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public final class CombatUtils {
    private CombatUtils() {
    }

    private static void processSwordCombat(LivingEntity target, Player player, EntityDamageByEntityEvent event) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        SwordsManager swordsManager = mcMMOPlayer.getSwordsManager();
        double initialDamage = event.getDamage();
        Map<EntityDamageEvent.DamageModifier, Double> modifiers = CombatUtils.getModifiers((EntityDamageEvent)event);
        if (swordsManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(SkillType.SWORDS);
        }
        if (swordsManager.canUseBleed()) {
            swordsManager.bleedCheck(target);
        }
        if (swordsManager.canUseSerratedStrike()) {
            swordsManager.serratedStrikes(target, initialDamage, modifiers);
        }
        CombatUtils.startGainXp(mcMMOPlayer, target, SkillType.SWORDS);
    }

    private static void processAxeCombat(LivingEntity target, Player player, EntityDamageByEntityEvent event) {
        double initialDamage;
        double finalDamage = initialDamage = event.getDamage();
        Map<EntityDamageEvent.DamageModifier, Double> modifiers = CombatUtils.getModifiers((EntityDamageEvent)event);
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        AxesManager axesManager = mcMMOPlayer.getAxesManager();
        if (axesManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(SkillType.AXES);
        }
        if (axesManager.canUseAxeMastery()) {
            finalDamage += axesManager.axeMastery();
        }
        if (axesManager.canCriticalHit(target)) {
            finalDamage += axesManager.criticalHit(target, initialDamage);
        }
        if (axesManager.canImpact(target)) {
            axesManager.impactCheck(target);
        } else if (axesManager.canGreaterImpact(target)) {
            finalDamage += axesManager.greaterImpact(target);
        }
        if (axesManager.canUseSkullSplitter(target)) {
            axesManager.skullSplitterCheck(target, initialDamage, modifiers);
        }
        CombatUtils.applyScaledModifiers(initialDamage, finalDamage, event);
        CombatUtils.startGainXp(mcMMOPlayer, target, SkillType.AXES);
    }

    private static void processUnarmedCombat(LivingEntity target, Player player, EntityDamageByEntityEvent event) {
        double initialDamage;
        double finalDamage = initialDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        UnarmedManager unarmedManager = mcMMOPlayer.getUnarmedManager();
        if (unarmedManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(SkillType.UNARMED);
        }
        if (unarmedManager.canUseIronArm()) {
            finalDamage += unarmedManager.ironArm();
        }
        if (unarmedManager.canUseBerserk()) {
            finalDamage += unarmedManager.berserkDamage(initialDamage);
        }
        if (unarmedManager.canDisarm(target)) {
            unarmedManager.disarmCheck((Player)target);
        }
        CombatUtils.applyScaledModifiers(initialDamage, finalDamage, event);
        CombatUtils.startGainXp(mcMMOPlayer, target, SkillType.UNARMED);
    }

    private static void processTamingCombat(LivingEntity target, Player master, Wolf wolf, EntityDamageByEntityEvent event) {
        double initialDamage;
        double finalDamage = initialDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(master);
        TamingManager tamingManager = mcMMOPlayer.getTamingManager();
        if (tamingManager.canUseFastFoodService()) {
            tamingManager.fastFoodService(wolf, event.getDamage());
        }
        tamingManager.pummel(target, wolf);
        if (tamingManager.canUseSharpenedClaws()) {
            finalDamage += tamingManager.sharpenedClaws();
        }
        if (tamingManager.canUseGore()) {
            finalDamage += tamingManager.gore(target, initialDamage);
        }
        CombatUtils.applyScaledModifiers(initialDamage, finalDamage, event);
        CombatUtils.startGainXp(mcMMOPlayer, target, SkillType.TAMING);
    }

    private static void processArcheryCombat(LivingEntity target, Player player, EntityDamageByEntityEvent event, Arrow arrow) {
        UnarmedManager unarmedManager;
        double initialDamage;
        double finalDamage = initialDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        ArcheryManager archeryManager = mcMMOPlayer.getArcheryManager();
        if (target instanceof Player && SkillType.UNARMED.getPVPEnabled() && (unarmedManager = UserManager.getPlayer((Player)target).getUnarmedManager()).canDeflect()) {
            event.setCancelled(unarmedManager.deflectCheck());
            if (event.isCancelled()) {
                return;
            }
        }
        if (archeryManager.canSkillShot()) {
            finalDamage += archeryManager.skillShot(initialDamage);
        }
        if (archeryManager.canDaze(target)) {
            finalDamage += archeryManager.daze((Player)target);
        }
        if (!arrow.hasMetadata("mcMMO: Infinite Arrow") && archeryManager.canRetrieveArrows()) {
            archeryManager.retrieveArrows(target);
        }
        archeryManager.distanceXpBonus(target, (Entity)arrow);
        CombatUtils.applyScaledModifiers(initialDamage, finalDamage, event);
        CombatUtils.startGainXp(mcMMOPlayer, target, SkillType.ARCHERY, ((MetadataValue)arrow.getMetadata("mcMMO: Bow Force").get(0)).asDouble());
    }

    public static void processCombatAttack(EntityDamageByEntityEvent event, Entity attacker, LivingEntity target) {
        Arrow arrow;
        ProjectileSource projectileSource;
        Player player;
        Entity damager = event.getDamager();
        EntityType entityType = damager.getType();
        if (attacker instanceof Player && entityType == EntityType.PLAYER) {
            player = (Player)attacker;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            ItemStack heldItem = player.getItemInHand();
            if (target instanceof Tameable) {
                TamingManager tamingManager;
                if (heldItem.getType() == Material.BONE && (tamingManager = UserManager.getPlayer(player).getTamingManager()).canUseBeastLore()) {
                    tamingManager.beastLore(target);
                    event.setCancelled(true);
                    return;
                }
                if (CombatUtils.isFriendlyPet(player, (Tameable)target)) {
                    return;
                }
            }
            if (ItemUtils.isSword(heldItem)) {
                if (!SkillType.SWORDS.shouldProcess((Entity)target)) {
                    return;
                }
                if (SkillType.SWORDS.getPermissions(player)) {
                    CombatUtils.processSwordCombat(target, player, event);
                }
            } else if (ItemUtils.isAxe(heldItem)) {
                if (!SkillType.AXES.shouldProcess((Entity)target)) {
                    return;
                }
                if (SkillType.AXES.getPermissions(player)) {
                    CombatUtils.processAxeCombat(target, player, event);
                }
            } else if (ItemUtils.isUnarmed(heldItem)) {
                if (!SkillType.UNARMED.shouldProcess((Entity)target)) {
                    return;
                }
                if (SkillType.UNARMED.getPermissions(player)) {
                    CombatUtils.processUnarmedCombat(target, player, event);
                }
            }
        } else if (entityType == EntityType.WOLF) {
            Player master;
            Wolf wolf = (Wolf)damager;
            AnimalTamer tamer = wolf.getOwner();
            if (tamer != null && tamer instanceof Player && SkillType.TAMING.shouldProcess((Entity)target) && !Misc.isNPCEntity((Entity)(master = (Player)tamer)) && SkillType.TAMING.getPermissions(master)) {
                CombatUtils.processTamingCombat(target, master, wolf, event);
            }
        } else if (entityType == EntityType.ARROW && (projectileSource = (arrow = (Arrow)damager).getShooter()) != null && projectileSource instanceof Player && SkillType.ARCHERY.shouldProcess((Entity)target)) {
            Player player2 = (Player)projectileSource;
            if (!Misc.isNPCEntity((Entity)player2) && SkillType.ARCHERY.getPermissions(player2)) {
                CombatUtils.processArcheryCombat(target, player2, event, arrow);
            }
            if (target.getType() != EntityType.CREEPER && !Misc.isNPCEntity((Entity)player2) && SkillType.TAMING.getPermissions(player2)) {
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player2);
                TamingManager tamingManager = mcMMOPlayer.getTamingManager();
                tamingManager.attackTarget(target);
            }
        }
        if (target instanceof Player) {
            if (Misc.isNPCEntity((Entity)target)) {
                return;
            }
            player = (Player)target;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            AcrobaticsManager acrobaticsManager = mcMMOPlayer.getAcrobaticsManager();
            if (acrobaticsManager.canDodge((Entity)target)) {
                event.setDamage(acrobaticsManager.dodgeCheck(event.getDamage()));
            }
            if (ItemUtils.isSword(player.getItemInHand())) {
                if (!SkillType.SWORDS.shouldProcess((Entity)target)) {
                    return;
                }
                SwordsManager swordsManager = mcMMOPlayer.getSwordsManager();
                if (swordsManager.canUseCounterAttack(damager)) {
                    swordsManager.counterAttackChecks((LivingEntity)damager, event.getDamage());
                }
            }
        }
    }

    @Deprecated
    public static void dealDamage(LivingEntity target, double damage) {
        CombatUtils.dealDamage(target, damage, EntityDamageEvent.DamageCause.CUSTOM, null);
    }

    @Deprecated
    public static void dealDamage(LivingEntity target, double damage, LivingEntity attacker) {
        CombatUtils.dealDamage(target, damage, EntityDamageEvent.DamageCause.ENTITY_ATTACK, (Entity)attacker);
    }

    public static void dealDamage(LivingEntity target, double damage, Map<EntityDamageEvent.DamageModifier, Double> modifiers, LivingEntity attacker) {
        if (target.isDead()) {
            return;
        }
        target.damage(CombatUtils.callFakeDamageEvent((Entity)attacker, (Entity)target, damage, modifiers));
    }

    @Deprecated
    public static void dealDamage(LivingEntity target, double damage, EntityDamageEvent.DamageCause cause, Entity attacker) {
        if (target.isDead()) {
            return;
        }
        target.damage(CombatUtils.callFakeDamageEvent(attacker, (Entity)target, cause, damage));
    }

    public static void applyAbilityAoE(Player attacker, LivingEntity target, double damage, Map<EntityDamageEvent.DamageModifier, Double> modifiers, SkillType type) {
        int numberOfTargets = CombatUtils.getTier(attacker.getItemInHand());
        double damageAmount = Math.max(damage, 1.0);
        for (Entity entity : target.getNearbyEntities(2.5, 2.5, 2.5)) {
            if (numberOfTargets <= 0) break;
            if (Misc.isNPCEntity(entity) || !(entity instanceof LivingEntity) || !CombatUtils.shouldBeAffected(attacker, entity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            EventUtils.callFakeArmSwingEvent(attacker);
            switch (type) {
                case SWORDS: {
                    if (entity instanceof Player) {
                        ((Player)entity).sendMessage(LocaleLoader.getString("Swords.Combat.SS.Struck"));
                    }
                    BleedTimerTask.add(livingEntity, Swords.serratedStrikesBleedTicks);
                    break;
                }
                case AXES: {
                    if (!(entity instanceof Player)) break;
                    ((Player)entity).sendMessage(LocaleLoader.getString("Axes.Combat.SS.Struck"));
                    break;
                }
            }
            CombatUtils.dealDamage(livingEntity, damageAmount, (LivingEntity)attacker);
            --numberOfTargets;
        }
    }

    public static void startGainXp(McMMOPlayer mcMMOPlayer, LivingEntity target, SkillType skillType) {
        CombatUtils.startGainXp(mcMMOPlayer, target, skillType, 1.0);
    }

    private static void startGainXp(McMMOPlayer mcMMOPlayer, LivingEntity target, SkillType skillType, double multiplier) {
        XPGainReason xpGainReason;
        double baseXP = 0.0;
        if (target instanceof Player) {
            if (!ExperienceConfig.getInstance().getExperienceGainsPlayerVersusPlayerEnabled()) {
                return;
            }
            xpGainReason = XPGainReason.PVP;
            Player defender = (Player)target;
            if (defender.isOnline() && SkillUtils.cooldownExpired(mcMMOPlayer.getRespawnATS(), 5)) {
                baseXP = 20.0 * ExperienceConfig.getInstance().getPlayerVersusPlayerXP();
            }
        } else {
            if (mcMMO.getModManager().isCustomEntity((Entity)target)) {
                baseXP = mcMMO.getModManager().getEntity((Entity)target).getXpMultiplier();
            } else if (target instanceof Animals) {
                baseXP = ExperienceConfig.getInstance().getAnimalsXP();
            } else {
                EntityType type = target.getType();
                block0 : switch (type) {
                    case BAT: 
                    case SQUID: 
                    case RABBIT: {
                        baseXP = ExperienceConfig.getInstance().getAnimalsXP();
                        break;
                    }
                    case BLAZE: 
                    case CAVE_SPIDER: 
                    case CREEPER: 
                    case ENDER_DRAGON: 
                    case ENDERMAN: 
                    case GHAST: 
                    case GIANT: 
                    case MAGMA_CUBE: 
                    case PIG_ZOMBIE: 
                    case SILVERFISH: 
                    case SLIME: 
                    case SPIDER: 
                    case WITCH: 
                    case WITHER: 
                    case ZOMBIE: 
                    case ENDERMITE: {
                        baseXP = ExperienceConfig.getInstance().getCombatXP(type);
                        break;
                    }
                    case SKELETON: {
                        switch (((Skeleton)target).getSkeletonType()) {
                            case WITHER: {
                                baseXP = ExperienceConfig.getInstance().getWitherSkeletonXP();
                                break block0;
                            }
                        }
                        baseXP = ExperienceConfig.getInstance().getCombatXP(type);
                        break;
                    }
                    case IRON_GOLEM: {
                        if (((IronGolem)target).isPlayerCreated()) break;
                        baseXP = ExperienceConfig.getInstance().getCombatXP(type);
                        break;
                    }
                    case GUARDIAN: {
                        if (((Guardian)target).isElder()) {
                            baseXP = ExperienceConfig.getInstance().getElderGuardianXP();
                            break;
                        }
                        baseXP = ExperienceConfig.getInstance().getCombatXP(type);
                        break;
                    }
                    default: {
                        baseXP = 1.0;
                        mcMMO.getModManager().addCustomEntity((Entity)target);
                    }
                }
            }
            if (target.hasMetadata("mcMMO: Spawned Entity")) {
                baseXP *= ExperienceConfig.getInstance().getSpawnedMobXpMultiplier();
            }
            if (target.hasMetadata("mcMMO: Bred Animal")) {
                baseXP *= ExperienceConfig.getInstance().getBredMobXpMultiplier();
            }
            xpGainReason = XPGainReason.PVE;
            baseXP *= 10.0;
        }
        if ((baseXP *= multiplier) != 0.0) {
            new AwardCombatXpTask(mcMMOPlayer, skillType, baseXP, target, xpGainReason).runTaskLater((Plugin)mcMMO.p, 0L);
        }
    }

    private static boolean shouldBeAffected(Player player, Entity entity) {
        if (entity instanceof Player) {
            Player defender = (Player)entity;
            if (!defender.getWorld().getPVP() || defender == player || UserManager.getPlayer(defender).getGodMode()) {
                return false;
            }
            if (!(!PartyManager.inSameParty(player, defender) && !PartyManager.areAllies(player, defender) || Permissions.friendlyFire((Permissible)player) && Permissions.friendlyFire((Permissible)defender))) {
                return false;
            }
            if (!player.canSee(defender)) {
                return false;
            }
            if (CombatUtils.callFakeDamageEvent((Entity)player, entity, 1.0) == 0.0) {
                return false;
            }
        } else if (entity instanceof Tameable && CombatUtils.isFriendlyPet(player, (Tameable)entity)) {
            Player owner = (Player)((Tameable)entity).getOwner();
            if (!Permissions.friendlyFire((Permissible)player) || !Permissions.friendlyFire((Permissible)owner)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isInvincible(LivingEntity entity, double eventDamage) {
        return (float)entity.getNoDamageTicks() > (float)entity.getMaximumNoDamageTicks() / 2.0f && eventDamage <= entity.getLastDamage();
    }

    public static boolean isFriendlyPet(Player attacker, Tameable pet) {
        AnimalTamer tamer;
        if (pet.isTamed() && (tamer = pet.getOwner()) instanceof Player) {
            Player owner = (Player)tamer;
            return owner == attacker || PartyManager.inSameParty(attacker, owner) || PartyManager.areAllies(attacker, owner);
        }
        return false;
    }

    @Deprecated
    public static double callFakeDamageEvent(Entity attacker, Entity target, double damage) {
        return CombatUtils.callFakeDamageEvent(attacker, target, EntityDamageEvent.DamageCause.ENTITY_ATTACK, new EnumMap<EntityDamageEvent.DamageModifier, Double>((Map<EntityDamageEvent.DamageModifier, Double>)ImmutableMap.of((Object)EntityDamageEvent.DamageModifier.BASE, (Object)damage)));
    }

    @Deprecated
    public static double callFakeDamageEvent(Entity attacker, Entity target, EntityDamageEvent.DamageCause damageCause, double damage) {
        Object damageEvent = attacker == null ? new FakeEntityDamageEvent(target, damageCause, damage) : new FakeEntityDamageByEntityEvent(attacker, target, damageCause, damage);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)damageEvent);
        if (damageEvent.isCancelled()) {
            return 0.0;
        }
        return damageEvent.getFinalDamage();
    }

    public static double callFakeDamageEvent(Entity attacker, Entity target, Map<EntityDamageEvent.DamageModifier, Double> modifiers) {
        return CombatUtils.callFakeDamageEvent(attacker, target, EntityDamageEvent.DamageCause.ENTITY_ATTACK, modifiers);
    }

    public static double callFakeDamageEvent(Entity attacker, Entity target, double damage, Map<EntityDamageEvent.DamageModifier, Double> modifiers) {
        return CombatUtils.callFakeDamageEvent(attacker, target, EntityDamageEvent.DamageCause.ENTITY_ATTACK, CombatUtils.getScaledModifiers(damage, modifiers));
    }

    public static double callFakeDamageEvent(Entity attacker, Entity target, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Double> modifiers) {
        Object damageEvent = attacker == null ? new FakeEntityDamageEvent(target, cause, modifiers) : new FakeEntityDamageByEntityEvent(attacker, target, cause, modifiers);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)damageEvent);
        if (damageEvent.isCancelled()) {
            return 0.0;
        }
        return damageEvent.getFinalDamage();
    }

    private static Map<EntityDamageEvent.DamageModifier, Double> getModifiers(EntityDamageEvent event) {
        HashMap<EntityDamageEvent.DamageModifier, Double> modifiers = new HashMap<EntityDamageEvent.DamageModifier, Double>();
        for (EntityDamageEvent.DamageModifier modifier : EntityDamageEvent.DamageModifier.values()) {
            modifiers.put(modifier, event.getDamage(modifier));
        }
        return modifiers;
    }

    private static Map<EntityDamageEvent.DamageModifier, Double> getScaledModifiers(double damage, Map<EntityDamageEvent.DamageModifier, Double> modifiers) {
        HashMap<EntityDamageEvent.DamageModifier, Double> scaledModifiers = new HashMap<EntityDamageEvent.DamageModifier, Double>();
        for (EntityDamageEvent.DamageModifier modifier : modifiers.keySet()) {
            if (modifier == EntityDamageEvent.DamageModifier.BASE) {
                scaledModifiers.put(modifier, damage);
                continue;
            }
            scaledModifiers.put(modifier, damage * modifiers.get(modifier));
        }
        return scaledModifiers;
    }

    public static EntityDamageByEntityEvent applyScaledModifiers(double initialDamage, double finalDamage, EntityDamageByEntityEvent event) {
        if (initialDamage == finalDamage) {
            return event;
        }
        for (EntityDamageEvent.DamageModifier modifier : EntityDamageEvent.DamageModifier.values()) {
            if (!event.isApplicable(modifier)) continue;
            if (modifier == EntityDamageEvent.DamageModifier.BASE) {
                event.setDamage(modifier, finalDamage);
                continue;
            }
            event.setDamage(modifier, finalDamage / initialDamage * event.getDamage(modifier));
        }
        return event;
    }

    private static int getTier(ItemStack inHand) {
        int tier = 0;
        if (ItemUtils.isWoodTool(inHand)) {
            tier = 1;
        } else if (ItemUtils.isStoneTool(inHand)) {
            tier = 2;
        } else if (ItemUtils.isIronTool(inHand)) {
            tier = 3;
        } else if (ItemUtils.isGoldTool(inHand)) {
            tier = 1;
        } else if (ItemUtils.isDiamondTool(inHand)) {
            tier = 4;
        } else if (mcMMO.getModManager().isCustomTool(inHand)) {
            tier = mcMMO.getModManager().getTool(inHand).getTier();
        }
        return tier;
    }

    public static void handleHealthbars(Entity attacker, LivingEntity target, double damage) {
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        if (Misc.isNPCEntity((Entity)player) || Misc.isNPCEntity((Entity)target)) {
            return;
        }
        if (!player.hasMetadata("mcMMO: Player Data")) {
            return;
        }
        MobHealthbarUtils.handleMobHealthbars(player, target, damage);
    }
}

