/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.scoreboards;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardWrapper {
    public final String playerName;
    private final Scoreboard scoreboard;
    private boolean tippedKeep = false;
    private boolean tippedClear = false;
    private ScoreboardManager.SidebarType sidebarType;
    private Objective sidebarObjective;
    private Objective powerObjective;
    private Scoreboard oldBoard = null;
    public String targetPlayer = null;
    public SkillType targetSkill = null;
    private PlayerProfile targetProfile = null;
    public int leaderboardPage = -1;
    public BukkitTask updateTask = null;
    public BukkitTask revertTask = null;
    public BukkitTask cooldownTask = null;

    private ScoreboardWrapper(String playerName, Scoreboard scoreboard) {
        this.playerName = playerName;
        this.scoreboard = scoreboard;
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.sidebarObjective = this.scoreboard.registerNewObjective("mcmmo_sidebar", "dummy");
        this.powerObjective = this.scoreboard.registerNewObjective("mcmmo_pwrlvl", "dummy");
        if (Config.getInstance().getPowerLevelTagsEnabled()) {
            this.powerObjective.setDisplayName(ScoreboardManager.TAG_POWER_LEVEL);
            this.powerObjective.setDisplaySlot(DisplaySlot.BELOW_NAME);
            for (McMMOPlayer mcMMOPlayer : UserManager.getPlayers()) {
                this.powerObjective.getScore(mcMMOPlayer.getProfile().getPlayerName()).setScore(mcMMOPlayer.getPowerLevel());
            }
        }
    }

    public static ScoreboardWrapper create(Player player) {
        return new ScoreboardWrapper(player.getName(), mcMMO.p.getServer().getScoreboardManager().getNewScoreboard());
    }

    public void doSidebarUpdateSoon() {
        if (this.updateTask == null) {
            this.updateTask = new ScoreboardQuickUpdate().runTaskLater((Plugin)mcMMO.p, 2L);
        }
    }

    private void startCooldownUpdating() {
        if (this.cooldownTask == null) {
            this.cooldownTask = new ScoreboardCooldownTask().runTaskTimer((Plugin)mcMMO.p, 100L, 100L);
        }
    }

    private void stopCooldownUpdating() {
        if (this.cooldownTask != null) {
            try {
                this.cooldownTask.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cooldownTask = null;
        }
    }

    public boolean isSkillScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.SKILL_BOARD;
    }

    public boolean isCooldownScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.COOLDOWNS_BOARD;
    }

    public boolean isStatsScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.STATS_BOARD;
    }

    public void setOldScoreboard() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        Scoreboard oldBoard = player.getScoreboard();
        if (oldBoard == this.scoreboard) {
            if (this.oldBoard == null) {
                this.oldBoard = mcMMO.p.getServer().getScoreboardManager().getMainScoreboard();
            }
        } else {
            this.oldBoard = oldBoard;
        }
    }

    public void showBoardWithNoRevert() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.revertTask != null) {
            this.revertTask.cancel();
        }
        player.setScoreboard(this.scoreboard);
        this.revertTask = null;
    }

    public void showBoardAndScheduleRevert(int ticks) {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.revertTask != null) {
            this.revertTask.cancel();
        }
        player.setScoreboard(this.scoreboard);
        this.revertTask = new ScoreboardChangeTask().runTaskLater((Plugin)mcMMO.p, ticks);
        PlayerProfile profile = UserManager.getPlayer(player).getProfile();
        if (profile.getScoreboardTipsShown() >= Config.getInstance().getTipsAmount()) {
            return;
        }
        if (!this.tippedKeep) {
            this.tippedKeep = true;
            player.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Tip.Keep"));
        } else if (!this.tippedClear) {
            this.tippedClear = true;
            player.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Tip.Clear"));
            profile.increaseTipsShown();
        }
    }

    public void tryRevertBoard() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.oldBoard != null) {
            if (player.getScoreboard() == this.scoreboard) {
                player.setScoreboard(this.oldBoard);
                this.oldBoard = null;
            } else {
                mcMMO.p.debug("Not reverting scoreboard for " + this.playerName + " - scoreboard was changed by another plugin (Consider disabling the mcMMO scoreboards if you don't want them!)");
            }
        }
        this.cancelRevert();
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
    }

    public boolean isBoardShown() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return false;
        }
        return player.getScoreboard() == this.scoreboard;
    }

    public void cancelRevert() {
        if (this.revertTask == null) {
            return;
        }
        this.revertTask.cancel();
        this.revertTask = null;
    }

    public void setTypeNone() {
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective("");
    }

    public void setTypeSkill(SkillType skill) {
        this.sidebarType = ScoreboardManager.SidebarType.SKILL_BOARD;
        this.targetSkill = skill;
        this.targetPlayer = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.skillLabels.get((Object)skill));
    }

    public void setTypeSelfStats() {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_STATS);
    }

    public void setTypeInspectStats(PlayerProfile profile) {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = profile.getPlayerName();
        this.targetProfile = profile;
        this.targetSkill = null;
        this.leaderboardPage = -1;
        this.loadObjective(LocaleLoader.getString("Scoreboard.Header.PlayerInspect", this.targetPlayer));
    }

    public void setTypeCooldowns() {
        this.sidebarType = ScoreboardManager.SidebarType.COOLDOWNS_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_COOLDOWNS);
    }

    public void setTypeSelfRank() {
        this.sidebarType = ScoreboardManager.SidebarType.RANK_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_RANK);
    }

    public void setTypeInspectRank(String otherPlayer) {
        this.sidebarType = ScoreboardManager.SidebarType.RANK_BOARD;
        this.targetPlayer = otherPlayer;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_RANK);
    }

    public void setTypeTopPower(int page) {
        this.sidebarType = ScoreboardManager.SidebarType.TOP_BOARD;
        this.leaderboardPage = page;
        this.targetSkill = null;
        this.targetPlayer = null;
        this.targetProfile = null;
        int endPosition = page * 15;
        int startPosition = endPosition - 14;
        this.loadObjective(String.format("%s (%2d - %2d)", ScoreboardManager.POWER_LEVEL, startPosition, endPosition));
    }

    public void setTypeTop(SkillType skill, int page) {
        this.sidebarType = ScoreboardManager.SidebarType.TOP_BOARD;
        this.leaderboardPage = page;
        this.targetSkill = skill;
        this.targetPlayer = null;
        this.targetProfile = null;
        int endPosition = page * 15;
        int startPosition = endPosition - 14;
        this.loadObjective(String.format("%s (%2d - %2d)", ScoreboardManager.skillLabels.get((Object)skill), startPosition, endPosition));
    }

    protected void loadObjective(String displayName) {
        this.sidebarObjective.unregister();
        this.sidebarObjective = this.scoreboard.registerNewObjective("mcmmo_sidebar", "dummy");
        if (displayName.length() > 32) {
            displayName = displayName.substring(0, 32);
        }
        this.sidebarObjective.setDisplayName(displayName);
        this.updateSidebar();
        this.sidebarObjective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    private void updateSidebar() {
        try {
            this.updateTask.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateTask = null;
        if (this.sidebarType == ScoreboardManager.SidebarType.NONE) {
            return;
        }
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        switch (this.sidebarType) {
            case NONE: {
                break;
            }
            case SKILL_BOARD: {
                boolean stopUpdating;
                Validate.notNull((Object)((Object)this.targetSkill));
                if (!this.targetSkill.isChildSkill()) {
                    int currentXP = mcMMOPlayer.getSkillXpLevel(this.targetSkill);
                    this.sidebarObjective.getScore(ScoreboardManager.LABEL_CURRENT_XP).setScore(currentXP);
                    this.sidebarObjective.getScore(ScoreboardManager.LABEL_REMAINING_XP).setScore(mcMMOPlayer.getXpToLevel(this.targetSkill) - currentXP);
                } else {
                    for (SkillType parentSkill : FamilyTree.getParents(this.targetSkill)) {
                        this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)parentSkill)).setScore(mcMMOPlayer.getSkillLevel(parentSkill));
                    }
                }
                this.sidebarObjective.getScore(ScoreboardManager.LABEL_LEVEL).setScore(mcMMOPlayer.getSkillLevel(this.targetSkill));
                if (this.targetSkill.getAbility() == null) break;
                if (this.targetSkill == SkillType.MINING) {
                    Score cooldownSB = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)AbilityType.SUPER_BREAKER));
                    Score cooldownBM = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)AbilityType.BLAST_MINING));
                    int secondsSB = Math.max(mcMMOPlayer.calculateTimeRemaining(AbilityType.SUPER_BREAKER), 0);
                    int secondsBM = Math.max(mcMMOPlayer.calculateTimeRemaining(AbilityType.BLAST_MINING), 0);
                    cooldownSB.setScore(secondsSB);
                    cooldownBM.setScore(secondsBM);
                    stopUpdating = secondsSB == 0 && secondsBM == 0;
                } else {
                    AbilityType ability = this.targetSkill.getAbility();
                    Score cooldown = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)ability));
                    int seconds = Math.max(mcMMOPlayer.calculateTimeRemaining(ability), 0);
                    cooldown.setScore(seconds);
                    boolean bl = stopUpdating = seconds == 0;
                }
                if (stopUpdating) {
                    this.stopCooldownUpdating();
                    break;
                }
                this.startCooldownUpdating();
                break;
            }
            case COOLDOWNS_BOARD: {
                boolean anyCooldownsActive = false;
                for (AbilityType ability : AbilityType.values()) {
                    int seconds = Math.max(mcMMOPlayer.calculateTimeRemaining(ability), 0);
                    if (seconds != 0) {
                        anyCooldownsActive = true;
                    }
                    this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsColored.get((Object)ability)).setScore(seconds);
                }
                if (anyCooldownsActive) {
                    this.startCooldownUpdating();
                    break;
                }
                this.stopCooldownUpdating();
                break;
            }
            case STATS_BOARD: {
                PlayerProfile newProfile = this.targetProfile != null ? this.targetProfile : (this.targetPlayer == null ? mcMMOPlayer.getProfile() : UserManager.getPlayer(this.targetPlayer).getProfile());
                int powerLevel = 0;
                for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
                    int level = newProfile.getSkillLevel(skill);
                    powerLevel += level;
                    if (!skill.getPermissions(player)) continue;
                    this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)skill)).setScore(level);
                }
                this.sidebarObjective.getScore(ScoreboardManager.LABEL_POWER_LEVEL).setScore(powerLevel);
                break;
            }
            case RANK_BOARD: 
            case TOP_BOARD: {
                break;
            }
        }
    }

    public void acceptRankData(Map<SkillType, Integer> rankData) {
        Integer rank;
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
            if (!skill.getPermissions(player) || (rank = rankData.get((Object)skill)) == null) continue;
            this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)skill)).setScore(rank.intValue());
        }
        rank = rankData.get(null);
        if (rank != null) {
            this.sidebarObjective.getScore(ScoreboardManager.LABEL_POWER_LEVEL).setScore(rank.intValue());
        }
    }

    public void acceptLeaderboardData(List<PlayerStat> leaderboardData) {
        for (PlayerStat stat : leaderboardData) {
            String name = stat.name;
            if (name.equals(this.playerName)) {
                name = ChatColor.GOLD + "--You--";
            }
            this.sidebarObjective.getScore(name).setScore(stat.statVal);
        }
    }

    public void updatePowerLevel(Player player, int newPowerLevel) {
        this.powerObjective.getScore(player.getName()).setScore(newPowerLevel);
    }

    private class ScoreboardCooldownTask
    extends BukkitRunnable {
        private ScoreboardCooldownTask() {
        }

        public void run() {
            if (ScoreboardWrapper.this.isBoardShown() && (ScoreboardWrapper.this.isSkillScoreboard() || ScoreboardWrapper.this.isCooldownScoreboard())) {
                ScoreboardWrapper.this.doSidebarUpdateSoon();
            } else {
                ScoreboardWrapper.this.stopCooldownUpdating();
            }
        }
    }

    private class ScoreboardChangeTask
    extends BukkitRunnable {
        private ScoreboardChangeTask() {
        }

        public void run() {
            ScoreboardWrapper.this.tryRevertBoard();
            ScoreboardWrapper.this.revertTask = null;
        }
    }

    private class ScoreboardQuickUpdate
    extends BukkitRunnable {
        private ScoreboardQuickUpdate() {
        }

        public void run() {
            ScoreboardWrapper.this.updateSidebar();
            ScoreboardWrapper.this.updateTask = null;
        }
    }
}

