/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.commands;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CommandUtils {
    public static final List<String> TRUE_FALSE_OPTIONS = ImmutableList.of((Object)"on", (Object)"off", (Object)"true", (Object)"false", (Object)"enabled", (Object)"disabled");
    public static final List<String> RESET_OPTIONS = ImmutableList.of((Object)"clear", (Object)"reset");

    private CommandUtils() {
    }

    public static boolean isChildSkill(CommandSender sender, SkillType skill) {
        if (skill == null || !skill.isChildSkill()) {
            return false;
        }
        sender.sendMessage("Child skills are not supported by this command.");
        return true;
    }

    public static boolean inspectOffline(CommandSender sender, PlayerProfile profile, boolean hasPermission) {
        if (CommandUtils.unloadedProfile(sender, profile)) {
            return true;
        }
        if (!hasPermission) {
            sender.sendMessage(LocaleLoader.getString("Inspect.Offline"));
            return true;
        }
        return false;
    }

    public static boolean tooFar(CommandSender sender, Player target, boolean hasPermission) {
        if (sender instanceof Player && !Misc.isNear(((Player)sender).getLocation(), target.getLocation(), Config.getInstance().getInspectDistance()) && !hasPermission) {
            sender.sendMessage(LocaleLoader.getString("Inspect.TooFar"));
            return true;
        }
        return false;
    }

    public static boolean hidden(CommandSender sender, Player target, boolean hasPermission) {
        return sender instanceof Player && !((Player)sender).canSee(target) && !hasPermission;
    }

    public static boolean noConsoleUsage(CommandSender sender) {
        if (sender instanceof Player) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.NoConsole"));
        return true;
    }

    public static boolean isOffline(CommandSender sender, OfflinePlayer player) {
        if (player.isOnline()) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Offline"));
        return true;
    }

    public static boolean checkPlayerExistence(CommandSender sender, String playerName, McMMOPlayer mcMMOPlayer) {
        if (mcMMOPlayer != null) {
            if (CommandUtils.hidden(sender, mcMMOPlayer.getPlayer(), false)) {
                sender.sendMessage(LocaleLoader.getString("Commands.Offline"));
                return false;
            }
            return true;
        }
        PlayerProfile profile = new PlayerProfile(playerName, false);
        if (CommandUtils.unloadedProfile(sender, profile)) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.DoesNotExist"));
        return false;
    }

    public static boolean unloadedProfile(CommandSender sender, PlayerProfile profile) {
        if (profile.isLoaded()) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Offline"));
        return true;
    }

    public static boolean hasPlayerDataKey(CommandSender sender) {
        if (sender == null || !(sender instanceof Player)) {
            return false;
        }
        boolean hasPlayerDataKey = ((Player)sender).hasMetadata("mcMMO: Player Data");
        if (!hasPlayerDataKey) {
            sender.sendMessage(LocaleLoader.getString("Commands.NotLoaded"));
        }
        return hasPlayerDataKey;
    }

    public static boolean isLoaded(CommandSender sender, PlayerProfile profile) {
        if (profile.isLoaded()) {
            return true;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.NotLoaded"));
        return false;
    }

    public static boolean isInvalidInteger(CommandSender sender, String value) {
        if (StringUtils.isInt(value)) {
            return false;
        }
        sender.sendMessage("That is not a valid integer.");
        return true;
    }

    public static boolean isInvalidDouble(CommandSender sender, String value) {
        if (StringUtils.isDouble(value)) {
            return false;
        }
        sender.sendMessage("That is not a valid percentage.");
        return true;
    }

    public static boolean isInvalidSkill(CommandSender sender, String skillName) {
        if (SkillUtils.isSkill(skillName)) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Skill.Invalid"));
        return true;
    }

    public static boolean shouldEnableToggle(String arg) {
        return arg.equalsIgnoreCase("on") || arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("enabled");
    }

    public static boolean shouldDisableToggle(String arg) {
        return arg.equalsIgnoreCase("off") || arg.equalsIgnoreCase("false") || arg.equalsIgnoreCase("disabled");
    }

    public static void printGatheringSkills(Player inspect, CommandSender display) {
        CommandUtils.printGroupedSkillData(inspect, display, LocaleLoader.getString("Stats.Header.Gathering"), SkillType.GATHERING_SKILLS);
    }

    public static void printGatheringSkills(Player player) {
        CommandUtils.printGatheringSkills(player, (CommandSender)player);
    }

    public static void printCombatSkills(Player inspect, CommandSender display) {
        CommandUtils.printGroupedSkillData(inspect, display, LocaleLoader.getString("Stats.Header.Combat"), SkillType.COMBAT_SKILLS);
    }

    public static void printCombatSkills(Player player) {
        CommandUtils.printCombatSkills(player, (CommandSender)player);
    }

    public static void printMiscSkills(Player inspect, CommandSender display) {
        CommandUtils.printGroupedSkillData(inspect, display, LocaleLoader.getString("Stats.Header.Misc"), SkillType.MISC_SKILLS);
    }

    public static void printMiscSkills(Player player) {
        CommandUtils.printMiscSkills(player, (CommandSender)player);
    }

    public static String displaySkill(PlayerProfile profile, SkillType skill) {
        if (skill.isChildSkill()) {
            return LocaleLoader.getString("Skills.ChildStats", LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".Listener") + " ", profile.getSkillLevel(skill));
        }
        return LocaleLoader.getString("Skills.Stats", LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".Listener") + " ", profile.getSkillLevel(skill), profile.getSkillXpLevel(skill), profile.getXpToLevel(skill));
    }

    private static void printGroupedSkillData(Player inspect, CommandSender display, String header, List<SkillType> skillGroup) {
        PlayerProfile profile = UserManager.getPlayer(inspect).getProfile();
        ArrayList<String> displayData = new ArrayList<String>();
        displayData.add(header);
        for (SkillType skill : skillGroup) {
            if (!skill.getPermissions(inspect)) continue;
            displayData.add(CommandUtils.displaySkill(profile, skill));
        }
        int size = displayData.size();
        if (size > 1) {
            display.sendMessage(displayData.toArray(new String[size]));
        }
    }

    public static List<String> getOnlinePlayerNames(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        ArrayList<String> onlinePlayerNames = new ArrayList<String>();
        for (Player onlinePlayer : mcMMO.p.getServer().getOnlinePlayers()) {
            if (player == null || !player.canSee(onlinePlayer)) continue;
            onlinePlayerNames.add(onlinePlayer.getName());
        }
        return onlinePlayerNames;
    }

    public static String getMatchedPlayerName(String partialName) {
        if (Config.getInstance().getMatchOfflinePlayers()) {
            List<String> matches = CommandUtils.matchPlayer(partialName);
            if (matches.size() == 1) {
                partialName = matches.get(0);
            }
        } else {
            Player player = mcMMO.p.getServer().getPlayer(partialName);
            if (player != null) {
                partialName = player.getName();
            }
        }
        return partialName;
    }

    private static List<String> matchPlayer(String partialName) {
        ArrayList<String> matchedPlayers = new ArrayList<String>();
        for (OfflinePlayer offlinePlayer : mcMMO.p.getServer().getOfflinePlayers()) {
            String playerName = offlinePlayer.getName();
            if (partialName.equalsIgnoreCase(playerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(playerName);
                break;
            }
            if (!playerName.toLowerCase().contains(partialName.toLowerCase())) continue;
            matchedPlayers.add(playerName);
        }
        return matchedPlayers;
    }
}

