/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.commands;

import com.gmail.nossr50.commands.KrakenCommand;
import com.gmail.nossr50.commands.McImportCommand;
import com.gmail.nossr50.commands.McabilityCommand;
import com.gmail.nossr50.commands.McconvertCommand;
import com.gmail.nossr50.commands.McgodCommand;
import com.gmail.nossr50.commands.McmmoCommand;
import com.gmail.nossr50.commands.McnotifyCommand;
import com.gmail.nossr50.commands.McrefreshCommand;
import com.gmail.nossr50.commands.McscoreboardCommand;
import com.gmail.nossr50.commands.MobhealthCommand;
import com.gmail.nossr50.commands.XprateCommand;
import com.gmail.nossr50.commands.chat.AdminChatCommand;
import com.gmail.nossr50.commands.chat.PartyChatCommand;
import com.gmail.nossr50.commands.database.McpurgeCommand;
import com.gmail.nossr50.commands.database.McremoveCommand;
import com.gmail.nossr50.commands.database.MmoshowdbCommand;
import com.gmail.nossr50.commands.experience.AddlevelsCommand;
import com.gmail.nossr50.commands.experience.AddxpCommand;
import com.gmail.nossr50.commands.experience.MmoeditCommand;
import com.gmail.nossr50.commands.experience.SkillresetCommand;
import com.gmail.nossr50.commands.hardcore.HardcoreCommand;
import com.gmail.nossr50.commands.hardcore.VampirismCommand;
import com.gmail.nossr50.commands.party.PartyCommand;
import com.gmail.nossr50.commands.party.teleport.PtpCommand;
import com.gmail.nossr50.commands.player.InspectCommand;
import com.gmail.nossr50.commands.player.MccooldownCommand;
import com.gmail.nossr50.commands.player.McrankCommand;
import com.gmail.nossr50.commands.player.McstatsCommand;
import com.gmail.nossr50.commands.player.MctopCommand;
import com.gmail.nossr50.commands.skills.AcrobaticsCommand;
import com.gmail.nossr50.commands.skills.AlchemyCommand;
import com.gmail.nossr50.commands.skills.ArcheryCommand;
import com.gmail.nossr50.commands.skills.AxesCommand;
import com.gmail.nossr50.commands.skills.ExcavationCommand;
import com.gmail.nossr50.commands.skills.FishingCommand;
import com.gmail.nossr50.commands.skills.HerbalismCommand;
import com.gmail.nossr50.commands.skills.MiningCommand;
import com.gmail.nossr50.commands.skills.RepairCommand;
import com.gmail.nossr50.commands.skills.SalvageCommand;
import com.gmail.nossr50.commands.skills.SmeltingCommand;
import com.gmail.nossr50.commands.skills.SwordsCommand;
import com.gmail.nossr50.commands.skills.TamingCommand;
import com.gmail.nossr50.commands.skills.UnarmedCommand;
import com.gmail.nossr50.commands.skills.WoodcuttingCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;

public final class CommandRegistrationManager {
    private static String permissionsMessage = LocaleLoader.getString("mcMMO.NoPermission");

    private CommandRegistrationManager() {
    }

    private static void registerSkillCommands() {
        block17: for (SkillType skill : SkillType.values()) {
            String commandName = skill.toString().toLowerCase();
            String localizedName = skill.getName().toLowerCase();
            PluginCommand command = mcMMO.p.getCommand(commandName);
            command.setDescription(LocaleLoader.getString("Commands.Description.Skill", StringUtils.getCapitalized(localizedName)));
            command.setPermission("mcmmo.commands." + commandName);
            command.setPermissionMessage(permissionsMessage);
            command.setUsage(LocaleLoader.getString("Commands.Usage.0", localizedName));
            command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", localizedName, "?", "[" + LocaleLoader.getString("Commands.Usage.Page") + "]"));
            switch (skill) {
                case ACROBATICS: {
                    command.setExecutor((CommandExecutor)new AcrobaticsCommand());
                    continue block17;
                }
                case ALCHEMY: {
                    command.setExecutor((CommandExecutor)new AlchemyCommand());
                    continue block17;
                }
                case ARCHERY: {
                    command.setExecutor((CommandExecutor)new ArcheryCommand());
                    continue block17;
                }
                case AXES: {
                    command.setExecutor((CommandExecutor)new AxesCommand());
                    continue block17;
                }
                case EXCAVATION: {
                    command.setExecutor((CommandExecutor)new ExcavationCommand());
                    continue block17;
                }
                case FISHING: {
                    command.setExecutor((CommandExecutor)new FishingCommand());
                    continue block17;
                }
                case HERBALISM: {
                    command.setExecutor((CommandExecutor)new HerbalismCommand());
                    continue block17;
                }
                case MINING: {
                    command.setExecutor((CommandExecutor)new MiningCommand());
                    continue block17;
                }
                case REPAIR: {
                    command.setExecutor((CommandExecutor)new RepairCommand());
                    continue block17;
                }
                case SALVAGE: {
                    command.setExecutor((CommandExecutor)new SalvageCommand());
                    continue block17;
                }
                case SMELTING: {
                    command.setExecutor((CommandExecutor)new SmeltingCommand());
                    continue block17;
                }
                case SWORDS: {
                    command.setExecutor((CommandExecutor)new SwordsCommand());
                    continue block17;
                }
                case TAMING: {
                    command.setExecutor((CommandExecutor)new TamingCommand());
                    continue block17;
                }
                case UNARMED: {
                    command.setExecutor((CommandExecutor)new UnarmedCommand());
                    continue block17;
                }
                case WOODCUTTING: {
                    command.setExecutor((CommandExecutor)new WoodcuttingCommand());
                    continue block17;
                }
            }
        }
    }

    private static void registerAddlevelsCommand() {
        PluginCommand command = mcMMO.p.getCommand("addlevels");
        command.setDescription(LocaleLoader.getString("Commands.Description.addlevels"));
        command.setPermission("mcmmo.commands.addlevels;mcmmo.commands.addlevels.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.3", "addlevels", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.Level") + ">"));
        command.setExecutor((CommandExecutor)new AddlevelsCommand());
    }

    private static void registerAddxpCommand() {
        PluginCommand command = mcMMO.p.getCommand("addxp");
        command.setDescription(LocaleLoader.getString("Commands.Description.addxp"));
        command.setPermission("mcmmo.commands.addxp;mcmmo.commands.addxp.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.3", "addxp", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.XP") + ">"));
        command.setExecutor((CommandExecutor)new AddxpCommand());
    }

    private static void registerMcgodCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcgod");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcgod"));
        command.setPermission("mcmmo.commands.mcgod;mcmmo.commands.mcgod.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcgod", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McgodCommand());
    }

    private static void registerMcrefreshCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcrefresh");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcrefresh"));
        command.setPermission("mcmmo.commands.mcrefresh;mcmmo.commands.mcrefresh.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcrefresh", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McrefreshCommand());
    }

    private static void registerMmoeditCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmoedit");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmoedit"));
        command.setPermission("mcmmo.commands.mmoedit;mcmmo.commands.mmoedit.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.3", "mmoedit", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.Level") + ">"));
        command.setExecutor((CommandExecutor)new MmoeditCommand());
    }

    private static void registerSkillresetCommand() {
        PluginCommand command = mcMMO.p.getCommand("skillreset");
        command.setDescription(LocaleLoader.getString("Commands.Description.skillreset"));
        command.setPermission("mcmmo.commands.skillreset;mcmmo.commands.skillreset.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "skillreset", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">"));
        command.setExecutor((CommandExecutor)new SkillresetCommand());
    }

    private static void registerXprateCommand() {
        ArrayList<String> aliasList = new ArrayList<String>();
        aliasList.add("mcxprate");
        PluginCommand command = mcMMO.p.getCommand("xprate");
        command.setDescription(LocaleLoader.getString("Commands.Description.xprate"));
        command.setPermission("mcmmo.commands.xprate;mcmmo.commands.xprate.reset;mcmmo.commands.xprate.set");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "xprate", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">", "<true|false>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "xprate", "reset"));
        command.setAliases(aliasList);
        command.setExecutor((CommandExecutor)new XprateCommand());
    }

    private static void registerInspectCommand() {
        PluginCommand command = mcMMO.p.getCommand("inspect");
        command.setDescription(LocaleLoader.getString("Commands.Description.inspect"));
        command.setPermission("mcmmo.commands.inspect;mcmmo.commands.inspect.far;mcmmo.commands.inspect.offline");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "inspect", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        command.setExecutor((CommandExecutor)new InspectCommand());
    }

    private static void registerMccooldownCommand() {
        PluginCommand command = mcMMO.p.getCommand("mccooldown");
        command.setDescription(LocaleLoader.getString("Commands.Description.mccooldown"));
        command.setPermission("mcmmo.commands.mccooldown");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mccooldowns"));
        command.setExecutor((CommandExecutor)new MccooldownCommand());
    }

    private static void registerMcabilityCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcability");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcability"));
        command.setPermission("mcmmo.commands.mcability;mcmmo.commands.mcability.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcability", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McabilityCommand());
    }

    private static void registerMcmmoCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcmmo");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcmmo"));
        command.setPermission("mcmmo.commands.mcmmo.description;mcmmo.commands.mcmmo.help");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcmmo"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "mcmmo", "help"));
        command.setExecutor((CommandExecutor)new McmmoCommand());
    }

    private static void registerMcrankCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcrank");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcrank"));
        command.setPermission("mcmmo.commands.mcrank;mcmmo.commands.mcrank.others;mcmmo.commands.mcrank.others.far;mcmmo.commands.mcrank.others.offline");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcrank", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McrankCommand());
    }

    private static void registerMcstatsCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcstats");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcstats"));
        command.setPermission("mcmmo.commands.mcstats");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcstats"));
        command.setExecutor((CommandExecutor)new McstatsCommand());
    }

    private static void registerMctopCommand() {
        PluginCommand command = mcMMO.p.getCommand("mctop");
        command.setDescription(LocaleLoader.getString("Commands.Description.mctop"));
        command.setPermission("mcmmo.commands.mctop");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "mctop", "[" + LocaleLoader.getString("Commands.Usage.Skill") + "]", "[" + LocaleLoader.getString("Commands.Usage.Page") + "]"));
        command.setExecutor((CommandExecutor)new MctopCommand());
    }

    private static void registerMcpurgeCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcpurge");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcpurge", Config.getInstance().getOldUsersCutoff()));
        command.setPermission("mcmmo.commands.mcpurge");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcpurge"));
        command.setExecutor((CommandExecutor)new McpurgeCommand());
    }

    private static void registerMcremoveCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcremove");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcremove"));
        command.setPermission("mcmmo.commands.mcremove");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcremove", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        command.setExecutor((CommandExecutor)new McremoveCommand());
    }

    private static void registerMmoshowdbCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmoshowdb");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmoshowdb"));
        command.setPermission("mcmmo.commands.mmoshowdb");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mmoshowdb"));
        command.setExecutor((CommandExecutor)new MmoshowdbCommand());
    }

    private static void registerMcconvertCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcconvert");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcconvert"));
        command.setPermission("mcmmo.commands.mcconvert;mcmmo.commands.mcconvert.experience;mcmmo.commands.mcconvert.database");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "mcconvert", "database", "<flatfile|sql>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mcconvert", "experience", "<linear|exponential>"));
        command.setExecutor((CommandExecutor)new McconvertCommand());
    }

    private static void registerAdminChatCommand() {
        PluginCommand command = mcMMO.p.getCommand("adminchat");
        command.setDescription(LocaleLoader.getString("Commands.Description.adminchat"));
        command.setPermission("mcmmo.chat.adminchat");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "adminchat"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "adminchat", "<on|off>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "adminchat", "<" + LocaleLoader.getString("Commands.Usage.Message") + ">"));
        command.setExecutor((CommandExecutor)new AdminChatCommand());
    }

    private static void registerPartyChatCommand() {
        PluginCommand command = mcMMO.p.getCommand("partychat");
        command.setDescription(LocaleLoader.getString("Commands.Description.partychat"));
        command.setPermission("mcmmo.chat.partychat;mcmmo.commands.party");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "partychat"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "partychat", "<on|off>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "partychat", "<" + LocaleLoader.getString("Commands.Usage.Message") + ">"));
        command.setExecutor((CommandExecutor)new PartyChatCommand());
    }

    private static void registerPartyCommand() {
        PluginCommand command = mcMMO.p.getCommand("party");
        command.setDescription(LocaleLoader.getString("Commands.Description.party"));
        command.setPermission("mcmmo.commands.party;mcmmo.commands.party.accept;mcmmo.commands.party.create;mcmmo.commands.party.disband;mcmmo.commands.party.xpshare;mcmmo.commands.party.invite;mcmmo.commands.party.itemshare;mcmmo.commands.party.join;mcmmo.commands.party.kick;mcmmo.commands.party.lock;mcmmo.commands.party.owner;mcmmo.commands.party.password;mcmmo.commands.party.quit;mcmmo.commands.party.rename;mcmmo.commands.party.unlock");
        command.setPermissionMessage(permissionsMessage);
        command.setExecutor((CommandExecutor)new PartyCommand());
    }

    private static void registerPtpCommand() {
        PluginCommand command = mcMMO.p.getCommand("ptp");
        command.setDescription(LocaleLoader.getString("Commands.Description.ptp"));
        command.setPermission("mcmmo.commands.ptp");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "ptp", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "ptp", "<toggle|accept|acceptall>"));
        command.setExecutor((CommandExecutor)new PtpCommand());
    }

    private static void registerHardcoreCommand() {
        PluginCommand command = mcMMO.p.getCommand("hardcore");
        command.setDescription(LocaleLoader.getString("Commands.Description.hardcore"));
        command.setPermission("mcmmo.commands.hardcore;mcmmo.commands.hardcore.toggle;mcmmo.commands.hardcore.modify");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "hardcore", "[on|off]"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "hardcore", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">"));
        command.setExecutor((CommandExecutor)new HardcoreCommand());
    }

    private static void registerVampirismCommand() {
        PluginCommand command = mcMMO.p.getCommand("vampirism");
        command.setDescription(LocaleLoader.getString("Commands.Description.vampirism"));
        command.setPermission("mcmmo.commands.vampirism;mcmmo.commands.vampirism.toggle;mcmmo.commands.vampirism.modify");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "vampirism", "[on|off]"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "vampirism", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">"));
        command.setExecutor((CommandExecutor)new VampirismCommand());
    }

    private static void registerMcnotifyCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcnotify");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcnotify"));
        command.setPermission("mcmmo.commands.mcnotify");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcnotify"));
        command.setExecutor((CommandExecutor)new McnotifyCommand());
    }

    private static void registerMobhealthCommand() {
        PluginCommand command = mcMMO.p.getCommand("mobhealth");
        command.setDescription("Change the style of the mob healthbar");
        command.setPermission("mcmmo.commands.mobhealth");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mobhealth", "<DISABLED | HEARTS | BAR>"));
        command.setExecutor((CommandExecutor)new MobhealthCommand());
    }

    private static void registerMcscoreboardCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcscoreboard");
        command.setDescription("Change the current mcMMO scoreboard being displayed");
        command.setPermission("mcmmo.commands.mcscoreboard");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcscoreboard", "<CLEAR | KEEP>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mcscoreboard", "time", "<seconds>"));
        command.setExecutor((CommandExecutor)new McscoreboardCommand());
    }

    private static void registerKrakenCommand() {
        PluginCommand command = mcMMO.p.getCommand("kraken");
        command.setDescription("Unleash the kraken!");
        command.setPermission("mcmmo.commands.kraken;mcmmo.commands.kraken.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "kraken", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new KrakenCommand());
    }

    private static void registerMcImportCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcimport");
        command.setDescription("Import mod config files");
        command.setPermission("mcmmo.commands.mcimport");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcimport"));
        command.setExecutor((CommandExecutor)new McImportCommand());
    }

    public static void registerCommands() {
        CommandRegistrationManager.registerMcImportCommand();
        CommandRegistrationManager.registerKrakenCommand();
        CommandRegistrationManager.registerMcabilityCommand();
        CommandRegistrationManager.registerMcgodCommand();
        CommandRegistrationManager.registerMcmmoCommand();
        CommandRegistrationManager.registerMcnotifyCommand();
        CommandRegistrationManager.registerMcrefreshCommand();
        CommandRegistrationManager.registerMcscoreboardCommand();
        CommandRegistrationManager.registerMobhealthCommand();
        CommandRegistrationManager.registerXprateCommand();
        CommandRegistrationManager.registerPartyChatCommand();
        CommandRegistrationManager.registerAdminChatCommand();
        CommandRegistrationManager.registerMcpurgeCommand();
        CommandRegistrationManager.registerMcremoveCommand();
        CommandRegistrationManager.registerMmoshowdbCommand();
        CommandRegistrationManager.registerMcconvertCommand();
        CommandRegistrationManager.registerAddlevelsCommand();
        CommandRegistrationManager.registerAddxpCommand();
        CommandRegistrationManager.registerMmoeditCommand();
        CommandRegistrationManager.registerSkillresetCommand();
        CommandRegistrationManager.registerHardcoreCommand();
        CommandRegistrationManager.registerVampirismCommand();
        CommandRegistrationManager.registerPartyCommand();
        CommandRegistrationManager.registerPtpCommand();
        CommandRegistrationManager.registerInspectCommand();
        CommandRegistrationManager.registerMccooldownCommand();
        CommandRegistrationManager.registerMcrankCommand();
        CommandRegistrationManager.registerMcstatsCommand();
        CommandRegistrationManager.registerMctopCommand();
        CommandRegistrationManager.registerSkillCommands();
    }
}

