/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta.conversion;

import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.blockmeta.conversion.BlockStoreConversionZDirectory;
import java.io.File;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class BlockStoreConversionXDirectory
implements Runnable {
    private int taskID = -1;
    private int i;
    private World world;
    BukkitScheduler scheduler;
    File dataDir;
    File[] zDirs;
    BlockStoreConversionZDirectory[] converters;

    public void start(World world, File dataDir) {
        this.world = world;
        this.scheduler = mcMMO.p.getServer().getScheduler();
        this.converters = new BlockStoreConversionZDirectory[HiddenConfig.getInstance().getConversionRate()];
        this.dataDir = dataDir;
        if (this.taskID >= 0) {
            return;
        }
        this.taskID = this.scheduler.runTaskLater((Plugin)mcMMO.p, (Runnable)this, 1L).getTaskId();
    }

    @Override
    public void run() {
        if (!this.dataDir.exists()) {
            this.stop();
            return;
        }
        if (!this.dataDir.isDirectory()) {
            this.dataDir.delete();
            this.stop();
            return;
        }
        if (this.dataDir.listFiles().length <= 0) {
            this.dataDir.delete();
            this.stop();
            return;
        }
        this.zDirs = this.dataDir.listFiles();
        this.i = 0;
        while (this.i < HiddenConfig.getInstance().getConversionRate() && this.i < this.zDirs.length) {
            if (this.converters[this.i] == null) {
                this.converters[this.i] = new BlockStoreConversionZDirectory();
            }
            this.converters[this.i].start(this.world, this.dataDir, this.zDirs[this.i]);
            ++this.i;
        }
        this.stop();
    }

    public void stop() {
        if (this.taskID < 0) {
            return;
        }
        this.scheduler.cancelTask(this.taskID);
        this.taskID = -1;
        this.dataDir = null;
        this.zDirs = null;
        this.world = null;
        this.scheduler = null;
        this.converters = null;
    }
}

